/*
 * Decompiled with CFR 0.152.
 */
package qu.quEnchantments.enchantments.weapon;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Optional;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1738;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1886;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import qu.quEnchantments.QuEnchantments;
import qu.quEnchantments.enchantments.CorruptedEnchantment;
import qu.quEnchantments.enchantments.ModEnchantments;
import qu.quEnchantments.util.ModTags;
import qu.quEnchantments.util.config.ModConfig;

public class NightbloodEnchantment
extends CorruptedEnchantment {
    private static final ModConfig.NightbloodOptions CONFIG = QuEnchantments.getConfig().nightbloodOptions;
    private static final ImmutableMap<class_1738.class_8051, Float> ARMOR_CHANCE_MAP = ImmutableMap.of((Object)class_1738.class_8051.field_41934, (Object)Float.valueOf(0.2f), (Object)class_1738.class_8051.field_41935, (Object)Float.valueOf(0.4f), (Object)class_1738.class_8051.field_41936, (Object)Float.valueOf(0.3f), (Object)class_1738.class_8051.field_41937, (Object)Float.valueOf(0.1f));

    public NightbloodEnchantment(CorruptedEnchantment.EnchantmentType enchantmentType, class_1887.class_1888 weight, class_1304 ... slotTypes) {
        super(enchantmentType, weight, class_1886.field_9074, slotTypes);
    }

    public int method_8182(int level) {
        return 10 + 20 * level;
    }

    public int method_20742(int level) {
        return this.method_8182(level) + 50;
    }

    public int method_8183() {
        return NightbloodEnchantment.CONFIG.isEnabled ? 2 : 0;
    }

    public boolean method_25950() {
        return NightbloodEnchantment.CONFIG.randomSelection;
    }

    public boolean method_25949() {
        return NightbloodEnchantment.CONFIG.bookOffer;
    }

    @Override
    public boolean isAvailableForEnchantingTable() {
        return NightbloodEnchantment.CONFIG.enchantingTable;
    }

    @Override
    public float getAttackDamage(class_1297 target, class_1799 stack, int level) {
        Optional entry;
        class_1309 livingEntity;
        class_1937 world = target.method_37908();
        if (world.field_9236 || !(target instanceof class_1309) || class_1890.method_8203((class_1887)ModEnchantments.OMEN_OF_IMMUNITY, (class_1309)(livingEntity = (class_1309)target)) > 0) {
            return 0.0f;
        }
        class_5819 random = world.method_8409();
        for (int x = 0; x < 25; ++x) {
            double deltaX = random.method_43059() * 0.02;
            double deltaY = random.method_43059() * 0.02;
            double deltaZ = random.method_43059() * 0.02;
            ((class_3218)world).method_14199((class_2394)class_2398.field_11237, target.method_23322(1.0), target.method_23319(), target.method_23325(1.0), 1, deltaX, deltaY, deltaZ, 0.0);
        }
        Optional key = class_7923.field_41177.method_29113((Object)target.method_5864());
        if (key.isPresent() && (entry = class_7923.field_41177.method_40264((class_5321)key.get())).isPresent() && ((class_6880.class_6883)entry.get()).method_40220(ModTags.NIGHTBLOOD_IMMUNE_ENTITIES)) {
            livingEntity.method_37222(new class_1293(class_1294.field_5920, NightbloodEnchantment.CONFIG.witherDuration, NightbloodEnchantment.CONFIG.witherAmplifier, false, true), (class_1297)livingEntity.method_6065());
            return 0.0f;
        }
        ArrayList armorItems = new ArrayList();
        livingEntity.method_5661().forEach(armorItems::add);
        ArrayList shuffledArmorItems = new ArrayList(armorItems);
        Collections.shuffle(shuffledArmorItems);
        for (class_1799 armorItemStack : shuffledArmorItems) {
            if (armorItemStack == class_1799.field_8037 || armorItemStack.method_31574(class_1802.field_8162)) continue;
            class_1738.class_8051 armorItemType = ((class_1738)armorItemStack.method_7909()).method_48398();
            if (!(random.method_43057() < ((Float)ARMOR_CHANCE_MAP.get((Object)armorItemType)).floatValue())) continue;
            armorItemStack.method_7956(1000000, livingEntity, livingEntityLambda -> livingEntityLambda.method_20235(class_1304.method_20234((class_1304.class_1305)class_1304.class_1305.field_6178, (int)armorItems.indexOf(armorItemStack))));
            return 0.0f;
        }
        if (NightbloodEnchantment.CONFIG.disablesExperience) {
            livingEntity.method_41329();
        }
        return 1000000.0f;
    }

    @Override
    public void tickWhileEquipped(class_1309 wearer, class_1799 stack, int level) {
        class_1937 world = wearer.method_37908();
        if (world.field_9236) {
            return;
        }
        if (wearer instanceof class_1657) {
            class_1657 player = (class_1657)wearer;
            if (player.method_31549().field_7477) {
                return;
            }
            if (player.field_7520 > 0 || player.field_7510 > 0.0f) {
                player.method_7255((int)(-4.0f * NightbloodEnchantment.CONFIG.drainRate / (float)level));
                return;
            }
            if (world.method_8407().method_5461() != 0 && player.method_7344().method_7586() > 0) {
                player.method_7344().method_7583(1.5f * NightbloodEnchantment.CONFIG.drainRate / (float)level);
                return;
            }
        }
        wearer.method_5643(world.method_48963().method_48831(), 2.0f * NightbloodEnchantment.CONFIG.drainRate / (float)level);
    }
}

