/*
 * Decompiled with CFR 0.152.
 */
package qu.quEnchantments.enchantments;

import java.util.ArrayList;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_7923;
import org.apache.commons.lang3.mutable.MutableFloat;
import qu.quEnchantments.enchantments.QuEnchantment;

public class QuEnchantmentHelper {
    public static float getAttackDamage(class_1799 weapon, class_1297 target) {
        MutableFloat mutableFloat = new MutableFloat();
        QuEnchantmentHelper.forEachQuEnchantment((QuEnchantment enchantment, class_1799 stack, int level) -> mutableFloat.add(enchantment.getAttackDamage(target, weapon, level)), weapon);
        return mutableFloat.floatValue();
    }

    public static void onTargetDamaged(class_1309 user, class_1799 weapon, class_1297 target) {
        Consumer consumer = (enchantment, stack, level) -> enchantment.onTargetDamaged(user, stack, target, level);
        if (user != null) {
            QuEnchantmentHelper.forEachQuEnchantment(consumer, weapon);
        }
    }

    public static void onBlock(class_1309 defender, class_1309 attacker) {
        QuEnchantmentHelper.forEachQuEnchantment((QuEnchantment enchantment, class_1799 stack, int level) -> enchantment.onBlock(defender, attacker, attacker.method_6047(), level), defender.method_6030());
    }

    public static void onBlockBroken(class_1657 player, class_2338 pos) {
        QuEnchantmentHelper.forEachQuEnchantment((QuEnchantment enchantment, class_1799 stack, int level) -> enchantment.onBlockBreak(player, pos, stack, level), player.method_6047());
    }

    public static void tickWhileEquipped(class_1309 entity) {
        ArrayList ticked = new ArrayList();
        QuEnchantmentHelper.forEachQuEnchantment((QuEnchantment enchantment, class_1799 stack, int level) -> {
            if (!enchantment.method_8185(entity).containsValue(stack) || ticked.contains((Object)enchantment)) {
                return;
            }
            ticked.add(enchantment);
            enchantment.tickWhileEquipped(entity, stack, level);
        }, entity.method_5743());
    }

    public static void tickEquippedWhileMoving(class_1309 entity, class_2338 pos) {
        ArrayList ticked = new ArrayList();
        QuEnchantmentHelper.forEachQuEnchantment((QuEnchantment enchantment, class_1799 stack, int level) -> {
            if (!enchantment.method_8185(entity).containsValue(stack) || ticked.contains((Object)enchantment)) {
                return;
            }
            ticked.add(enchantment);
            enchantment.tickEquippedWhileMoving(entity, pos, stack, level);
        }, entity.method_5743());
    }

    public static void tick(class_1309 holder, Iterable<class_1799> stacks) {
        ArrayList ticked = new ArrayList();
        QuEnchantmentHelper.forEachQuEnchantment((QuEnchantment enchantment, class_1799 stack, int level) -> {
            enchantment.tickAlways(holder, stack, level);
            if (ticked.contains((Object)enchantment)) {
                return;
            }
            ticked.add(enchantment);
            enchantment.tickOnce(holder, stack, level);
        }, stacks);
    }

    private static void forEachQuEnchantment(Consumer consumer, class_1799 stack) {
        if (stack == null || stack.method_7960()) {
            return;
        }
        class_2499 nbtList = stack.method_7921();
        for (int i = 0; i < nbtList.size(); ++i) {
            class_2487 compound = nbtList.method_10602(i);
            class_7923.field_41176.method_17966(class_1890.method_37427((class_2487)compound)).ifPresent(enchantment -> {
                if (enchantment instanceof QuEnchantment) {
                    consumer.accept((QuEnchantment)((Object)enchantment), stack, class_1890.method_37424((class_2487)compound));
                }
            });
        }
    }

    private static void forEachQuEnchantment(Consumer consumer, Iterable<class_1799> stacks) {
        for (class_1799 stack : stacks) {
            QuEnchantmentHelper.forEachQuEnchantment(consumer, stack);
        }
    }

    @FunctionalInterface
    static interface Consumer {
        public void accept(QuEnchantment var1, class_1799 var2, int var3);
    }
}

