/*
 * Decompiled with CFR 0.152.
 */
package qu.quEnchantments.enchantments;

import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import net.minecraft.class_124;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1886;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import qu.quEnchantments.enchantments.CompoundEnchantment;
import qu.quEnchantments.enchantments.QuEnchantment;
import qu.quEnchantments.util.ModTags;
import qu.quEnchantments.util.interfaces.IItemStack;

public abstract class CorruptedEnchantment
extends QuEnchantment {
    private final EnchantmentType enchantmentType;

    public CorruptedEnchantment(EnchantmentType enchantmentType, class_1887.class_1888 weight, class_1886 type, class_1304 ... slotTypes) {
        super(weight, type, slotTypes);
        this.enchantmentType = enchantmentType;
    }

    public class_2561 method_8179(int level) {
        Random random = new Random();
        class_5250 mutableText = class_2561.method_43471((String)this.method_8184());
        mutableText.method_27692(class_124.field_1076);
        if (random.nextFloat() < 0.02f * (float)level) {
            mutableText.method_27692(class_124.field_1051);
        }
        if (level != 1) {
            mutableText.method_27693(" ").method_10852((class_2561)class_2561.method_43471((String)("enchantment.level." + level)));
        }
        return mutableText;
    }

    public boolean method_8180(class_1887 other) {
        return !(other instanceof CorruptedEnchantment) && super.method_8180(other);
    }

    @Override
    public void tickAlways(class_1309 wearer, class_1799 stack, int level) {
        CorruptedEnchantment.corruptEnchantments(stack);
    }

    public static void corruptEnchantments(class_1799 stack) {
        if (stack == null || !stack.method_7942() && !stack.method_31574(class_1802.field_8598) || !((IItemStack)stack).isEnchantmentsDirty()) {
            return;
        }
        Map enchantments = class_1890.method_8222((class_1799)stack);
        CorruptedEnchantment corruptedEnchantment = null;
        int cLevel = 0;
        for (Map.Entry entry : enchantments.entrySet()) {
            if (!(entry.getKey() instanceof CorruptedEnchantment)) continue;
            corruptedEnchantment = (CorruptedEnchantment)((Object)entry.getKey());
            cLevel = (Integer)entry.getValue();
            break;
        }
        ((IItemStack)stack).setEnchantmentsDirty(false);
        if (corruptedEnchantment == null) {
            return;
        }
        int levels = 0;
        Set<class_1887> newSet = Set.copyOf(enchantments.keySet());
        for (class_1887 enchantment : newSet) {
            Optional entry;
            Optional key;
            if (!enchantment.method_8195() && (!(key = class_7923.field_41176.method_29113((Object)enchantment)).isPresent() || !(entry = class_7923.field_41176.method_40264((class_5321)key.get())).isPresent() || !((class_6880.class_6883)entry.get()).method_40220(corruptedEnchantment.enchantmentType.corruptible))) continue;
            int level = (Integer)enchantments.remove(enchantment);
            if (enchantment instanceof CompoundEnchantment) {
                level /= 5;
            }
            levels += level;
        }
        if (levels == cLevel) {
            ++levels;
        }
        levels = Math.min(Math.max(cLevel, levels), corruptedEnchantment.method_8183());
        enchantments.put(corruptedEnchantment, levels);
        if (stack.method_31574(class_1802.field_8598)) {
            stack.method_7983("StoredEnchantments");
        }
        class_1890.method_8214((Map)enchantments, (class_1799)stack);
    }

    public static enum EnchantmentType {
        DAMAGE(ModTags.WEAPON_DAMAGE_ENCHANTMENTS),
        ASPECT(ModTags.WEAPON_ASPECT_ENCHANTMENTS),
        WALKER(ModTags.ARMOR_FEET_WALKER_ENCHANTMENTS),
        THORNS(ModTags.ARMOR_THORNS_ENCHANTMENTS),
        RUNE(ModTags.RUNE_ENCHANTMENTS),
        PICKAXE_DROP(ModTags.MINING_TOOL_DROP_ENCHANTMENTS);

        private final class_6862<class_1887> corruptible;

        private EnchantmentType(class_6862<class_1887> tag) {
            this.corruptible = tag;
        }
    }
}

