/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.bakery.block.entity;

import de.cristelknight.doapi.common.world.ImplementedInventory;
import java.util.Objects;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3908;
import net.minecraft.class_3913;
import net.minecraft.class_3956;
import net.minecraft.class_5455;
import net.minecraft.class_5558;
import net.satisfy.bakery.block.CookingPotBlock;
import net.satisfy.bakery.client.gui.handler.CookingPotGuiHandler;
import net.satisfy.bakery.recipe.CookingPotRecipe;
import net.satisfy.bakery.registry.BlockEntityTypeRegistry;
import net.satisfy.bakery.registry.RecipeTypeRegistry;
import net.satisfy.bakery.registry.TagsRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CookingPotBlockEntity
extends class_2586
implements class_5558<CookingPotBlockEntity>,
ImplementedInventory,
class_3908 {
    private final class_2371<class_1799> inventory = class_2371.method_10213((int)8, (Object)class_1799.field_8037);
    private static final int MAX_CAPACITY = 8;
    public static final int MAX_COOKING_TIME = 600;
    private int cookingTime;
    protected static final int[] RECIPE_SLOTS = new int[]{1, 2, 3, 4, 5, 6};
    public static final int BOTTLE_INPUT_SLOT = 7;
    public static final int OUTPUT_SLOT = 0;
    private static final int INGREDIENTS_AREA = 6;
    private boolean isBeingBurned;
    private final class_3913 delegate = new class_3913(){

        public int method_17390(int index) {
            return switch (index) {
                case 0 -> CookingPotBlockEntity.this.cookingTime;
                case 1 -> {
                    if (CookingPotBlockEntity.this.isBeingBurned) {
                        yield 1;
                    }
                    yield 0;
                }
                default -> 0;
            };
        }

        public void method_17391(int index, int value) {
            switch (index) {
                case 0: {
                    CookingPotBlockEntity.this.cookingTime = value;
                    break;
                }
                case 1: {
                    CookingPotBlockEntity.this.isBeingBurned = value != 0;
                }
            }
        }

        public int method_17389() {
            return 2;
        }
    };

    public CookingPotBlockEntity(class_2338 pos, class_2680 state) {
        super((class_2591)BlockEntityTypeRegistry.COOKING_POT_BLOCK_ENTITY.get(), pos, state);
    }

    public int @NotNull [] method_5494(class_2350 side) {
        if (side.equals((Object)class_2350.field_11036)) {
            return RECIPE_SLOTS;
        }
        if (side.equals((Object)class_2350.field_11033)) {
            return new int[]{0};
        }
        return new int[]{7};
    }

    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        class_1262.method_5429((class_2487)nbt, this.inventory);
        this.cookingTime = nbt.method_10550("CookingTime");
    }

    protected void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        class_1262.method_5426((class_2487)nbt, this.inventory);
        nbt.method_10569("CookingTime", this.cookingTime);
    }

    public boolean isBeingBurned() {
        if (this.method_10997() == null) {
            throw new NullPointerException("Null world invoked");
        }
        class_2680 belowState = this.method_10997().method_8320(this.method_11016().method_10074());
        return belowState.method_26164(TagsRegistry.ALLOWS_COOKING);
    }

    private boolean canCraft(class_1860<?> recipe, class_5455 access) {
        if (recipe == null || recipe.method_8110(access).method_7960()) {
            return false;
        }
        if (recipe instanceof CookingPotRecipe) {
            CookingPotRecipe cookingRecipe = (CookingPotRecipe)recipe;
            if (!this.method_5438(7).method_31574(cookingRecipe.getContainer().method_7909())) {
                return false;
            }
            if (this.method_5438(0).method_7960()) {
                return true;
            }
            if (this.method_5438(0).method_7960()) {
                return true;
            }
            class_1799 recipeOutput = recipe.method_8110(access);
            class_1799 outputSlotStack = this.method_5438(0);
            int outputSlotCount = outputSlotStack.method_7947();
            if (this.method_5438(0).method_7960()) {
                return true;
            }
            if (!class_1799.method_31577((class_1799)outputSlotStack, (class_1799)recipeOutput)) {
                return false;
            }
            if (outputSlotCount < this.method_5444() && outputSlotCount < outputSlotStack.method_7914()) {
                return true;
            }
            return outputSlotCount < recipeOutput.method_7914();
        }
        return false;
    }

    private void craft(class_1860<?> recipe, class_5455 access) {
        if (!this.canCraft(recipe, access)) {
            return;
        }
        class_1799 recipeOutput = recipe.method_8110(access);
        class_1799 outputSlotStack = this.method_5438(0);
        if (outputSlotStack.method_7960()) {
            this.method_5447(0, recipeOutput.method_7972());
        } else if (outputSlotStack.method_31574(recipeOutput.method_7909())) {
            outputSlotStack.method_7933(recipeOutput.method_7947());
        }
        class_2371 ingredients = recipe.method_8117();
        boolean[] slotUsed = new boolean[6];
        for (int i = 0; i < recipe.method_8117().size(); ++i) {
            class_1799 bestSlot;
            class_1856 ingredient = (class_1856)ingredients.get(i);
            if (ingredient.method_8093(bestSlot = this.method_5438(i)) && !slotUsed[i]) {
                slotUsed[i] = true;
                class_1799 remainderStack = this.getRemainderItem(bestSlot);
                bestSlot.method_7934(1);
                if (remainderStack.method_7960()) continue;
                this.method_5447(i, remainderStack);
                continue;
            }
            for (int j = 0; j < 6; ++j) {
                class_1799 stack = this.method_5438(j);
                if (!ingredient.method_8093(stack) || slotUsed[j]) continue;
                slotUsed[j] = true;
                class_1799 remainderStack = this.getRemainderItem(stack);
                stack.method_7934(1);
                if (remainderStack.method_7960()) continue;
                this.method_5447(j, remainderStack);
            }
        }
        this.method_5438(7).method_7934(1);
    }

    private class_1799 getRemainderItem(class_1799 stack) {
        if (stack.method_7909().method_7857()) {
            return new class_1799((class_1935)Objects.requireNonNull(stack.method_7909().method_7858()));
        }
        return class_1799.field_8037;
    }

    public void tick(class_1937 world, class_2338 pos, class_2680 state, CookingPotBlockEntity blockEntity) {
        if (world.method_8608()) {
            return;
        }
        boolean isBeingBurned = this.isBeingBurned();
        if (!isBeingBurned) {
            this.delegate.method_17391(1, 0);
            if (((Boolean)state.method_11654((class_2769)CookingPotBlock.LIT)).booleanValue()) {
                world.method_8652(pos, (class_2680)state.method_11657((class_2769)CookingPotBlock.LIT, (Comparable)Boolean.valueOf(false)), 3);
            }
            return;
        }
        this.delegate.method_17391(1, 1);
        class_1860 recipe = world.method_8433().method_8132((class_3956)RecipeTypeRegistry.COOKING_POT_RECIPE_TYPE.get(), (class_1263)blockEntity, world).orElse(null);
        assert (this.field_11863 != null);
        class_5455 access = this.field_11863.method_30349();
        boolean canCraft = this.canCraft(recipe, access);
        if (canCraft) {
            ++this.cookingTime;
            if (this.cookingTime >= 600) {
                this.cookingTime = 0;
                this.craft(recipe, access);
            }
        } else if (!this.canCraft(recipe, access)) {
            this.cookingTime = 0;
        }
        if (canCraft) {
            world.method_8652(pos, (class_2680)((class_2680)this.method_11010().method_26204().method_9564().method_11657((class_2769)CookingPotBlock.COOKING, (Comparable)Boolean.valueOf(true))).method_11657((class_2769)CookingPotBlock.LIT, (Comparable)Boolean.valueOf(true)), 3);
        } else if (((Boolean)state.method_11654((class_2769)CookingPotBlock.COOKING)).booleanValue()) {
            world.method_8652(pos, (class_2680)((class_2680)this.method_11010().method_26204().method_9564().method_11657((class_2769)CookingPotBlock.COOKING, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)CookingPotBlock.LIT, (Comparable)Boolean.valueOf(true)), 3);
        } else if (!((Boolean)state.method_11654((class_2769)CookingPotBlock.LIT)).booleanValue()) {
            world.method_8652(pos, (class_2680)state.method_11657((class_2769)CookingPotBlock.LIT, (Comparable)Boolean.valueOf(true)), 3);
        }
    }

    public class_2371<class_1799> getItems() {
        return this.inventory;
    }

    public void method_5447(int slot, class_1799 stack) {
        this.inventory.set(slot, (Object)stack);
        if (stack.method_7947() > this.method_5444()) {
            stack.method_7939(this.method_5444());
        }
        this.method_5431();
    }

    public boolean method_5443(class_1657 player) {
        assert (this.field_11863 != null);
        if (this.field_11863.method_8321(this.field_11867) != this) {
            return false;
        }
        return player.method_5649((double)this.field_11867.method_10263() + 0.5, (double)this.field_11867.method_10264() + 0.5, (double)this.field_11867.method_10260() + 0.5) <= 64.0;
    }

    @NotNull
    public class_2561 method_5476() {
        return class_2561.method_43471((String)this.method_11010().method_26204().method_9539());
    }

    @Nullable
    public class_1703 createMenu(int syncId, class_1661 inv, class_1657 player) {
        return new CookingPotGuiHandler(syncId, inv, (class_1263)this, this.delegate);
    }
}

