/*
 * Decompiled with CFR 0.152.
 */
package commonnetwork.api;

import java.util.List;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2818;
import net.minecraft.class_3215;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public interface NetworkHandler {
    public <T> void sendToServer(T var1);

    public <T> void sendToServer(T var1, boolean var2);

    public <T> void sendToClient(T var1, class_3222 var2);

    default public <T> void sendToClients(T packet, List<class_3222> players) {
        for (class_3222 player : players) {
            this.sendToClient(packet, player);
        }
    }

    default public <T> void sendToAllClients(T packet, MinecraftServer server) {
        this.sendToClients(packet, server.method_3760().method_14571());
    }

    default public <T> void sendToClientsInLevel(T packet, class_3218 level) {
        this.sendToClients(packet, level.method_18456());
    }

    default public <T> void sendToClientsLoadingChunk(T packet, class_2818 chunk) {
        class_3215 chunkCache = (class_3215)chunk.method_12200().method_8398();
        this.sendToClients(packet, chunkCache.field_17254.method_17210(chunk.method_12004(), false));
    }

    default public <T> void sendToClientsLoadingPos(T packet, class_3218 level, class_1923 pos) {
        this.sendToClientsLoadingChunk(packet, level.method_8497(pos.field_9181, pos.field_9180));
    }

    default public <T> void sendToClientsLoadingPos(T packet, class_3218 level, class_2338 pos) {
        this.sendToClientsLoadingPos(packet, level, new class_1923(pos));
    }

    default public <T> void sendToClientsInRange(T packet, class_3218 level, class_2338 pos, double range) {
        for (class_3222 player : level.method_18456()) {
            if (!(player.method_5649((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260()) <= range * range)) continue;
            this.sendToClient(packet, player);
        }
    }
}

