/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.livingthings.entity;

import com.tristankechlo.livingthings.config.entity.PeacockConfig;
import com.tristankechlo.livingthings.entity.ai.PeacockDestroyCropBlocks;
import com.tristankechlo.livingthings.init.ModEntityTypes;
import com.tristankechlo.livingthings.init.ModSounds;
import com.tristankechlo.livingthings.util.ILexiconEntry;
import com.tristankechlo.livingthings.util.Ingredients;
import com.tristankechlo.livingthings.util.LexiconEntries;
import com.tristankechlo.livingthings.util.LivingThingsTags;
import net.minecraft.class_1282;
import net.minecraft.class_1296;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1314;
import net.minecraft.class_1341;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1353;
import net.minecraft.class_1361;
import net.minecraft.class_1374;
import net.minecraft.class_1376;
import net.minecraft.class_1391;
import net.minecraft.class_1394;
import net.minecraft.class_1429;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1920;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3730;
import net.minecraft.class_4802;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_6019;

public class PeacockEntity
extends class_1429
implements ILexiconEntry {
    private static final class_2940<Boolean> PANIC = class_2945.method_12791(PeacockEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> FLUFFED = class_2945.method_12791(PeacockEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> DESTROYING_CROPS = class_2945.method_12791(PeacockEntity.class, (class_2941)class_2943.field_13323);
    private static final class_6019 FLUFFED_TIME = class_4802.method_24505((int)10, (int)60);
    private int fluffedTime;

    public PeacockEntity(class_1299<? extends class_1429> type, class_1937 level) {
        super(type, level);
    }

    public static class_5132.class_5133 createAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, PeacockConfig.health()).method_26868(class_5134.field_23719, PeacockConfig.movementSpeed());
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(1, (class_1352)new PeacockPanicGoal((class_1314)this, 1.25));
        this.field_6201.method_6277(2, (class_1352)new class_1341((class_1429)this, 1.0));
        this.field_6201.method_6277(3, (class_1352)new class_1391((class_1314)this, 1.1, Ingredients.PEACOCK_FOOD, false));
        this.field_6201.method_6277(4, (class_1352)new class_1353((class_1429)this, 1.1));
        this.field_6201.method_6277(5, (class_1352)new PeacockDestroyCropBlocks(this));
        this.field_6201.method_6277(6, (class_1352)new class_1394((class_1314)this, 1.0));
        this.field_6201.method_6277(7, (class_1352)new class_1361((class_1308)this, class_1657.class, 6.0f));
        this.field_6201.method_6277(8, (class_1352)new class_1376((class_1308)this));
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(PANIC, (Object)false);
        this.field_6011.method_12784(FLUFFED, (Object)false);
        this.field_6011.method_12784(DESTROYING_CROPS, (Object)false);
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        this.field_6011.method_12778(FLUFFED, (Object)nbt.method_10577("Fluffed"));
        this.fluffedTime = nbt.method_10550("FluffedTime");
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10556("Fluffed", ((Boolean)this.field_6011.method_12789(FLUFFED)).booleanValue());
        nbt.method_10569("FluffedTime", this.fluffedTime);
    }

    public boolean method_6481(class_1799 stack) {
        return stack.method_31573(LivingThingsTags.PEACOCK_FOOD);
    }

    public static <T extends class_1429> boolean checkPeacockSpawnRules(class_1299<T> entityType, class_5425 world, class_3730 mobSpawnType, class_2338 pos, class_5819 randomSource) {
        return world.method_8320(pos.method_10074()).method_26164(LivingThingsTags.PEACOCK_SPAWNABLE_ON) && PeacockEntity.method_39448((class_1920)world, (class_2338)pos);
    }

    public class_1296 method_5613(class_3218 level, class_1296 parent) {
        return (class_1296)ModEntityTypes.PEACOCK.get().method_5883((class_1937)level);
    }

    public int method_5945() {
        return PeacockConfig.maxSpawnedInChunk();
    }

    public void setInPanic(boolean panic) {
        this.field_6011.method_12778(PANIC, (Object)panic);
    }

    public boolean isInPanic() {
        return (Boolean)this.field_6011.method_12789(PANIC) != false || this.method_6065() != null || this.method_40071() || this.method_5809();
    }

    public boolean isTailFluffed() {
        return this.isInPanic() || (Boolean)this.field_6011.method_12789(FLUFFED) != false;
    }

    public void startFluffing() {
        this.fluffedTime = FLUFFED_TIME.method_35008(this.field_5974);
        this.field_6011.method_12778(FLUFFED, (Object)true);
    }

    public void method_6480(class_1657 player) {
        super.method_6480(player);
        this.field_6011.method_12778(FLUFFED, (Object)true);
    }

    public void method_6477() {
        super.method_6477();
        this.startFluffing();
    }

    public void method_6007() {
        super.method_6007();
        if (this.isDestroyingCrops() && this.field_5974.method_43048(5) == 0) {
            class_2338 pos = this.method_24515();
            this.method_37908().method_20290(2001, pos, class_2248.method_9507((class_2680)class_2246.field_10362.method_9564()));
        }
        if (this.fluffedTime > 0) {
            --this.fluffedTime;
            if (this.fluffedTime == 0) {
                this.field_6011.method_12778(FLUFFED, (Object)false);
                return;
            }
        }
        if (!((Boolean)this.field_6011.method_12789(FLUFFED)).booleanValue() && this.field_5974.method_43048(4000) == 0) {
            this.startFluffing();
        }
    }

    @Override
    public class_2960 getLexiconEntry() {
        return LexiconEntries.PEACOCK;
    }

    public int method_5970() {
        return (Integer)PeacockConfig.get().talkInterval.get();
    }

    protected class_3414 method_5994() {
        return ModSounds.PEACOCK_AMBIENT.get();
    }

    protected class_3414 method_6011(class_1282 source) {
        return ModSounds.PEACOCK_HURT.get();
    }

    protected class_3414 method_6002() {
        return ModSounds.PEACOCK_DEATH.get();
    }

    public boolean isDestroyingCrops() {
        return (Boolean)this.field_6011.method_12789(DESTROYING_CROPS);
    }

    public void setDestroyingCrops(boolean eating) {
        this.field_6011.method_12778(DESTROYING_CROPS, (Object)eating);
    }

    private static class PeacockPanicGoal
    extends class_1374 {
        public PeacockPanicGoal(class_1314 mob, double speed) {
            super(mob, speed);
        }

        public void method_6269() {
            super.method_6269();
            ((PeacockEntity)this.field_6549).setInPanic(true);
        }

        public void method_6270() {
            super.method_6270();
            ((PeacockEntity)this.field_6549).setInPanic(false);
        }
    }
}

