/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.livingthings.entity;

import com.tristankechlo.livingthings.config.entity.FlamingoConfig;
import com.tristankechlo.livingthings.init.ModEntityTypes;
import com.tristankechlo.livingthings.util.ILexiconEntry;
import com.tristankechlo.livingthings.util.Ingredients;
import com.tristankechlo.livingthings.util.LexiconEntries;
import com.tristankechlo.livingthings.util.LivingThingsTags;
import java.util.EnumSet;
import net.minecraft.class_1296;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1314;
import net.minecraft.class_1341;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1353;
import net.minecraft.class_1361;
import net.minecraft.class_1374;
import net.minecraft.class_1376;
import net.minecraft.class_1379;
import net.minecraft.class_1391;
import net.minecraft.class_1429;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1920;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3730;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5534;
import net.minecraft.class_5819;
import net.minecraft.class_7;

public class FlamingoEntity
extends class_1429
implements ILexiconEntry {
    private static final class_2940<Boolean> LEFT_LEG_UP = class_2945.method_12791(FlamingoEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> RIGHT_LEG_UP = class_2945.method_12791(FlamingoEntity.class, (class_2941)class_2943.field_13323);
    protected DeepWaterAvoidingRandomWalkingGoal randomWalkingGoal;

    public FlamingoEntity(class_1299<? extends FlamingoEntity> type, class_1937 worldIn) {
        super(type, worldIn);
        this.method_49477(1.0f);
        this.method_5941(class_7.field_18, 1.0f);
    }

    public static boolean checkFlamingoSpawnRules(class_1299<FlamingoEntity> animal, class_1936 world, class_3730 reason, class_2338 pos, class_5819 random) {
        return world.method_8320(pos.method_10074()).method_26164(LivingThingsTags.FLAMINGO_SPAWNABLE_ON) && FlamingoEntity.method_39448((class_1920)world, (class_2338)pos);
    }

    public class_1296 method_5613(class_3218 world, class_1296 entity) {
        return (class_1296)ModEntityTypes.FLAMINGO.get().method_5883((class_1937)world);
    }

    public static class_5132.class_5133 createAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, FlamingoConfig.health()).method_26868(class_5134.field_23719, FlamingoConfig.movementSpeed());
    }

    protected void method_5959() {
        this.randomWalkingGoal = new DeepWaterAvoidingRandomWalkingGoal(this, 1.0, 50);
        this.field_6201.method_6277(0, (class_1352)new SwimInDeepWaterGoal(this));
        this.field_6201.method_6277(1, (class_1352)new class_1374((class_1314)this, 1.2));
        this.field_6201.method_6277(2, (class_1352)new class_1341((class_1429)this, 1.1));
        this.field_6201.method_6277(3, (class_1352)new class_1391((class_1314)this, 1.1, Ingredients.FLAMINGO_FOOD, false));
        this.field_6201.method_6277(4, (class_1352)new class_1353((class_1429)this, 1.2));
        this.field_6201.method_6277(5, (class_1352)new LiftLegsGoal(this, 15));
        this.field_6201.method_6277(5, (class_1352)this.randomWalkingGoal);
        this.field_6201.method_6277(6, (class_1352)new class_1376((class_1308)this));
        this.field_6201.method_6277(7, (class_1352)new class_1361((class_1308)this, class_1657.class, 8.0f));
        this.field_6201.method_6277(8, (class_1352)new class_1361((class_1308)this, FlamingoEntity.class, 8.0f));
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(LEFT_LEG_UP, (Object)false);
        this.field_6011.method_12784(RIGHT_LEG_UP, (Object)false);
    }

    public boolean method_6481(class_1799 stack) {
        return stack.method_31573(LivingThingsTags.FLAMINGO_FOOD);
    }

    protected float method_18394(class_4050 pose, class_4048 size) {
        return size.field_18068 * 0.99f;
    }

    protected float method_6120() {
        return 0.98f;
    }

    public int method_5945() {
        return FlamingoConfig.maxSpawnedInChunk();
    }

    public boolean isLeftLegUp() {
        return (Boolean)this.field_6011.method_12789(LEFT_LEG_UP);
    }

    public boolean isRightLegUp() {
        return (Boolean)this.field_6011.method_12789(RIGHT_LEG_UP);
    }

    public void setLeftLegUp(boolean up) {
        this.field_6011.method_12778(LEFT_LEG_UP, (Object)up);
    }

    public void setRightLegUp(boolean up) {
        this.field_6011.method_12778(RIGHT_LEG_UP, (Object)up);
    }

    @Override
    public class_2960 getLexiconEntry() {
        return LexiconEntries.FLAMINGO;
    }

    static class DeepWaterAvoidingRandomWalkingGoal
    extends class_1379 {
        private final FlamingoEntity flamingo;

        public DeepWaterAvoidingRandomWalkingGoal(FlamingoEntity creatureIn, double speedIn, int chance) {
            super((class_1314)creatureIn, speedIn, chance);
            this.flamingo = creatureIn;
        }

        protected class_243 method_6302() {
            if (this.flamingo.field_6000) {
                class_243 vector3d = class_5534.method_31527((class_1314)this.field_6566, (int)15, (int)7);
                return vector3d == null ? super.method_6302() : vector3d;
            }
            return class_5534.method_31527((class_1314)this.field_6566, (int)10, (int)7);
        }
    }

    static class SwimInDeepWaterGoal
    extends class_1347 {
        private final FlamingoEntity flamingo;

        public SwimInDeepWaterGoal(FlamingoEntity entityIn) {
            super((class_1308)entityIn);
            this.flamingo = entityIn;
        }

        public boolean method_6264() {
            return this.flamingo.field_6000 && super.method_6264();
        }

        public void method_6268() {
            this.flamingo.randomWalkingGoal.method_6304();
            super.method_6268();
        }
    }

    static class LiftLegsGoal
    extends class_1352 {
        private final FlamingoEntity flamingo;
        private final int chance;
        private int rightLegCounter;
        private int leftLegCounter;

        public LiftLegsGoal(FlamingoEntity flamingo, int chance) {
            this.flamingo = flamingo;
            this.chance = chance;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405));
        }

        public boolean method_6264() {
            if (this.flamingo.method_6051().method_43048(this.chance) != 0) {
                return false;
            }
            return !this.flamingo.isRightLegUp() && !this.flamingo.isLeftLegUp() && this.flamingo.method_5942().method_6357();
        }

        public boolean method_6266() {
            return this.flamingo.method_5942().method_6357() && (this.flamingo.isRightLegUp() || this.flamingo.isLeftLegUp());
        }

        public void method_6270() {
            this.leftLegCounter = 0;
            this.rightLegCounter = 0;
            this.flamingo.setLeftLegUp(false);
            this.flamingo.setRightLegUp(false);
        }

        public void method_6268() {
            if (this.leftLegCounter > 0) {
                --this.leftLegCounter;
            } else if (this.leftLegCounter <= 0) {
                this.leftLegCounter = 0;
                this.flamingo.setLeftLegUp(false);
            }
            if (this.rightLegCounter > 0) {
                --this.rightLegCounter;
            } else if (this.rightLegCounter <= 0) {
                this.rightLegCounter = 0;
                this.flamingo.setRightLegUp(false);
            }
            if (this.rightLegCounter == 0 && this.leftLegCounter == 0 && Math.random() < (double)0.1f) {
                if (Math.random() < 0.5) {
                    this.leftLegCounter = 500;
                    this.flamingo.setLeftLegUp(true);
                } else {
                    this.rightLegCounter = 500;
                    this.flamingo.setRightLegUp(true);
                }
            }
        }
    }
}

