/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.livingthings.config.values;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import com.mojang.datafixers.util.Either;
import com.tristankechlo.livingthings.LivingThings;
import com.tristankechlo.livingthings.config.util.IConfig;
import java.util.ArrayList;
import net.minecraft.class_1792;
import net.minecraft.class_1856;
import net.minecraft.class_1869;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7924;

public final class IngredientValue
implements IConfig.Value<class_1856> {
    private final String identifier;
    private final class_1856 defaultValue;
    private class_1856 value;

    public IngredientValue(String identifier, class_1792 ... items) {
        this(identifier, class_1856.method_8091((class_1935[])items));
    }

    public IngredientValue(String identifier, class_1856 defaultValue) {
        this.identifier = identifier;
        this.defaultValue = defaultValue;
        this.value = defaultValue;
    }

    @Override
    public void setToDefault() {
        this.value = this.defaultValue;
    }

    @Override
    public JsonElement serialize(JsonObject json) {
        JsonElement element = this.get().method_8089();
        json.add(this.getIdentifier(), element);
        return json;
    }

    @Override
    public void deserialize(JsonObject json) {
        if (json.has(this.getIdentifier())) {
            try {
                JsonElement element = json.get(this.getIdentifier());
                this.value = this.deserialize(element);
            }
            catch (Exception e) {
                LivingThings.LOGGER.warn("Failed to parse value '{}' as Ingredient, using default value.", (Object)this.getIdentifier());
                this.setToDefault();
            }
        } else {
            LivingThings.LOGGER.warn("No value '{}' was found, using default value.", (Object)this.getIdentifier());
            this.setToDefault();
        }
    }

    @Override
    public class_1856 get() {
        return this.value;
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    private class_1856 deserialize(JsonElement jsonElement) {
        if (jsonElement == null || jsonElement.isJsonNull()) {
            throw new JsonSyntaxException("Ingredient '" + this.getIdentifier() + "' cannot be null");
        }
        if (jsonElement.isJsonObject()) {
            return IngredientValue.deserializeSingle(class_3518.method_15295((JsonElement)jsonElement, (String)this.getIdentifier()));
        }
        if (jsonElement.isJsonArray()) {
            JsonArray jsonArray = jsonElement.getAsJsonArray();
            if (jsonArray.size() == 0) {
                throw new JsonSyntaxException("Item array cannot be empty, at least one item must be defined");
            }
            ArrayList list = new ArrayList();
            jsonArray.forEach(element -> {
                JsonObject json = class_3518.method_15295((JsonElement)element, (String)"item");
                if (!json.has("item")) {
                    LivingThings.LOGGER.warn("Element '{}' is missing 'item' key, skipping...", (Object)json);
                    return;
                }
                class_1792 item = class_1869.method_8155((JsonObject)json);
                list.add(item);
            });
            return class_1856.method_8091((class_1935[])((class_1935[])list.toArray(new class_1792[0])));
        }
        throw new JsonSyntaxException("Expected item to be object or array of objects");
    }

    private static class_1856 deserializeSingle(JsonObject jsonObject) {
        Either<class_1792, class_6862<class_1792>> either = IngredientValue.deserializeO(jsonObject);
        if (either.left().isPresent()) {
            return class_1856.method_8091((class_1935[])new class_1935[]{(class_1935)either.left().get()});
        }
        return class_1856.method_8106((class_6862)((class_6862)either.right().get()));
    }

    private static Either<class_1792, class_6862<class_1792>> deserializeO(JsonObject json) {
        if (json.has("item") && json.has("tag")) {
            throw new JsonParseException("An ingredient entry is either a tag or an item, not both");
        }
        if (json.has("item")) {
            return Either.left((Object)class_1869.method_8155((JsonObject)json));
        }
        if (json.has("tag")) {
            class_2960 resourceLocation = new class_2960(class_3518.method_15265((JsonObject)json, (String)"tag"));
            class_6862 tagKey = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)resourceLocation);
            return Either.right((Object)tagKey);
        }
        throw new JsonParseException("An ingredient entry needs either a tag or an item");
    }
}

