/*
 * Decompiled with CFR 0.152.
 */
package net.emilsg.clutter.world.gen.tree;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.function.BiConsumer;
import net.emilsg.clutter.block.ModBlocks;
import net.emilsg.clutter.world.gen.type.ModTrunkPlacerTypes;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_3031;
import net.minecraft.class_3481;
import net.minecraft.class_3746;
import net.minecraft.class_4643;
import net.minecraft.class_4647;
import net.minecraft.class_4651;
import net.minecraft.class_5141;
import net.minecraft.class_5142;
import net.minecraft.class_5819;

public class RedwoodTrunkPlacer
extends class_5141 {
    public static final Codec<RedwoodTrunkPlacer> CODEC = RecordCodecBuilder.create(instance -> RedwoodTrunkPlacer.method_28904((RecordCodecBuilder.Instance)instance).apply((Applicative)instance, RedwoodTrunkPlacer::new));

    public RedwoodTrunkPlacer(int baseHeight, int firstRandomHeight, int secondRandomHeight) {
        super(baseHeight, firstRandomHeight, secondRandomHeight);
    }

    protected static void setToDirt(class_3746 world, BiConsumer<class_2338, class_2680> replacer, class_5819 random, class_2338 pos, class_4643 config) {
        if (config.field_29281 || !RedwoodTrunkPlacer.canGenerate(world, pos)) {
            if (world.method_16358(pos, RedwoodTrunkPlacer::isOvergrown)) {
                replacer.accept(pos, class_4651.method_38432((class_2248)ModBlocks.OVERGROWN_PACKED_MUD).method_23455(random, pos));
            } else if (world.method_16358(pos, RedwoodTrunkPlacer::isDirt)) {
                replacer.accept(pos, class_4651.method_38432((class_2248)class_2246.field_10566).method_23455(random, pos));
            }
        }
    }

    private static boolean canGenerate(class_3746 world, class_2338 pos) {
        return world.method_16358(pos, state -> class_3031.method_23396((class_2680)state) && !state.method_27852(class_2246.field_10219) && !state.method_27852(class_2246.field_10402));
    }

    public static boolean isOvergrown(class_2680 state) {
        return state.method_27852(ModBlocks.OVERGROWN_PACKED_MUD);
    }

    public static boolean isDirt(class_2680 state) {
        return state.method_26164(class_3481.field_29822) && !state.method_27852(ModBlocks.OVERGROWN_PACKED_MUD);
    }

    protected class_5142<?> method_28903() {
        return ModTrunkPlacerTypes.REDWOOD_TRUNK_PLACER;
    }

    public List<class_4647.class_5208> method_26991(class_3746 world, BiConsumer<class_2338, class_2680> replacer, class_5819 random, int height, class_2338 startPos, class_4643 config) {
        class_2338 blockPos = startPos.method_10074();
        RedwoodTrunkPlacer.setToDirt(world, replacer, random, blockPos, config);
        RedwoodTrunkPlacer.setToDirt(world, replacer, random, blockPos.method_10078(), config);
        RedwoodTrunkPlacer.setToDirt(world, replacer, random, blockPos.method_10072(), config);
        RedwoodTrunkPlacer.setToDirt(world, replacer, random, blockPos.method_10095(), config);
        RedwoodTrunkPlacer.setToDirt(world, replacer, random, blockPos.method_10067(), config);
        RedwoodTrunkPlacer.setToDirt(world, replacer, random, blockPos.method_10072().method_10078(), config);
        RedwoodTrunkPlacer.setToDirt(world, replacer, random, blockPos.method_10072().method_10067(), config);
        RedwoodTrunkPlacer.setToDirt(world, replacer, random, blockPos.method_10095().method_10078(), config);
        RedwoodTrunkPlacer.setToDirt(world, replacer, random, blockPos.method_10095().method_10067(), config);
        class_2338.class_2339 mutable = new class_2338.class_2339();
        for (int currentHeight = -4; currentHeight < height; ++currentHeight) {
            int layerRadius = this.calculateRadiusForLayer(currentHeight, height);
            int nextLayerRadius = currentHeight < height - 1 ? this.calculateRadiusForLayer(currentHeight + 1, height) : layerRadius;
            boolean isInTopHalf = nextLayerRadius < layerRadius;
            for (int dx = -layerRadius; dx <= layerRadius; ++dx) {
                for (int dz = -layerRadius; dz <= layerRadius; ++dz) {
                    boolean isOuterPartOfLayer;
                    if (dx * dx + dz * dz > layerRadius * layerRadius) continue;
                    boolean isWithinNextLayer = dx * dx + dz * dz <= nextLayerRadius * nextLayerRadius;
                    boolean bl = isOuterPartOfLayer = dx * dx + dz * dz >= (layerRadius - 1) * (layerRadius - 1);
                    if (isInTopHalf && !isWithinNextLayer && (!isOuterPartOfLayer || !random.method_43056())) continue;
                    this.setLog(world, replacer, random, mutable, config, startPos, dx, currentHeight, dz);
                }
            }
        }
        return ImmutableList.of((Object)new class_4647.class_5208(startPos.method_10086(height), 0, true));
    }

    public int method_26993(class_5819 random) {
        return this.field_23760 + 8 + random.method_43048(this.field_23761 * 4) + random.method_43048(this.field_23762 * 4);
    }

    private int calculateRadiusForLayer(int currentHeight, int totalHeight) {
        if ((double)currentHeight < (double)totalHeight * 0.05) {
            return 3;
        }
        if ((double)currentHeight < (double)totalHeight * 0.3) {
            return 2;
        }
        if ((double)currentHeight < (double)totalHeight * 0.7) {
            return 1;
        }
        return 0;
    }

    private void setLog(class_3746 world, BiConsumer<class_2338, class_2680> replacer, class_5819 random, class_2338.class_2339 tmpPos, class_4643 config, class_2338 startPos, int dx, int dy, int dz) {
        tmpPos.method_25504((class_2382)startPos, dx, dy, dz);
        this.method_27401(world, replacer, random, tmpPos, config);
    }
}

