/*
 * Decompiled with CFR 0.152.
 */
package net.emilsg.clutter.entity.custom;

import net.emilsg.clutter.entity.ModEntities;
import net.emilsg.clutter.entity.custom.goal.MossbloomDropHornsGoal;
import net.emilsg.clutter.entity.custom.parent.ClutterAnimalEntity;
import net.emilsg.clutter.entity.variants.MossbloomVariant;
import net.minecraft.class_1266;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1303;
import net.minecraft.class_1308;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1341;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1353;
import net.minecraft.class_1361;
import net.minecraft.class_1374;
import net.minecraft.class_1376;
import net.minecraft.class_1391;
import net.minecraft.class_1394;
import net.minecraft.class_1429;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_174;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1920;
import net.minecraft.class_1928;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3468;
import net.minecraft.class_3730;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_7;
import net.minecraft.class_7094;
import org.jetbrains.annotations.Nullable;

public class MossbloomEntity
extends ClutterAnimalEntity {
    private static final class_2940<Integer> VARIANT = class_2945.method_12791(MossbloomEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Boolean> HAS_HORNS = class_2945.method_12791(MossbloomEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Integer> HORN_DROP_TIMER = class_2945.method_12791(MossbloomEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Integer> TIME_TILL_DROP = class_2945.method_12791(MossbloomEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Boolean> IS_SHAKING = class_2945.method_12791(MossbloomEntity.class, (class_2941)class_2943.field_13323);
    public final class_7094 idleAnimationState = new class_7094();
    public final class_7094 shakingAnimationState = new class_7094();
    public final class_7094 earTwitchAnimationStateLE = new class_7094();
    public final class_7094 earTwitchAnimationStateRE = new class_7094();
    public final class_7094 earTwitchAnimationStateBE = new class_7094();
    public int idleAnimationTimeout = 0;
    public int shakingAnimationTimeout = 0;
    public int earTwitchAnimationTimeout = 0;
    public static int SHOULD_DROP_HORNS_VALUE = 12000;

    public MossbloomEntity(class_1299<? extends ClutterAnimalEntity> entityType, class_1937 world) {
        super(entityType, world);
        this.method_5941(class_7.field_9, -1.0f);
        this.method_5941(class_7.field_18, -1.0f);
        this.method_5941(class_7.field_4, 16.0f);
    }

    private void setupAnimationStates() {
        if (this.shakingAnimationTimeout <= 0 && this.getIsShaking()) {
            this.shakingAnimationTimeout = 60;
            this.shakingAnimationState.method_41322(this.field_6012);
        } else {
            --this.shakingAnimationTimeout;
        }
        if (this.idleAnimationTimeout <= 0 && !this.isMoving()) {
            this.idleAnimationTimeout = 10;
            this.idleAnimationState.method_41324(this.field_6012);
        } else {
            --this.idleAnimationTimeout;
        }
        if (this.earTwitchAnimationTimeout <= 0 && this.field_5974.method_43048(100) == 0) {
            this.earTwitchAnimationTimeout = 5;
            this.pickRandomIdleAnim(this.field_5974.method_43048(3));
        } else {
            --this.earTwitchAnimationTimeout;
        }
    }

    private void pickRandomIdleAnim(int i) {
        switch (i) {
            default: {
                this.earTwitchAnimationStateBE.method_41324(this.field_6012);
                break;
            }
            case 1: {
                this.earTwitchAnimationStateRE.method_41324(this.field_6012);
                break;
            }
            case 2: {
                this.earTwitchAnimationStateLE.method_41324(this.field_6012);
            }
        }
    }

    public static class_5132.class_5133 setAttributes() {
        return ClutterAnimalEntity.method_26828().method_26868(class_5134.field_23716, 20.0).method_26868(class_5134.field_23719, (double)0.2f).method_26868(class_5134.field_23723, 1.0).method_26868(class_5134.field_23722, 0.5).method_26868(class_5134.field_23721, 6.0).method_26868(class_5134.field_23717, 16.0);
    }

    public static boolean isValidNaturalSpawn(class_1299<? extends class_1429> type, class_1936 world, class_3730 spawnReason, class_2338 pos, class_5819 random) {
        return MossbloomEntity.isValidLushSpawn(type, world, spawnReason, pos, random) && MossbloomEntity.isLightLevelValidForNaturalSpawn((class_1920)world, pos);
    }

    public static boolean isValidLushSpawn(class_1299<? extends class_1429> type, class_1936 world, class_3730 spawnReason, class_2338 pos, class_5819 random) {
        return world.method_8320(pos.method_10074()).method_27852(class_2246.field_28681) || world.method_8320(pos.method_10074()).method_27852(class_2246.field_28680) || world.method_8320(pos.method_10074()).method_27852(class_2246.field_10460);
    }

    public int method_5945() {
        return 2;
    }

    protected static boolean isLightLevelValidForNaturalSpawn(class_1920 world, class_2338 pos) {
        return true;
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new MossbloomDropHornsGoal(this));
        this.field_6201.method_6277(1, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(2, (class_1352)new class_1374((class_1314)this, 1.5));
        this.field_6201.method_6277(3, (class_1352)new class_1341((class_1429)this, 1.0));
        this.field_6201.method_6277(4, (class_1352)new class_1391((class_1314)this, 1.25, class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_28657}), false));
        this.field_6201.method_6277(5, (class_1352)new class_1353((class_1429)this, 1.0));
        this.field_6201.method_6277(6, (class_1352)new class_1394((class_1314)this, 1.0, 1.0f));
        this.field_6201.method_6277(7, (class_1352)new class_1361((class_1308)this, class_1657.class, 6.0f));
        this.field_6201.method_6277(8, (class_1352)new class_1376((class_1308)this));
    }

    public boolean method_5979(class_1936 world, class_3730 spawnReason) {
        class_2338 pos = this.method_24515();
        class_2680 blockState = world.method_8320(pos.method_10074());
        return blockState.method_27852(class_2246.field_10219) || blockState.method_27852(class_2246.field_10340) || blockState.method_27852(class_2246.field_28681) || blockState.method_27852(class_2246.field_10460);
    }

    @Override
    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(VARIANT, (Object)0);
        this.field_6011.method_12784(HAS_HORNS, (Object)true);
        this.field_6011.method_12784(HORN_DROP_TIMER, (Object)0);
        this.field_6011.method_12784(IS_SHAKING, (Object)false);
        this.field_6011.method_12784(TIME_TILL_DROP, (Object)0);
    }

    public boolean method_6481(class_1799 stack) {
        return stack.method_31574(class_1802.field_28657);
    }

    public boolean method_5931(class_1657 player) {
        return true;
    }

    public boolean method_6474(class_1429 other) {
        if (other == this) {
            return false;
        }
        if (other.getClass() != ((Object)((Object)this)).getClass()) {
            return false;
        }
        if (((MossbloomEntity)other).getVariant().getId() == this.getVariant().getId()) {
            return false;
        }
        return this.method_6479() && other.method_6479();
    }

    public void method_24650(class_3218 world, class_1429 other) {
        MossbloomEntity child = (MossbloomEntity)this.method_5613(world, (class_1296)other);
        if (child != null) {
            class_3222 serverPlayerEntity = this.method_6478();
            if (serverPlayerEntity == null && other.method_6478() != null) {
                serverPlayerEntity = other.method_6478();
            }
            if (serverPlayerEntity != null) {
                serverPlayerEntity.method_7281(class_3468.field_15410);
                class_174.field_1190.method_855(serverPlayerEntity, (class_1429)this, other, (class_1296)child);
            }
            this.method_5614(6000);
            other.method_5614(6000);
            this.method_6477();
            other.method_6477();
            child.method_7217(true);
            boolean isVariantM = this.field_5974.method_43056();
            child.setVariant(isVariantM ? MossbloomVariant.M : MossbloomVariant.F);
            child.setHasHorns(isVariantM);
            if (isVariantM) {
                child.setHornDropTimer(-SHOULD_DROP_HORNS_VALUE);
            }
            child.method_5808(this.method_23317(), this.method_23318(), this.method_23321(), 0.0f, 0.0f);
            world.method_30771((class_1297)child);
            world.method_8421((class_1297)this, (byte)18);
            if (world.method_8450().method_8355(class_1928.field_19391)) {
                world.method_8649((class_1297)new class_1303((class_1937)world, this.method_23317(), this.method_23318(), this.method_23321(), this.method_6051().method_43048(7) + 1));
            }
        }
    }

    public void method_5773() {
        super.method_5773();
        class_1937 world = this.method_37908();
        if (world.field_9236) {
            this.setupAnimationStates();
        }
        if (this.getVariant() == MossbloomVariant.M && !this.method_6109()) {
            if (this.getHornDropTimer() >= SHOULD_DROP_HORNS_VALUE / 3) {
                this.setHasHorns(true);
            }
            this.setHornDropTimer(this.getHornDropTimer() + this.field_5974.method_43048(1) + 1);
        }
        if (this.getVariant() == MossbloomVariant.M && this.method_6109()) {
            this.setHasHorns(false);
        }
    }

    protected void method_5619() {
        super.method_5619();
        if (!this.method_6109() && this.getVariant() == MossbloomVariant.M) {
            this.setHasHorns(true);
        }
    }

    @Override
    @Nullable
    public class_1296 method_5613(class_3218 world, class_1296 entity) {
        MossbloomEntity child = (MossbloomEntity)ModEntities.MOSSBLOOM.method_5883((class_1937)world);
        assert (child != null);
        child.setVariant((MossbloomVariant)((Object)class_156.method_27173((Object[])MossbloomVariant.values(), (class_5819)this.field_5974)));
        return child;
    }

    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData, @Nullable class_2487 entityNbt) {
        MossbloomVariant variant = (MossbloomVariant)((Object)class_156.method_27173((Object[])MossbloomVariant.values(), (class_5819)this.field_5974));
        this.setVariant(variant);
        return super.method_5943(world, difficulty, spawnReason, entityData, entityNbt);
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10569("Variant", this.getVariantInt());
        nbt.method_10556("HasHorns", this.getHasHorns());
        nbt.method_10569("HornDropTimer", this.getHornDropTimer());
        nbt.method_10556("IsShaking", this.getIsShaking());
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        this.field_6011.method_12778(VARIANT, (Object)nbt.method_10550("Variant"));
        this.field_6011.method_12778(HAS_HORNS, (Object)nbt.method_10577("HasHorns"));
        this.field_6011.method_12778(HORN_DROP_TIMER, (Object)nbt.method_10550("HornDropTimer"));
        this.field_6011.method_12778(IS_SHAKING, (Object)nbt.method_10577("IsShaking"));
    }

    public int getTimeTillDrop() {
        return (Integer)this.field_6011.method_12789(TIME_TILL_DROP);
    }

    public void setTimeTillDrop(int timeTillDrop) {
        this.field_6011.method_12778(TIME_TILL_DROP, (Object)timeTillDrop);
    }

    public boolean getIsShaking() {
        return (Boolean)this.field_6011.method_12789(IS_SHAKING);
    }

    public void setIsShaking(boolean isShaking) {
        this.field_6011.method_12778(IS_SHAKING, (Object)isShaking);
    }

    public boolean getHasHorns() {
        return (Boolean)this.field_6011.method_12789(HAS_HORNS);
    }

    public void setHasHorns(boolean hasHorns) {
        this.field_6011.method_12778(HAS_HORNS, (Object)hasHorns);
    }

    public int getHornDropTimer() {
        return (Integer)this.field_6011.method_12789(HORN_DROP_TIMER);
    }

    public void setHornDropTimer(int hornDropTimer) {
        this.field_6011.method_12778(HORN_DROP_TIMER, (Object)hornDropTimer);
    }

    public MossbloomVariant getVariant() {
        return MossbloomVariant.byId(this.getVariantInt() & 0xFF);
    }

    public boolean isVariantOf(MossbloomVariant variant) {
        return this.getVariant() == variant;
    }

    public void setVariant(MossbloomVariant variant) {
        this.field_6011.method_12778(VARIANT, (Object)(variant.getId() & 0xFF));
    }

    private int getVariantInt() {
        return (Integer)this.field_6011.method_12789(VARIANT);
    }
}

