/*
 * Decompiled with CFR 0.152.
 */
package net.emilsg.clutter.block.custom;

import java.util.function.ToIntFunction;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1676;
import net.minecraft.class_1750;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2383;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2753;
import net.minecraft.class_2769;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5712;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;

public class WallCandleBlock
extends class_2383
implements class_3737 {
    private static final class_2753 FACING = class_2383.field_11177;
    private static final class_2746 LIT = class_2741.field_12548;
    private static final class_2746 WATERLOGGED = class_2741.field_12508;
    private static final class_265 NORTH_SHAPE = class_259.method_17786((class_265)class_2248.method_9541((double)7.0, (double)3.0, (double)11.0, (double)9.0, (double)5.0, (double)15.0), (class_265[])new class_265[]{class_2248.method_9541((double)6.0, (double)2.0, (double)15.0, (double)10.0, (double)6.0, (double)16.0), class_2248.method_9541((double)7.0, (double)5.0, (double)11.0, (double)9.0, (double)6.0, (double)13.0), class_2248.method_9541((double)6.0, (double)6.0, (double)10.0, (double)10.0, (double)7.0, (double)14.0), class_2248.method_9541((double)7.0, (double)7.0, (double)11.0, (double)9.0, (double)13.0, (double)13.0)});
    private static final class_265 EAST_SHAPE = class_259.method_17786((class_265)class_2248.method_9541((double)1.0, (double)3.0, (double)7.0, (double)5.0, (double)5.0, (double)9.0), (class_265[])new class_265[]{class_2248.method_9541((double)0.0, (double)2.0, (double)6.0, (double)1.0, (double)6.0, (double)10.0), class_2248.method_9541((double)3.0, (double)5.0, (double)7.0, (double)5.0, (double)6.0, (double)9.0), class_2248.method_9541((double)2.0, (double)6.0, (double)6.0, (double)6.0, (double)7.0, (double)10.0), class_2248.method_9541((double)3.0, (double)7.0, (double)7.0, (double)5.0, (double)13.0, (double)9.0)});
    private static final class_265 SOUTH_SHAPE = class_259.method_17786((class_265)class_2248.method_9541((double)7.0, (double)3.0, (double)1.0, (double)9.0, (double)5.0, (double)5.0), (class_265[])new class_265[]{class_2248.method_9541((double)6.0, (double)2.0, (double)0.0, (double)10.0, (double)6.0, (double)1.0), class_2248.method_9541((double)7.0, (double)5.0, (double)3.0, (double)9.0, (double)6.0, (double)5.0), class_2248.method_9541((double)6.0, (double)6.0, (double)2.0, (double)10.0, (double)7.0, (double)6.0), class_2248.method_9541((double)7.0, (double)7.0, (double)3.0, (double)9.0, (double)13.0, (double)5.0)});
    private static final class_265 WEST_SHAPE = class_259.method_17786((class_265)class_2248.method_9541((double)11.0, (double)3.0, (double)7.0, (double)15.0, (double)5.0, (double)9.0), (class_265[])new class_265[]{class_2248.method_9541((double)15.0, (double)2.0, (double)6.0, (double)16.0, (double)6.0, (double)10.0), class_2248.method_9541((double)11.0, (double)5.0, (double)7.0, (double)13.0, (double)6.0, (double)9.0), class_2248.method_9541((double)10.0, (double)6.0, (double)6.0, (double)14.0, (double)7.0, (double)10.0), class_2248.method_9541((double)11.0, (double)7.0, (double)7.0, (double)13.0, (double)13.0, (double)9.0)});

    public WallCandleBlock(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)LIT, (Comparable)Boolean.valueOf(false)));
    }

    public static ToIntFunction<class_2680> createLightLevelFromLitBlockState(int litLevel) {
        return state -> (Boolean)state.method_11654((class_2769)LIT) != false ? litLevel : 0;
    }

    private static void spawnCandleParticles(class_1937 world, class_243 vec3d, class_5819 random) {
        float f = random.method_43057();
        if (f < 0.3f) {
            world.method_8406((class_2394)class_2398.field_11251, vec3d.field_1352, vec3d.field_1351, vec3d.field_1350, 0.0, 0.0, 0.0);
            if (f < 0.17f) {
                world.method_8486(vec3d.field_1352 + 0.5, vec3d.field_1351 + 0.5, vec3d.field_1350 + 0.5, class_3417.field_26953, class_3419.field_15245, 1.0f + random.method_43057(), random.method_43057() * 0.7f + 0.3f, false);
            }
        }
        world.method_8406((class_2394)class_2398.field_27783, vec3d.field_1352, vec3d.field_1351, vec3d.field_1350, 0.0, 0.0, 0.0);
    }

    public static void extinguish(@Nullable class_1657 player, class_2680 state, class_1937 world, class_2338 pos) {
        WallCandleBlock.setLit((class_1936)world, state, pos, false);
        world.method_8396(null, pos, class_3417.field_26955, class_3419.field_15245, 1.0f, 1.0f);
        world.method_33596((class_1297)player, class_5712.field_28733, pos);
    }

    private static void setLit(class_1936 world, class_2680 state, class_2338 pos, boolean lit) {
        world.method_8652(pos, (class_2680)state.method_11657((class_2769)LIT, (Comparable)Boolean.valueOf(lit)), 11);
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        class_2350 i = (class_2350)state.method_11654((class_2769)FACING);
        return switch (i) {
            case class_2350.field_11043 -> NORTH_SHAPE;
            case class_2350.field_11035 -> SOUTH_SHAPE;
            case class_2350.field_11034 -> EAST_SHAPE;
            case class_2350.field_11039 -> WEST_SHAPE;
            default -> class_259.method_1073();
        };
    }

    public void method_9496(class_2680 state, class_1937 world, class_2338 pos, class_5819 random) {
        class_243 candlePosition;
        if (((Boolean)state.method_11654((class_2769)WATERLOGGED)).booleanValue() || !((Boolean)state.method_11654((class_2769)LIT)).booleanValue()) {
            return;
        }
        class_2350 direction = (class_2350)state.method_11654((class_2769)FACING);
        switch (direction) {
            case field_11043: {
                candlePosition = new class_243(0.5, 0.90625, 0.75);
                break;
            }
            case field_11034: {
                candlePosition = new class_243(0.25, 0.90625, 0.5);
                break;
            }
            case field_11035: {
                candlePosition = new class_243(0.5, 0.90625, 0.25);
                break;
            }
            case field_11039: {
                candlePosition = new class_243(0.75, 0.90625, 0.5);
                break;
            }
            default: {
                return;
            }
        }
        class_243 offset = new class_243((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260());
        WallCandleBlock.spawnCandleParticles(world, offset.method_1019(candlePosition), random);
    }

    private boolean canPlaceOn(class_1922 world, class_2338 pos, class_2350 side) {
        class_2680 blockState = world.method_8320(pos);
        return blockState.method_26206(world, pos, side);
    }

    public boolean method_9558(class_2680 state, class_4538 world, class_2338 pos) {
        class_2350 direction = (class_2350)state.method_11654((class_2769)FACING);
        return this.canPlaceOn((class_1922)world, pos.method_10093(direction.method_10153()), direction);
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> stateManager) {
        stateManager.method_11667(new class_2769[]{FACING, WATERLOGGED, LIT});
    }

    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 world, class_2338 pos, class_2338 neighborPos) {
        if (direction.method_10153() == state.method_11654((class_2769)FACING) && !state.method_26184((class_4538)world, pos)) {
            return class_2246.field_10124.method_9564();
        }
        if (((Boolean)state.method_11654((class_2769)WATERLOGGED)).booleanValue()) {
            world.method_39281(pos, (class_3611)class_3612.field_15910, class_3612.field_15910.method_15789((class_4538)world));
            world.method_8652(pos, (class_2680)state.method_11657((class_2769)LIT, (Comparable)Boolean.valueOf(false)), 3);
        }
        return super.method_9559(state, direction, neighborState, world, pos, neighborPos);
    }

    @Nullable
    public class_2680 method_9605(class_1750 ctx) {
        class_2680 blockState;
        if (!ctx.method_7717() && (blockState = ctx.method_8045().method_8320(ctx.method_8037().method_10093(ctx.method_8038().method_10153()))).method_27852((class_2248)this) && blockState.method_11654((class_2769)FACING) == ctx.method_8038()) {
            return null;
        }
        blockState = this.method_9564();
        class_1937 worldView = ctx.method_8045();
        class_2338 blockPos = ctx.method_8037();
        class_3610 fluidState = ctx.method_8045().method_8316(ctx.method_8037());
        for (class_2350 direction : ctx.method_7718()) {
            if (!direction.method_10166().method_10179() || !(blockState = (class_2680)blockState.method_11657((class_2769)FACING, (Comparable)direction.method_10153())).method_26184((class_4538)worldView, blockPos)) continue;
            return (class_2680)blockState.method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.method_15772() == class_3612.field_15910));
        }
        return null;
    }

    public boolean method_10311(class_1936 world, class_2338 pos, class_2680 state, class_3610 fluidState) {
        if (!((Boolean)state.method_11654((class_2769)class_2741.field_12508)).booleanValue() && fluidState.method_15772() == class_3612.field_15910) {
            world.method_8652(pos, (class_2680)state.method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(true)), 3);
            world.method_39281(pos, fluidState.method_15772(), fluidState.method_15772().method_15789((class_4538)world));
            return true;
        }
        return false;
    }

    public class_3610 method_9545(class_2680 state) {
        if (((Boolean)state.method_11654((class_2769)WATERLOGGED)).booleanValue()) {
            return class_3612.field_15910.method_15729(false);
        }
        return super.method_9545(state);
    }

    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        if (player.method_31549().field_7476 && player.method_5998(hand).method_7960() && ((Boolean)state.method_11654((class_2769)LIT)).booleanValue()) {
            WallCandleBlock.extinguish(player, state, world, pos);
            return class_1269.method_29236((boolean)world.field_9236);
        }
        if (player.method_31549().field_7476 && player.method_5998(hand).method_31574(class_1802.field_8884) && !((Boolean)state.method_11654((class_2769)LIT)).booleanValue()) {
            WallCandleBlock.setLit((class_1936)world, state, pos, true);
            if (!player.method_31549().field_7477) {
                player.method_5998(hand).method_7956(1, (class_1309)player, playerEntity -> playerEntity.method_20236(hand));
            }
            return class_1269.method_29236((boolean)world.field_9236);
        }
        if (player.method_31549().field_7476 && player.method_5998(hand).method_31574(class_1802.field_8814) && !((Boolean)state.method_11654((class_2769)LIT)).booleanValue() && !player.method_31549().field_7477) {
            WallCandleBlock.setLit((class_1936)world, state, pos, true);
            if (!player.method_31549().field_7477) {
                player.method_5998(hand).method_7934(1);
            }
            return class_1269.method_29236((boolean)world.field_9236);
        }
        if (player.method_31549().field_7476 && player.method_5998(hand).method_31574(class_1802.field_8814) && !((Boolean)state.method_11654((class_2769)LIT)).booleanValue() && player.method_31549().field_7477) {
            WallCandleBlock.setLit((class_1936)world, state, pos, true);
            return class_1269.method_29236((boolean)world.field_9236);
        }
        return class_1269.field_5811;
    }

    public void method_19286(class_1937 world, class_2680 state, class_3965 hit, class_1676 projectile) {
        if (!world.field_9236 && projectile.method_5809() && this.isNotLit(state)) {
            WallCandleBlock.setLit((class_1936)world, state, hit.method_17777(), true);
        }
    }

    protected boolean isNotLit(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)LIT) == false;
    }
}

