/*
 * Decompiled with CFR 0.152.
 */
package com.github.thedeathlycow.frostiful.survival;

import com.github.thedeathlycow.frostiful.Frostiful;
import com.github.thedeathlycow.frostiful.config.FrostifulConfig;
import com.github.thedeathlycow.frostiful.survival.BiomeCategory;
import com.github.thedeathlycow.frostiful.tag.FBlockTags;
import com.github.thedeathlycow.thermoo.api.season.ThermooSeasons;
import com.github.thedeathlycow.thermoo.api.temperature.EnvironmentController;
import com.github.thedeathlycow.thermoo.api.temperature.EnvironmentControllerDecorator;
import com.github.thedeathlycow.thermoo.api.temperature.TemperatureAware;
import net.minecraft.class_1309;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_6880;

public class AmbientTemperatureController
extends EnvironmentControllerDecorator {
    private final boolean isScorchfulLoaded;

    public AmbientTemperatureController(boolean isScorchfulLoaded, EnvironmentController controller) {
        super(controller);
        this.isScorchfulLoaded = isScorchfulLoaded;
    }

    public int getLocalTemperatureChange(class_1937 world, class_2338 pos) {
        if (world.method_8597().comp_645()) {
            return this.getNaturalWorldTemperatureChange(world, pos);
        }
        if (!this.isScorchfulLoaded && world.method_8597().comp_644()) {
            return this.getUltrawarmTemperatureChange();
        }
        return this.controller.getLocalTemperatureChange(world, pos);
    }

    public int getFloorTemperature(class_1309 entity, class_1937 world, class_2680 state, class_2338 pos) {
        if (state.method_26164(FBlockTags.HOT_FLOOR)) {
            if (class_1890.method_8216((class_1309)entity)) {
                return this.controller.getFloorTemperature(entity, world, state, pos);
            }
            FrostifulConfig config = Frostiful.getConfig();
            return config.freezingConfig.getHeatFromHotFloor();
        }
        return this.controller.getFloorTemperature(entity, world, state, pos);
    }

    public int getHeatAtLocation(class_1937 world, class_2338 pos) {
        FrostifulConfig config = Frostiful.getConfig();
        int lightLevel = world.method_8314(class_1944.field_9282, pos);
        int minLightLevel = config.environmentConfig.getMinLightForWarmth();
        int warmth = this.controller.getHeatAtLocation(world, pos);
        if (lightLevel >= minLightLevel) {
            warmth += config.environmentConfig.getWarmthPerLightLevel() * (lightLevel - minLightLevel);
        }
        return warmth;
    }

    public int applyAwareHeat(TemperatureAware temperatureAware, int locationHeat) {
        return temperatureAware.thermoo$isCold() ? locationHeat : 0;
    }

    public int getHeatFromBlockState(class_2680 state) {
        return state.method_26213();
    }

    public boolean isHeatSource(class_2680 state) {
        int minLightForWarmth = Frostiful.getConfig().environmentConfig.getMinLightForWarmth();
        return this.getHeatFromBlockState(state) >= minLightForWarmth;
    }

    public boolean isAreaHeated(class_1937 world, class_2338 pos) {
        return this.getHeatAtLocation(world, pos) > 0;
    }

    private int getNaturalWorldTemperatureChange(class_1937 world, class_2338 pos) {
        ThermooSeasons season;
        class_6880 biome = world.method_23753(pos);
        BiomeCategory category = BiomeCategory.fromBiome((class_6880<class_1959>)biome, season = (ThermooSeasons)ThermooSeasons.getCurrentSeason((class_1937)world).orElse(null));
        int temp = category.getTemperatureChange(world, pos, season);
        if (temp < 0) {
            return temp;
        }
        return this.controller.getLocalTemperatureChange(world, pos);
    }

    private int getUltrawarmTemperatureChange() {
        return Frostiful.getConfig().environmentConfig.getUltrawarmWarmRate();
    }
}

