/*
 * Decompiled with CFR 0.152.
 */
package com.github.thedeathlycow.frostiful.item.attribute;

import com.github.thedeathlycow.frostiful.item.attribute.AttributeHolder;
import com.google.common.collect.Multimap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1304;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

@Deprecated
public class ItemAttributeModifier {
    @Nullable
    private final class_1792 item;
    private final class_1304 slot;
    private final List<AttributeHolder> attributeModifiers;

    public ItemAttributeModifier(@Nullable class_1792 item, class_1304 slot, List<AttributeHolder> attributeModifiers) {
        this.item = item;
        this.slot = slot;
        this.attributeModifiers = attributeModifiers;
    }

    public void apply(class_1799 stack, class_1304 slot, Multimap<class_1320, class_1322> attributeModifiers) {
        if (this.item != null && stack.method_31574(this.item) && slot == this.slot) {
            for (AttributeHolder holder : this.attributeModifiers) {
                attributeModifiers.put((Object)holder.attribute(), (Object)holder.modifier());
            }
        }
    }

    public boolean isItemPresent() {
        return this.item != null;
    }

    public static class Serializer
    implements JsonDeserializer<ItemAttributeModifier> {
        public static final Gson GSON = new GsonBuilder().registerTypeAdapter(ItemAttributeModifier.class, (Object)new Serializer()).create();

        public ItemAttributeModifier deserialize(JsonElement jsonElement, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            List<AttributeHolder> attributeModifiers;
            class_1304 slot;
            JsonObject json = jsonElement.getAsJsonObject();
            class_1792 item = this.getItem(json.get("item"));
            String slotName = json.get("slot").getAsString();
            try {
                slot = class_1304.method_5924((String)slotName);
            }
            catch (IllegalArgumentException e) {
                throw new JsonSyntaxException("Unknown slot name '" + slotName + "'");
            }
            JsonElement attributesJson = json.get("attribute_modifiers");
            if (attributesJson.isJsonObject()) {
                attributeModifiers = Collections.singletonList(AttributeHolder.fromJson(attributesJson));
            } else if (attributesJson.isJsonArray()) {
                attributeModifiers = new ArrayList<AttributeHolder>();
                for (JsonElement attributeModifier : attributesJson.getAsJsonArray()) {
                    attributeModifiers.add(AttributeHolder.fromJson(attributeModifier));
                }
            } else {
                throw new JsonSyntaxException("Malformed item attribute modifiers:\n" + attributesJson.toString());
            }
            return new ItemAttributeModifier(item, slot, attributeModifiers);
        }

        @Nullable
        private class_1792 getItem(JsonElement jsonElement) throws JsonSyntaxException {
            String id;
            boolean required = true;
            if (jsonElement.isJsonPrimitive()) {
                id = jsonElement.getAsString();
            } else if (jsonElement.isJsonObject()) {
                JsonObject json = jsonElement.getAsJsonObject();
                id = json.get("item").getAsString();
                required = json.get("required").getAsBoolean();
            } else {
                throw new JsonSyntaxException("Invalid JSON: " + String.valueOf(jsonElement));
            }
            class_2960 itemID = new class_2960(id);
            Optional item = class_7923.field_41178.method_17966(itemID);
            if (item.isEmpty() && required) {
                throw new JsonSyntaxException("Unknown item '" + String.valueOf(itemID) + "'");
            }
            return item.orElse(null);
        }
    }
}

