/*
 * Decompiled with CFR 0.152.
 */
package com.github.thedeathlycow.frostiful.entity.component;

import com.github.thedeathlycow.frostiful.entity.FBrushable;
import com.github.thedeathlycow.frostiful.registry.FComponents;
import dev.onyxstudios.cca.api.v3.component.Component;
import dev.onyxstudios.cca.api.v3.component.sync.AutoSyncedComponent;
import net.minecraft.class_1429;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_3222;

public class BrushableComponent
implements Component,
AutoSyncedComponent {
    private static final String LAST_BRUSHED_TIME_KEY = "last_brushed_time";
    private long lastBrushTime = -1L;
    private final class_1429 provider;
    private final FBrushable brushable;

    public BrushableComponent(class_1429 provider) {
        this.provider = provider;
        this.brushable = (FBrushable)provider;
    }

    public void writeSyncPacket(class_2540 buf, class_3222 recipient) {
        buf.writeLong(this.lastBrushTime);
    }

    public void applySyncPacket(class_2540 buf) {
        this.lastBrushTime = buf.readLong();
    }

    public void readFromNbt(class_2487 tag) {
        if (tag.method_10573(LAST_BRUSHED_TIME_KEY, 4)) {
            this.lastBrushTime = tag.method_10537(LAST_BRUSHED_TIME_KEY);
        }
    }

    public void writeToNbt(class_2487 tag) {
        if (this.brushable.frostiful$wasBrushed()) {
            tag.method_10544(LAST_BRUSHED_TIME_KEY, this.lastBrushTime);
        }
    }

    public long getLastBrushTime() {
        return this.lastBrushTime;
    }

    public void setLastBrushTime(long lastBrushTime) {
        if (this.lastBrushTime != lastBrushTime) {
            this.lastBrushTime = lastBrushTime;
            FComponents.BRUSHABLE_COMPONENT.sync((Object)this.provider);
        }
    }

    public boolean isBrushable() {
        return this.provider.method_5805() && !this.provider.method_6109() && !this.wasBrushed();
    }

    public boolean wasBrushed() {
        return this.lastBrushTime >= 0L && this.provider.method_37908().method_8532() - this.lastBrushTime <= 6000L;
    }
}

