/*
 * Decompiled with CFR 0.152.
 */
package dev.foxgirl.trimeffects;

import com.google.common.collect.ImmutableSet;
import com.mojang.serialization.DynamicOps;
import dev.foxgirl.trimeffects.Config;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2960;
import net.minecraft.class_3489;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8053;
import net.minecraft.class_8054;
import net.minecraft.class_8056;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TrimEffects2 {
    public static final Logger LOGGER = LogManager.getLogger((String)"trimeffects");
    public static final TrimEffects2 INSTANCE = new TrimEffects2();
    public static final int STATUS_EFFECT_DURATION_MARKER = -75915;
    public Config config;
    @NotNull
    private final IdentifierToEffectSetMapping configEffectsMapping = new IdentifierToEffectSetMapping(){

        @Override
        protected void printWarningForMissingKey(String keyString) {
            LOGGER.warn("(TrimsEffects) Config is missing an effect for trim pattern \"{}\", consider adding it!", (Object)keyString);
        }

        @Override
        protected void printWarningForInvalidEffect(String effectString) {
            LOGGER.warn("(TrimsEffects) Config has an unknown/invalid effect \"{}\", check your spelling", (Object)effectString);
        }

        @Override
        protected Map<String, List<String>> getUnderlyingConfigValue() {
            return TrimEffects2.this.config.effects;
        }
    };
    @NotNull
    private final IdentifierToEffectSetMapping configMaterialEffectOverridesMapping = new IdentifierToEffectSetMapping(){

        @Override
        protected void printWarningForMissingKey(String keyString) {
        }

        @Override
        protected void printWarningForInvalidEffect(String effectString) {
            LOGGER.warn("(TrimsEffects) Config has an unknown/invalid effect \"{}\" in materialEffectOverrides, check your spelling", (Object)effectString);
        }

        @Override
        protected Map<String, List<String>> getUnderlyingConfigValue() {
            return TrimEffects2.this.config.materialEffectOverrides;
        }
    };
    private final Map<UUID, AbsorptionRecord> absorptionRecords = new HashMap<UUID, AbsorptionRecord>();

    private TrimEffects2() {
    }

    public void initialize(@NotNull Path directory) {
        this.config = Config.read(directory);
    }

    @NotNull
    public static class_5455 getRegistryManager(@NotNull class_1297 entity) {
        return entity.method_37908().method_30349();
    }

    @NotNull
    public static class_2378<class_1291> getStatusEffectRegistry(@NotNull class_5455 manager) {
        return manager.method_30530(class_7924.field_41208);
    }

    public static class_2378<class_1291> getStatusEffectRegistry(@NotNull class_1297 entity) {
        return TrimEffects2.getStatusEffectRegistry(TrimEffects2.getRegistryManager(entity));
    }

    @NotNull
    public static <T> class_5321<T> getRegistryKey(@NotNull class_6880<T> entry) {
        return (class_5321)entry.method_40230().orElseThrow();
    }

    @NotNull
    public static <T> RegistryEntryGetter<T> toRegistryEntryGetter(@NotNull class_2378<T> registry) {
        return id -> {
            Optional entry = registry.method_40264(class_5321.method_29179((class_5321)registry.method_30517(), (class_2960)id));
            return entry.isPresent() ? Optional.of((class_6880)entry.get()) : Optional.empty();
        };
    }

    @NotNull
    public static <T> RegistryEntryGetter<T> toRegistryEntryGetter(@NotNull class_7225<T> wrapper) {
        return id -> {
            class_5321 registryKey = ((class_7225.class_7226)wrapper).method_46765();
            class_5321 entryKey = class_5321.method_29179((class_5321)registryKey, (class_2960)id);
            Optional entry = wrapper.method_46746(entryKey);
            return entry.isPresent() ? Optional.of((class_6880)entry.get()) : Optional.empty();
        };
    }

    @Nullable
    public static class_8053 getArmorTrimFromItemStack(@NotNull class_5455 manager, @NotNull class_1799 stack) {
        class_2487 nbt = stack.method_7941("Trim");
        if (nbt == null || !stack.method_31573(class_3489.field_41890)) {
            return null;
        }
        return class_8053.field_41994.parse((DynamicOps)class_6903.method_46632((DynamicOps)class_2509.field_11560, (class_7225.class_7874)manager), (Object)nbt).result().orElse(null);
    }

    public static void setStatusEffectDuration(@NotNull class_1293 instance, int duration) {
        ((DurationSetter)instance).trimeffects$setDuration(duration);
    }

    @NotNull
    private @NotNull Set<@NotNull class_6880<class_1291>> collectEffectsForPatternAndMaterial(@NotNull RegistryEntryGetter<class_1291> registry, @NotNull class_5321<class_8054> materialKey, @NotNull class_5321<class_8056> patternKey) {
        Set<class_6880<class_1291>> effectsOverridden = this.configMaterialEffectOverridesMapping.collectEffectsForKey(registry, materialKey.method_29177());
        if (!effectsOverridden.isEmpty()) {
            return effectsOverridden;
        }
        return this.configEffectsMapping.collectEffectsForKey(registry, patternKey.method_29177());
    }

    @Nullable
    public TrimDetails createTrimDetails(@NotNull RegistryEntryGetter<class_1291> registry, @NotNull class_8053 trim) {
        class_5321 patternKey;
        class_5321 materialKey = TrimEffects2.getRegistryKey(trim.method_48431());
        Set<class_6880<class_1291>> effects = this.collectEffectsForPatternAndMaterial(registry, materialKey, patternKey = TrimEffects2.getRegistryKey(trim.method_48424()));
        if (effects.isEmpty()) {
            return null;
        }
        return new TrimDetails(trim, materialKey, patternKey, effects);
    }

    private boolean shouldApplyToEntity(@NotNull class_1309 entity) {
        if (this.config.applyToMobs) {
            return true;
        }
        return entity instanceof class_1657;
    }

    public void onLivingEntityTick(@NotNull class_1309 entity) {
        if (!this.shouldApplyToEntity(entity)) {
            this.removeEffectsFromTrims(entity, null);
            return;
        }
        class_5455 manager = TrimEffects2.getRegistryManager((class_1297)entity);
        class_2378<class_1291> registry = null;
        ArrayList<TrimDetails> trims = null;
        for (class_1799 stack : entity.method_5661()) {
            TrimDetails details;
            class_8053 trim = TrimEffects2.getArmorTrimFromItemStack(manager, stack);
            if (trim == null) continue;
            if (registry == null) {
                registry = TrimEffects2.getStatusEffectRegistry(manager);
            }
            if ((details = this.createTrimDetails(TrimEffects2.toRegistryEntryGetter(registry), trim)) == null) continue;
            if (trims == null) {
                trims = new ArrayList<TrimDetails>(4);
            }
            trims.add(details);
        }
        if (trims != null && !trims.isEmpty()) {
            this.updateEffectsWithTrimDetails(entity, (List<TrimDetails>)trims);
        } else {
            this.removeEffectsFromTrims(entity, null);
        }
    }

    private int getConfigMatchingEffectLevel(int index) {
        List<Integer> matchingEffectLevels = this.config.matchingEffectLevels;
        if (matchingEffectLevels.isEmpty()) {
            return -1;
        }
        if (index < 0) {
            return matchingEffectLevels.get(0);
        }
        if (index >= matchingEffectLevels.size()) {
            return matchingEffectLevels.get(matchingEffectLevels.size() - 1);
        }
        return matchingEffectLevels.get(index);
    }

    private int getConfigMaterialEffectLevel(@NotNull class_2960 key) {
        Map<String, Integer> materialEffectLevels = this.config.materialEffectLevels;
        if (materialEffectLevels.isEmpty()) {
            return -1;
        }
        String keyPathString = key.method_12832();
        String keyFullString = key.toString();
        for (Map.Entry<String, Integer> entry : materialEffectLevels.entrySet()) {
            String entryKeyString = entry.getKey();
            if (!keyPathString.equalsIgnoreCase(entryKeyString) && !keyFullString.equalsIgnoreCase(entryKeyString)) continue;
            return entry.getValue();
        }
        return -1;
    }

    private List<EffectDetails> collectEffectDetails(List<TrimDetails> trims) {
        ArrayList<EffectDetails> effects = new ArrayList<EffectDetails>(trims.size());
        for (TrimDetails trimDetails : trims) {
            for (class_6880<class_1291> effect : trimDetails.effects()) {
                class_5321<class_1291> effectKey = TrimEffects2.getRegistryKey(effect);
                boolean exists = false;
                for (EffectDetails effectDetails : effects) {
                    if (!effectDetails.effectKey.equals(effectKey)) continue;
                    effectDetails.trySetMaterial(trimDetails.materialKey());
                    effectDetails.incrementCount();
                    exists = true;
                    break;
                }
                if (exists) continue;
                effects.add(new EffectDetails(effect, effectKey, trimDetails.materialKey()));
            }
        }
        effects.removeIf(EffectDetails::shouldBeIgnored);
        return effects;
    }

    public static boolean shouldOmitFromTooltip(TrimDetails trimDetails) {
        return trimDetails.effects().stream().allMatch(details -> new EffectDetails((class_6880<class_1291>)details, trimDetails.materialKey()).shouldBeOmmittedFromTooltip());
    }

    private boolean isAbsorption(class_6880<class_1291> effect) {
        return class_1294.field_5898.equals(effect.comp_349());
    }

    private boolean isAbsorptionStunned(class_1309 entity, class_1293 instance) {
        AbsorptionRecord absorptionRecord = this.absorptionRecords.computeIfAbsent(entity.method_5667(), uuid -> new AbsorptionRecord());
        float currentAbsorptionAmount = entity.method_6067();
        float previousAbsorptionAmount = absorptionRecord.previousAmount;
        absorptionRecord.previousAmount = currentAbsorptionAmount;
        if (absorptionRecord.stunTicks > 0) {
            --absorptionRecord.stunTicks;
            return true;
        }
        if (instance != null && instance.method_48559() && currentAbsorptionAmount < previousAbsorptionAmount) {
            int stunDurationInTicks;
            absorptionRecord.stunTicks = stunDurationInTicks = (int)(this.config.absorptionStunSeconds * 20.0);
            TrimEffects2.setStatusEffectDuration(instance, stunDurationInTicks);
            return true;
        }
        return false;
    }

    private void updateEffectsWithTrimDetails(class_1309 entity, List<TrimDetails> trims) {
        List<EffectDetails> effects = this.collectEffectDetails(trims);
        for (EffectDetails effectDetails : effects) {
            class_1293 instance = entity.method_6112((class_1291)effectDetails.effect.comp_349());
            if (this.isAbsorption(effectDetails.effect) && this.isAbsorptionStunned(entity, instance)) continue;
            if (instance == null) {
                entity.method_37222(effectDetails.createStatusEffectInstance(), (class_1297)entity);
                continue;
            }
            if (instance.method_5584() == -75915 ? instance.method_5578() == effectDetails.getAmplifier() : instance.method_5578() >= effectDetails.getAmplifier()) continue;
            entity.method_6016((class_1291)effectDetails.effect.comp_349());
            entity.method_37222(effectDetails.createStatusEffectInstance(), (class_1297)entity);
        }
        this.removeEffectsFromTrims(entity, effects);
    }

    private boolean isEffectExcluded(List<EffectDetails> excludedEffects, class_6880<class_1291> effect) {
        class_5321<class_1291> effectKey = TrimEffects2.getRegistryKey(effect);
        for (EffectDetails effectDetails : excludedEffects) {
            if (!effectKey.equals(effectDetails.effectKey)) continue;
            return true;
        }
        return false;
    }

    private void removeEffectsFromTrims(class_1309 entity, @Nullable List<EffectDetails> excludedEffects) {
        ObjectArraySet effectsToRemove = null;
        for (class_1293 instance : entity.method_6026()) {
            if (instance.method_5584() != -75915) continue;
            class_6880 effect = class_7923.field_41174.method_47983((Object)instance.method_5579());
            if (excludedEffects != null && this.isEffectExcluded(excludedEffects, (class_6880<class_1291>)effect)) continue;
            if (effectsToRemove == null) {
                effectsToRemove = new ObjectArraySet(2);
            }
            effectsToRemove.add((Object)effect);
        }
        if (effectsToRemove != null) {
            for (class_6880 effect : effectsToRemove) {
                entity.method_6016((class_1291)effect.comp_349());
            }
        }
    }

    private static abstract class IdentifierToEffectSetMapping {
        private static final class_2960[] EMPTY_EFFECT_IDS = new class_2960[0];
        private final Map<class_2960, class_2960[]> keyToEffectsCache = new HashMap<class_2960, class_2960[]>();
        private final Set<String> missingKeys = new HashSet<String>();
        private final Set<String> invalidEffects = new HashSet<String>();

        private IdentifierToEffectSetMapping() {
        }

        private static class_6880<class_1291>[] createStatusEffectArray(int length) {
            return new class_6880[length];
        }

        private Set<class_6880<class_1291>> lookupEffectsInCache(RegistryEntryGetter<class_1291> registry, class_2960 key) {
            class_2960[] effectIDs = this.keyToEffectsCache.get(key);
            if (effectIDs == null) {
                return null;
            }
            int length = effectIDs.length;
            if (length == 0) {
                return ImmutableSet.of();
            }
            Object[] effects = IdentifierToEffectSetMapping.createStatusEffectArray(length);
            for (int i = 0; i < length; ++i) {
                Optional<class_6880<class_1291>> effect = registry.getEntry(effectIDs[i]);
                if (!effect.isPresent()) {
                    this.keyToEffectsCache.remove(key);
                    return null;
                }
                effects[i] = effect.get();
            }
            return new ObjectArraySet(effects);
        }

        private void storeEffectsInCache(class_2960 key, @Nullable Set<class_2960> effectIDs) {
            this.keyToEffectsCache.put(key, effectIDs != null ? effectIDs.toArray(EMPTY_EFFECT_IDS) : EMPTY_EFFECT_IDS);
        }

        private void warnMissingKey(String keyString) {
            if (this.missingKeys.add(keyString)) {
                this.printWarningForMissingKey(keyString);
            }
        }

        private void warnInvalidEffect(String effectString) {
            if (this.invalidEffects.add(effectString)) {
                this.printWarningForInvalidEffect(effectString);
            }
        }

        protected abstract void printWarningForMissingKey(String var1);

        protected abstract void printWarningForInvalidEffect(String var1);

        protected abstract Map<String, List<String>> getUnderlyingConfigValue();

        @NotNull
        public final @NotNull Set<@NotNull class_6880<class_1291>> collectEffectsForKey(@NotNull RegistryEntryGetter<class_1291> registry, @NotNull class_2960 key) {
            Set<class_6880<class_1291>> cachedEffects = this.lookupEffectsInCache(registry, key);
            if (cachedEffects != null) {
                return cachedEffects;
            }
            String keyPathString = key.method_12832();
            String keyFullString = key.toString();
            for (Map.Entry<String, List<String>> entry : this.getUnderlyingConfigValue().entrySet()) {
                String entryKeyString = entry.getKey();
                if (!keyPathString.equalsIgnoreCase(entryKeyString) && !keyFullString.equalsIgnoreCase(entryKeyString)) continue;
                List<String> effectStrings = entry.getValue();
                if (effectStrings == null) {
                    return ImmutableSet.of();
                }
                if (effectStrings.isEmpty()) {
                    this.storeEffectsInCache(key, null);
                    return ImmutableSet.of();
                }
                int size = effectStrings.size();
                boolean invalid = false;
                ObjectArraySet effectIDs = new ObjectArraySet((Object[])new class_2960[size], 0);
                Object[] effects = IdentifierToEffectSetMapping.createStatusEffectArray(size);
                for (String effectString : effectStrings) {
                    class_2960 effectID = class_2960.method_12829((String)effectString);
                    if (effectID == null) {
                        this.warnInvalidEffect(effectString);
                        invalid = true;
                        continue;
                    }
                    Optional<class_6880<class_1291>> effect = registry.getEntry(effectID);
                    if (effect.isEmpty()) {
                        this.warnInvalidEffect(effectString);
                        invalid = true;
                        continue;
                    }
                    if (!effectIDs.add((Object)effectID)) continue;
                    effects[effectIDs.size() - 1] = effect.get();
                }
                if (!invalid) {
                    this.storeEffectsInCache(key, (Set<class_2960>)effectIDs);
                }
                return new ObjectArraySet(effects, effectIDs.size());
            }
            this.warnMissingKey(keyFullString);
            return ImmutableSet.of();
        }
    }

    @FunctionalInterface
    public static interface RegistryEntryGetter<T> {
        @NotNull
        public @NotNull Optional<@NotNull class_6880<T>> getEntry(@NotNull class_2960 var1);
    }

    public static interface DurationSetter {
        public void trimeffects$setDuration(int var1);
    }

    public record TrimDetails(@NotNull class_8053 trim, @NotNull class_5321<class_8054> materialKey, @NotNull class_5321<class_8056> patternKey, @NotNull Set<class_6880<class_1291>> effects) {
    }

    private static final class EffectDetails {
        public final class_6880<class_1291> effect;
        public final class_5321<class_1291> effectKey;
        private class_5321<class_8054> materialKey;
        private int materialLevel = -1;
        public int count;
        public int amplifier = -2;

        public EffectDetails(class_6880<class_1291> effect, class_5321<class_1291> effectKey, class_5321<class_8054> materialKey) {
            this.effect = effect;
            this.effectKey = effectKey;
            this.trySetMaterial(materialKey);
        }

        public EffectDetails(class_6880<class_1291> effect, class_5321<class_8054> materialKey) {
            this(effect, TrimEffects2.getRegistryKey(effect), materialKey);
        }

        private static int getConfigMaterialEffectLevel(class_5321<class_8054> materialKey) {
            return INSTANCE.getConfigMaterialEffectLevel(materialKey.method_29177());
        }

        private int getConfigMaterialEffectLevel() {
            return this.materialKey != null ? EffectDetails.getConfigMaterialEffectLevel(this.materialKey) : -1;
        }

        private int getConfigMatchingEffectLevel() {
            return INSTANCE.getConfigMatchingEffectLevel(this.count);
        }

        private int getConfigMaterialMinimumMatching() {
            return TrimEffects2.INSTANCE.config.materialEffectLevelsMinimumMatching;
        }

        public void trySetMaterial(class_5321<class_8054> materialKey) {
            int oldLevel = this.getConfigMaterialEffectLevel();
            int newLevel = EffectDetails.getConfigMaterialEffectLevel(materialKey);
            if (newLevel > oldLevel) {
                this.materialKey = materialKey;
                this.materialLevel = this.getConfigMaterialEffectLevel();
                this.amplifier = -2;
            }
        }

        public void incrementCount() {
            ++this.count;
            this.amplifier = -2;
        }

        public int getAmplifier() {
            if (this.amplifier >= -1) {
                return this.amplifier;
            }
            if (this.materialLevel >= 0) {
                this.amplifier = this.count + 1 >= this.getConfigMaterialMinimumMatching() ? Math.max(this.materialLevel - 1, -1) : -1;
                return this.amplifier;
            }
            int level = this.getConfigMatchingEffectLevel();
            if (level >= 0) {
                this.amplifier = Math.max(level - 1, -1);
                return this.amplifier;
            }
            this.amplifier = -1;
            return this.amplifier;
        }

        public boolean shouldBeIgnored() {
            return this.getAmplifier() < 0;
        }

        public boolean shouldBeOmmittedFromTooltip() {
            return this.materialLevel == 0;
        }

        public class_1293 createStatusEffectInstance() {
            return new class_1293((class_1291)this.effect.comp_349(), -75915, Math.max(this.getAmplifier(), 0));
        }
    }

    private static final class AbsorptionRecord {
        private float previousAmount;
        private int stunTicks;

        private AbsorptionRecord() {
        }
    }
}

