/*
 * Decompiled with CFR 0.152.
 */
package dev.foxgirl.trimeffects;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import dev.foxgirl.trimeffects.TrimEffects2;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public final class Config {
    public Map<String, List<String>> effects;
    public List<Integer> matchingEffectLevels;
    public Map<String, Integer> materialEffectLevels;
    public int materialEffectLevelsMinimumMatching;
    public Map<String, List<String>> materialEffectOverrides;
    public boolean applyToMobs;
    public double absorptionStunSeconds;
    @NotNull
    public static String DEFAULT = "// TrimsEffects v2.1.X configuration JSON file\n// Make sure that your config file version matches the mod version!\n\n// CurseForge: https://www.curseforge.com/minecraft/mc-mods/trimseffects\n// Modrinth: https://modrinth.com/mod/trimseffects\n\n// === JSON EDITING TIPS ===\n// - Always use quotes around both keys and values: \"key\": \"value\"\n// - Don't put commas after the last item in a list or object:\n//   CORRECT:             WRONG:\n//   {                    {\n//     \"a\": \"1\",            \"a\": \"1\",\n//     \"b\": \"2\"             \"b\": \"2\",  <- Extra comma!\n//   }                    }\n// - Use square brackets [] for lists and curly braces {} for objects\n// - Keep all the original punctuation (colons, commas, brackets) when editing\n// =======================\n\n{\n\n  // Maps armor trim patterns to their associated potion effects\n  // Note: The \"minecraft:\" prefix is omitted from all pattern and effect names\n  // For patterns/effects from other mods, include the full name (e.g., \"othermod:custom_pattern\")\n  \"effects\": {\n    // Format: \"pattern\": [\"effect1\", \"effect2\", ...]\n    // You can specify multiple effects per pattern!\n\n    // Example with multiple effects:\n    // \"wild\": [\"hero_of_the_village\", \"strength\", \"resistance\"],\n\n    // Example with a modded armor trim pattern and potion effect:\n    // \"othermod:fancy_pattern\": [\"othermod:fancy_effect\"],\n\n    // Default values:\n    \"sentry\": [\"resistance\"],\n    \"dune\": [\"speed\"],\n    \"coast\": [\"water_breathing\"],\n    \"wild\": [\"hero_of_the_village\"],\n    \"ward\": [\"absorption\"],\n    \"eye\": [\"regeneration\"],\n    \"vex\": [\"invisibility\"],\n    \"tide\": [\"conduit_power\"],\n    \"snout\": [\"fire_resistance\"],\n    \"rib\": [\"haste\"],\n    \"spire\": [\"strength\"],\n    \"wayfinder\": [\"slow_falling\"],\n    \"shaper\": [\"luck\"],\n    \"silence\": [\"health_boost\"],\n    \"raiser\": [\"saturation\"],\n    \"host\": [\"glowing\"],\n    \"flow\": [\"jump_boost\"],\n    \"bolt\": [\"dolphins_grace\"]\n  },\n\n  // Controls potion effect level based on number of matching armor pieces\n  // Format: [1 piece, 2 pieces, 3 pieces, 4 pieces]\n  // Default: No effect for 1-2 pieces, level 1 for 3 pieces, level 2 for 4 pieces\n  \"matchingEffectLevels\": [0, 0, 1, 2],\n\n  // Legacy v1 feature: Override potion effect levels based on trim material\n  // Note: The \"minecraft:\" prefix is omitted from material names\n  // When enabled, gives effects even with just one armor piece!\n  \"materialEffectLevels\": {\n    // Format: \"material\": level\n    // Uncomment to enable:\n    /*\n    \"copper\": 0,\n    \"iron\": 0,\n    \"redstone\": 0,\n    \"lapis\": 0,\n    \"quartz\": 0,\n    \"gold\": 0,\n    \"emerald\": 0,\n    \"amethyst\": 0,\n    \"resin\": 1,\n    \"diamond\": 1,\n    \"netherite\": 2\n    */\n  },\n\n  // Legacy v1 feature: Minimum number of matching armor pieces required before an\n  // effect is applied when using \"materialEffectLevels\"\n  \"materialEffectLevelsMinimumMatching\": 4,\n\n  // Override potion effects based on trim material instead of pattern\n  // Note: The \"minecraft:\" prefix is omitted from material and effect names\n  \"materialEffectOverrides\": {\n    // Format: \"material\": [\"effect1\", \"effect2\", ...]\n\n    // Example with multiple effects:\n    // \"gold\": [\"haste\", \"luck\"],\n\n    // Default values:\n    \"resin\": [\"night_vision\"]\n  },\n\n  // If true, mobs wearing trimmed armor will get the effects\n  // Disable this if your modpack already has powerful mobs\n  \"applyToMobs\": true,\n\n  // Prevents absorption effect from making players invincible\n  // Waits this many seconds after damage before refreshing absorption hearts\n  \"absorptionStunSeconds\": 12.0\n\n}\n";
    private static final Gson GSON = new GsonBuilder().disableHtmlEscaping().serializeNulls().setPrettyPrinting().setLenient().create();

    @NotNull
    public Config verify() {
        if (this.effects == null) {
            throw new IllegalStateException("Field 'effects' is missing");
        }
        for (Map.Entry<String, List<String>> entry : this.effects.entrySet()) {
            if (entry.getKey() == null) {
                throw new IllegalStateException("Key in 'effects' map is missing/null");
            }
            if (entry.getValue() == null) {
                throw new IllegalStateException("Value in 'effects' map is missing/null");
            }
            for (String effect : entry.getValue()) {
                if (effect != null) continue;
                throw new IllegalStateException("Value inside of 'effects' map is missing/null");
            }
        }
        if (this.matchingEffectLevels == null) {
            throw new IllegalStateException("Field 'matchingEffectLevels' is missing");
        }
        for (Integer n : this.matchingEffectLevels) {
            if (n != null) continue;
            throw new IllegalStateException("Value in 'matchingEffectLevels' array is missing/null");
        }
        if (this.materialEffectLevels == null) {
            throw new IllegalStateException("Field 'materialEffectLevels' is missing");
        }
        for (Map.Entry entry : this.materialEffectLevels.entrySet()) {
            if (entry.getKey() == null) {
                throw new IllegalStateException("Key in 'materialEffectLevels' map is missing/null");
            }
            if (entry.getValue() != null) continue;
            throw new IllegalStateException("Value in 'materialEffectLevels' map is missing/null");
        }
        if (this.materialEffectOverrides == null) {
            throw new IllegalStateException("Field 'materialEffectOverrides' is missing");
        }
        for (Map.Entry entry : this.materialEffectOverrides.entrySet()) {
            if (entry.getKey() == null) {
                throw new IllegalStateException("Key in 'materialEffectOverrides' map is missing/null");
            }
            if (entry.getValue() == null) {
                throw new IllegalStateException("Value in 'materialEffectOverrides' map is missing/null");
            }
            for (String effect : (List)entry.getValue()) {
                if (effect != null) continue;
                throw new IllegalStateException("Value inside of 'materialEffectOverrides' map is missing/null");
            }
        }
        return this;
    }

    @NotNull
    public static Config read(@NotNull Path directory) {
        block12: {
            Config config;
            block11: {
                Path filePath = directory.resolve("trimseffects-config2.json");
                Path tempPath = directory.resolve("trimseffects-config2.json.tmp");
                BufferedReader reader = Files.newBufferedReader(filePath);
                try {
                    config = ((Config)GSON.fromJson((Reader)reader, Config.class)).verify();
                    if (reader == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (reader != null) {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (NoSuchFileException cause) {
                        TrimEffects2.LOGGER.warn("(TrimsEffects) Config file not found: {}", (Object)filePath);
                        Config.writeDefaultConfig(filePath, tempPath);
                        break block12;
                    }
                    catch (JsonParseException | IllegalStateException cause) {
                        TrimEffects2.LOGGER.error("(TrimsEffects) Config file is invalid! {}", (Object)cause.getMessage());
                        break block12;
                    }
                    catch (IOException cause) {
                        TrimEffects2.LOGGER.error("(TrimsEffects) Failed to read config file, IO error", (Throwable)cause);
                        break block12;
                    }
                    catch (Exception cause) {
                        TrimEffects2.LOGGER.error("(TrimsEffects) Failed to read config file", (Throwable)cause);
                    }
                }
                reader.close();
            }
            return config;
        }
        TrimEffects2.LOGGER.warn("(TrimsEffects) Using default config values");
        return (Config)GSON.fromJson(DEFAULT, Config.class);
    }

    private static void writeDefaultConfig(@NotNull Path filePath, @NotNull Path tempPath) {
        try {
            Files.writeString(tempPath, (CharSequence)DEFAULT, new OpenOption[0]);
            Files.move(tempPath, filePath, StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException cause) {
            TrimEffects2.LOGGER.error("(TrimsEffects) Failed to write default config file, IO error", (Throwable)cause);
        }
        catch (Exception cause) {
            TrimEffects2.LOGGER.error("(TrimsEffects) Failed to write default config file", (Throwable)cause);
        }
    }
}

