/*
 * Decompiled with CFR 0.152.
 */
package com.github.thedeathlycow.thermoo.patches.compat.adastra;

import com.github.thedeathlycow.thermoo.api.temperature.HeatingMode;
import com.github.thedeathlycow.thermoo.api.temperature.HeatingModes;
import com.github.thedeathlycow.thermoo.api.temperature.event.EnvironmentControllerInitializeEvent;
import com.github.thedeathlycow.thermoo.api.temperature.event.PlayerEnvironmentEvents;
import com.github.thedeathlycow.thermoo.api.util.TemperatureConverter;
import com.github.thedeathlycow.thermoo.patches.ThermooPatches;
import com.github.thedeathlycow.thermoo.patches.compat.adastra.SpaceEnvironmentController;
import com.github.thedeathlycow.thermoo.patches.config.AdAstraConfig;
import earth.terrarium.adastra.api.events.AdAstraEvents;
import earth.terrarium.adastra.api.planets.Planet;
import earth.terrarium.adastra.api.planets.PlanetApi;
import earth.terrarium.adastra.api.systems.TemperatureApi;
import earth.terrarium.adastra.common.items.armor.SpaceSuitItem;
import earth.terrarium.adastra.common.tags.ModItemTags;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.minecraft.class_6862;

public class AdAstraIntegration {
    public static void init() {
        AdAstraEvents.HotTemperatureTickEvent.register((serverWorld, livingEntity) -> {
            AdAstraIntegration.temperatureTick(serverWorld, livingEntity);
            return false;
        });
        AdAstraEvents.ColdTemperatureTickEvent.register((serverWorld, livingEntity) -> {
            AdAstraIntegration.temperatureTick(serverWorld, livingEntity);
            return false;
        });
        EnvironmentControllerInitializeEvent.EVENT.register(EnvironmentControllerInitializeEvent.OVERRIDE_PHASE, SpaceEnvironmentController::new);
        PlayerEnvironmentEvents.CAN_APPLY_PASSIVE_TEMPERATURE_CHANGE.register((change, player) -> {
            AdAstraConfig config = ThermooPatches.getConfig().adAstraConfig;
            if (config.spaceSuitsBlockPassiveTemperatureOnEarth()) {
                Planet planet = PlanetApi.API.getPlanet(player.method_37908());
                if (planet != null && !planet.oxygen()) {
                    return true;
                }
                return !SpaceSuitItem.hasFullSet((class_1309)player, (class_6862)ModItemTags.SPACE_SUITS);
            }
            return true;
        });
    }

    static int getPlanetTemperature(class_1937 world, class_2338 pos) {
        Planet planet = PlanetApi.API.getPlanet(world);
        if (planet == null) {
            return 0;
        }
        if (!planet.oxygen()) {
            double temperatureCelsius = TemperatureApi.API.getTemperature(world, pos);
            return TemperatureConverter.celsiusToTemperatureTick((double)temperatureCelsius);
        }
        return 0;
    }

    private static void temperatureTick(class_3218 world, class_1309 entity) {
        int temperatureChange = AdAstraIntegration.getPlanetTemperature((class_1937)world, entity.method_24515());
        boolean applyChange = true;
        if (entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            applyChange = ((PlayerEnvironmentEvents.TemperatureChangeEventCallback)PlayerEnvironmentEvents.CAN_APPLY_PASSIVE_TEMPERATURE_CHANGE.invoker()).canApplyChange(temperatureChange, player);
        }
        if (applyChange) {
            entity.thermoo$addTemperature(temperatureChange * 20, (HeatingMode)HeatingModes.PASSIVE);
        }
    }

    private AdAstraIntegration() {
    }
}

