/*
 * Decompiled with CFR 0.152.
 */
package com.github.thedeathlycow.thermoo.patches;

import com.github.thedeathlycow.thermoo.patches.IntegratedMod;
import com.github.thedeathlycow.thermoo.patches.MultiDependencyException;
import com.github.thedeathlycow.thermoo.patches.compat.adastra.AdAstraIntegration;
import com.github.thedeathlycow.thermoo.patches.compat.fabricseasons.FabricSeasonsProvider;
import com.github.thedeathlycow.thermoo.patches.compat.sereneseasons.SereneSeasonsProvider;
import com.github.thedeathlycow.thermoo.patches.config.ThermooPatchesConfig;
import java.util.Arrays;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.serializer.GsonConfigSerializer;
import net.fabricmc.api.ModInitializer;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Contract;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThermooPatches
implements ModInitializer {
    public static final String MODID = "thermoo-patches";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"thermoo-patches");

    @Contract(value="_->new")
    public static class_2960 id(String path) {
        return new class_2960(MODID, path);
    }

    public static ThermooPatchesConfig getConfig() {
        return (ThermooPatchesConfig)AutoConfig.getConfigHolder(ThermooPatchesConfig.class).get();
    }

    public void onInitialize() {
        AutoConfig.register(ThermooPatchesConfig.class, GsonConfigSerializer::new);
        ThermooPatches.checkMultiDependency(IntegratedMod.ARMOR_POINTS_PP, IntegratedMod.LIBHUD);
        FabricSeasonsProvider.registerSeasonProviderEvent();
        SereneSeasonsProvider.initialize();
        if (IntegratedMod.AD_ASTRA.isModLoaded()) {
            AdAstraIntegration.init();
        }
        ThermooPatches.logPatchedMods();
    }

    private static void checkMultiDependency(IntegratedMod ... requiredMods) {
        boolean isNotMet = Arrays.stream(requiredMods).map(IntegratedMod::isModLoaded).reduce(false, (acc, isLoaded) -> acc ^ isLoaded);
        if (isNotMet) {
            throw new MultiDependencyException(requiredMods);
        }
    }

    private static void logPatchedMods() {
        StringBuilder builder = new StringBuilder();
        Arrays.stream(IntegratedMod.values()).filter(IntegratedMod::isModLoaded).forEach(mod -> {
            builder.append('\n');
            builder.append(" - ");
            builder.append(mod.getId());
        });
        if (builder.isEmpty()) {
            LOGGER.warn("No Thermoo patches available for current mod set!");
        } else {
            LOGGER.info("Initialized Thermoo Patches for the following mods: {}", (Object)builder);
        }
    }
}

