/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.knightlib.util;

import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2902;
import net.minecraft.class_3218;
import net.minecraft.class_3222;

public class PlayerUtil {
    public static void healPlayer(class_1657 player, float amount) {
        player.method_6033(Math.min(player.method_6063(), player.method_6032() + amount));
    }

    public static void teleportPlayer(class_1657 player, class_2338 pos) {
        player.method_5859((double)pos.method_10263() + 0.5, (double)pos.method_10264(), (double)pos.method_10260() + 0.5);
    }

    public static boolean giveItemToPlayer(class_1657 player, class_1799 itemStack) {
        int freeSpace = PlayerUtil.calculateFreeSpaceForItem(player, itemStack);
        if (freeSpace >= itemStack.method_7947()) {
            player.method_31548().method_7394(itemStack);
            return true;
        }
        if (freeSpace > 0) {
            class_1799 stackToAdd = itemStack.method_7972();
            stackToAdd.method_7939(freeSpace);
            player.method_31548().method_7394(stackToAdd);
        }
        class_1799 remainingStack = itemStack.method_7972();
        remainingStack.method_7939(itemStack.method_7947() - freeSpace);
        PlayerUtil.dropItemNearPlayer(player, remainingStack);
        return false;
    }

    private static int calculateFreeSpaceForItem(class_1657 player, class_1799 itemStack) {
        int freeSpace = 0;
        int maxStackSize = itemStack.method_7914();
        for (class_1799 stack : player.method_31548().field_7547) {
            if (stack.method_7960()) {
                freeSpace += maxStackSize;
            } else if (stack == itemStack) {
                freeSpace += maxStackSize - stack.method_7947();
            }
            if (freeSpace < itemStack.method_7947()) continue;
            return itemStack.method_7947();
        }
        return freeSpace;
    }

    private static void dropItemNearPlayer(class_1657 player, class_1799 itemStack) {
        class_1937 level = player.method_37908();
        if (!level.field_9236 && !itemStack.method_7960()) {
            class_1542 itemEntity = new class_1542(level, player.method_23317(), player.method_23318() + 0.5, player.method_23321(), itemStack);
            itemEntity.method_6982(40);
            level.method_8649((class_1297)itemEntity);
        }
    }

    public static boolean transferItemBetweenPlayers(class_1657 fromPlayer, class_1657 toPlayer, class_1799 itemStack, int amount) {
        class_1799 stackToTransfer = itemStack.method_7972();
        stackToTransfer.method_7939(amount);
        if (fromPlayer.method_31548().method_7379(stackToTransfer)) {
            fromPlayer.method_31548().method_7378(stackToTransfer);
            boolean addedToReceiver = toPlayer.method_31548().method_7394(stackToTransfer);
            if (!addedToReceiver) {
                PlayerUtil.dropItemNearPlayer(toPlayer, stackToTransfer);
            }
            return true;
        }
        return false;
    }

    public static boolean giveItemIfConditionsMet(class_1657 player, int requiredYLevel, int requiredExperience, class_1799 itemStack) {
        if (player.method_23318() > (double)requiredYLevel && player.field_7520 >= requiredExperience) {
            return PlayerUtil.giveItemToPlayer(player, itemStack);
        }
        return false;
    }

    public static boolean hasFreeInventorySlots(class_1657 player, int requiredSlots) {
        long freeSlots = player.method_31548().field_7547.stream().filter(class_1799::method_7960).count();
        return freeSlots >= (long)requiredSlots;
    }

    public static void setPlayerHunger(class_1657 player, int amount) {
        player.method_7344().method_7580(Math.min(20, Math.max(0, amount)));
    }

    public static boolean isPlayerAboveYLevel(class_1657 player, double yLevel) {
        return player.method_23318() > yLevel;
    }

    public static void killPlayer(class_1657 player) {
        player.method_6033(0.0f);
    }

    public static void launchPlayer(class_1657 player, class_243 direction, double velocity) {
        class_243 normalizedDirection = direction.method_1029();
        player.method_18799(normalizedDirection.method_1021(velocity));
        player.field_6007 = true;
    }

    public static void freezePlayer(class_1657 player, int freezeTicks) {
        player.method_32317(freezeTicks);
    }

    public static boolean isPlayerInWater(class_1657 player) {
        return player.method_5799();
    }

    public static void applyPotionEffect(class_1657 player, class_1291 effect, int duration, int amplifier) {
        player.method_6092(new class_1293(effect, duration, amplifier));
    }

    public static void pushPlayerAwayFromEntity(class_1657 player, class_1297 entity, double force) {
        class_243 direction = player.method_19538().method_1020(entity.method_19538()).method_1029();
        player.method_18799(direction.method_1021(force));
        player.field_6007 = true;
    }

    public static void setPlayerGlowing(class_1657 player, int duration) {
        PlayerUtil.applyPotionEffect(player, class_1294.field_5912, duration, 0);
    }

    public static boolean isPlayerWithinDistance(class_1657 player, class_2338 pos, double maxDistance) {
        return player.method_24515().method_19771((class_2382)pos, maxDistance);
    }

    public static boolean tryGiveItem(class_1657 player, class_1799 stack) {
        if (player.method_31548().method_7376() != -1) {
            player.method_31548().method_7394(stack);
            return true;
        }
        return false;
    }

    public static void resetPlayerPositionToSpawn(class_1657 player) {
        class_2338 spawnPos = ((class_3222)player).method_26280();
        if (spawnPos != null && player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            Optional spawnLocation = class_1657.method_26091((class_3218)((class_3218)serverPlayer.method_37908()), (class_2338)spawnPos, (float)((class_3222)player).method_30631(), (boolean)true, (boolean)false);
            if (spawnLocation.isPresent()) {
                class_243 spawnVec = (class_243)spawnLocation.get();
                player.method_5859(spawnVec.method_10216(), spawnVec.method_10214(), spawnVec.method_10215());
            } else {
                PlayerUtil.teleportToWorldSpawn(player);
            }
        } else {
            PlayerUtil.teleportToWorldSpawn(player);
        }
    }

    private static void teleportToWorldSpawn(class_1657 player) {
        class_2338 worldSpawn = player.method_37908().method_43126();
        player.method_5859((double)worldSpawn.method_10263(), (double)worldSpawn.method_10264(), (double)worldSpawn.method_10260());
    }

    public static class_1297 findClosestEntity(class_1657 player, double maxDistance, Predicate<class_1297> condition) {
        return player.method_37908().method_8333((class_1297)player, player.method_5829().method_1014(maxDistance), condition).stream().min(Comparator.comparingDouble(e -> e.method_5739((class_1297)player))).orElse(null);
    }

    public static String getFormattedInventoryString(class_1657 player) {
        return player.method_31548().field_7547.stream().filter(itemStack -> !itemStack.method_7960()).map(itemStack -> itemStack.method_7909().method_7876() + " x" + itemStack.method_7947()).collect(Collectors.joining(", "));
    }

    public static boolean isPlayerHoldingAnyItemFromList(class_1657 player, List<class_1799> itemList) {
        return itemList.stream().anyMatch(item -> player.method_6047().method_7909().equals(item.method_7909()));
    }

    public static List<class_1657> sortPlayersByExperienceLevel(List<class_1657> players) {
        return players.stream().sorted(Comparator.comparingInt(class_1657::method_6110).reversed()).collect(Collectors.toList());
    }

    public static <T extends class_1297> List<T> findEntitiesAroundPlayer(class_1657 player, Class<T> entityType, double radius) {
        return player.method_37908().method_18467(entityType, player.method_5829().method_1014(radius));
    }

    public static void randomTeleport(class_1657 player, double range) {
        double randomX = player.method_23317() + (Math.random() - 0.5) * range * 2.0;
        double randomZ = player.method_23321() + (Math.random() - 0.5) * range * 2.0;
        double y = player.method_37908().method_8624(class_2902.class_2903.field_13203, (int)randomX, (int)randomZ);
        player.method_5859(randomX, y, randomZ);
    }

    public static void fullyHealAndFeedPlayer(class_1657 player) {
        player.method_6033(player.method_6063());
        player.method_7344().method_7580(20);
        player.method_7344().method_7581(20.0f);
    }

    public static class_2338 findNearestBlockOfType(class_1657 player, List<class_2248> blockTypes, double radius) {
        class_2338 playerPos = player.method_24515();
        class_2338 nearestBlock = null;
        double closestDistance = Double.MAX_VALUE;
        for (class_2338 pos : class_2338.method_10097((class_2338)playerPos.method_10069((int)(-radius), (int)(-radius), (int)(-radius)), (class_2338)playerPos.method_10069((int)radius, (int)radius, (int)radius))) {
            double distance;
            if (!blockTypes.contains(player.method_37908().method_8320(pos).method_26204()) || !((distance = playerPos.method_10262((class_2382)pos)) < closestDistance)) continue;
            closestDistance = distance;
            nearestBlock = pos;
        }
        return nearestBlock;
    }

    public static int calculateInventoryValue(class_1657 player, Map<class_1792, Integer> itemValues) {
        return player.method_31548().field_7547.stream().filter(itemStack -> !itemStack.method_7960() && itemValues.containsKey(itemStack.method_7909())).mapToInt(itemStack -> (Integer)itemValues.get(itemStack.method_7909()) * itemStack.method_7947()).sum();
    }

    public static void executeRunnableAtLocation(class_1657 player, class_2338 targetPos, double radius, Runnable runnable) {
        if (player.method_24515().method_19771((class_2382)targetPos, radius)) {
            runnable.run();
        }
    }

    public static void logPlayerState(class_1657 player) {
        System.out.printf("Player Position: [x: %.2f, y: %.2f, z: %.2f]%n", player.method_23317(), player.method_23318(), player.method_23321());
        System.out.println("Inventory: " + PlayerUtil.getFormattedInventoryString(player));
    }

    public static void sortInventoryByItemName(class_1657 player) {
        List<class_1799> sortedItems = player.method_31548().field_7547.stream().filter(itemStack -> !itemStack.method_7960()).sorted(Comparator.comparing(itemStack -> itemStack.method_7909().method_7876())).toList();
        class_1799[] armorBackup = new class_1799[4];
        for (class_1304 slot : class_1304.values()) {
            if (slot.method_5925() != class_1304.class_1305.field_6178) continue;
            armorBackup[slot.method_5927()] = (class_1799)player.method_31548().field_7548.get(slot.method_5927());
        }
        class_1799 offhandBackup = (class_1799)player.method_31548().field_7544.get(0);
        player.method_31548().method_5448();
        for (int i = 0; i < sortedItems.size() && i < player.method_31548().field_7547.size(); ++i) {
            player.method_31548().method_5447(i, sortedItems.get(i));
        }
        for (class_1304 slot : class_1304.values()) {
            if (slot.method_5925() != class_1304.class_1305.field_6178) continue;
            player.method_31548().field_7548.set(slot.method_5927(), (Object)armorBackup[slot.method_5927()]);
        }
        player.method_31548().field_7544.set(0, (Object)offhandBackup);
    }
}

