/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.knightlib.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_2487;
import net.minecraft.class_2561;

public class ItemStackUtil {
    public static boolean hasItemAmount(class_1657 player, class_1792 item, int count) {
        int totalCount = 0;
        for (class_1799 stack : player.method_31548().field_7547) {
            if (stack.method_7909() != item || (totalCount += stack.method_7947()) < count) continue;
            return true;
        }
        return false;
    }

    public static boolean removeItemFromPlayer(class_1657 player, class_1792 item, int count) {
        int remaining = count;
        for (int i = 0; i < player.method_31548().method_5439(); ++i) {
            class_1799 stack = player.method_31548().method_5438(i);
            if (stack.method_7909() != item) continue;
            int stackCount = stack.method_7947();
            if (stackCount > remaining) {
                stack.method_7934(remaining);
                return true;
            }
            remaining -= stackCount;
            player.method_31548().method_5447(i, class_1799.field_8037);
        }
        return remaining <= 0;
    }

    public static void clearEnchantments(class_1799 stack) {
        class_2487 tag;
        if (stack.method_7942() && (tag = stack.method_7969()) != null) {
            tag.method_10551("Enchantments");
        }
    }

    public static class_1799 setCustomName(class_1799 stack, String name) {
        stack.method_7977((class_2561)class_2561.method_43470((String)name));
        return stack;
    }

    public static boolean hasEnchantment(class_1799 stack, class_1887 enchantment) {
        return class_1890.method_8222((class_1799)stack).containsKey(enchantment);
    }

    public static class_1799 combineEnchantments(class_1799 stack1, class_1799 stack2) {
        if (stack1.method_7909() != stack2.method_7909()) {
            return stack1;
        }
        Map enchantment1 = class_1890.method_8222((class_1799)stack1);
        Map enchantment2 = class_1890.method_8222((class_1799)stack2);
        enchantment2.forEach((enchantment, level) -> enchantment1.merge(enchantment, level, Math::max));
        class_1890.method_8214((Map)enchantment1, (class_1799)stack1);
        return stack1;
    }

    public static List<class_1799> splitStack(class_1799 stack, int size) {
        int splitSize;
        ArrayList<class_1799> result = new ArrayList<class_1799>();
        for (int remaining = stack.method_7947(); remaining > 0; remaining -= splitSize) {
            splitSize = Math.min(size, remaining);
            class_1799 splitStack = stack.method_7972();
            splitStack.method_7939(splitSize);
            result.add(splitStack);
        }
        return result;
    }

    public static boolean repairItem(class_1799 stack, int repairAmount) {
        if (!stack.method_7963() || stack.method_7919() == 0) {
            return false;
        }
        int newDamage = stack.method_7919() - repairAmount;
        stack.method_7974(Math.max(newDamage, 0));
        return true;
    }

    public static boolean fullyRepairItem(class_1799 stack) {
        if (!stack.method_7963() || stack.method_7919() == 0) {
            return false;
        }
        stack.method_7974(0);
        return true;
    }

    public static boolean canStacksBeCombined(class_1799 stack1, class_1799 stack2) {
        if (stack1.method_7960() || stack2.method_7960()) {
            return false;
        }
        return stack1.method_7909() == stack2.method_7909() && stack1.method_7919() == stack2.method_7919() && !stack1.method_7942() && !stack2.method_7942();
    }

    public static int getTotalDurability(class_1799 stack) {
        if (!stack.method_7963()) {
            return 0;
        }
        return stack.method_7936();
    }

    public static int getRemainingDurability(class_1799 stack) {
        if (!stack.method_7963()) {
            return 0;
        }
        return stack.method_7936() - stack.method_7919();
    }

    public static void addCustomNBT(class_1799 stack, String key, String value) {
        class_2487 tag = stack.method_7948();
        tag.method_10582(key, value);
    }

    public static String getCustomNBT(class_1799 stack, String key) {
        class_2487 tag = stack.method_7969();
        return tag != null && tag.method_10545(key) ? tag.method_10558(key) : null;
    }
}

