/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.knightlib.util;

import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_4538;

public class BlockUtil {
    public static boolean isAirBlock(class_3218 level, class_2338 pos) {
        return level.method_8320(pos).method_26215();
    }

    public static void replaceBlock(class_3218 level, class_2338 pos, class_2248 newBlock) {
        level.method_8501(pos, newBlock.method_9564());
    }

    public static void dropBlockAsItem(class_3218 level, class_2338 pos) {
        class_2680 blockState = level.method_8320(pos);
        class_2248.method_9497((class_2680)blockState, (class_1937)level, (class_2338)pos);
        level.method_8652(pos, class_2246.field_10124.method_9564(), 3);
    }

    public static boolean isBlockSolid(class_3218 level, class_2338 pos) {
        class_2680 state = level.method_8320(pos);
        return state.method_26216((class_1922)level, pos);
    }

    public static boolean tryPlaceBlock(class_3218 level, class_2338 pos, class_2248 block, class_1657 player) {
        if (level.method_8320(pos).method_26215()) {
            level.method_8501(pos, block.method_9564());
            return true;
        }
        return false;
    }

    public static float getBlockHardness(class_3218 level, class_2338 pos) {
        class_2680 blockState = level.method_8320(pos);
        return blockState.method_26214((class_1922)level, pos);
    }

    public static boolean isBlockExposedToSunlight(class_3218 level, class_2338 pos) {
        return level.method_8311(pos);
    }

    public static boolean breakBlockAsPlayer(class_3218 level, class_2338 pos, class_1657 player) {
        class_2680 blockState = level.method_8320(pos);
        if (blockState.method_26214((class_1922)level, pos) >= 0.0f) {
            blockState.method_26204().method_9556((class_1937)level, player, pos, blockState, null, player.method_6047());
            level.method_8652(pos, class_2246.field_10124.method_9564(), 3);
            return true;
        }
        return false;
    }

    public static boolean isBlockSurroundedBySolidBlocks(class_3218 level, class_2338 pos) {
        return BlockUtil.isBlockSolid(level, pos.method_10084()) && BlockUtil.isBlockSolid(level, pos.method_10074()) && BlockUtil.isBlockSolid(level, pos.method_10095()) && BlockUtil.isBlockSolid(level, pos.method_10072()) && BlockUtil.isBlockSolid(level, pos.method_10067()) && BlockUtil.isBlockSolid(level, pos.method_10078());
    }

    public static int countBlockInArea(class_3218 level, class_2338 fromPos, class_2338 toPos, class_2248 blockToCount) {
        int count = 0;
        for (class_2338 pos : class_2338.method_10097((class_2338)fromPos, (class_2338)toPos)) {
            if (!level.method_8320(pos).method_27852(blockToCount)) continue;
            ++count;
        }
        return count;
    }

    public static void destroyBlocksInArea(class_3218 level, class_2338 fromPos, class_2338 toPos, boolean dropItems) {
        for (class_2338 pos : class_2338.method_10097((class_2338)fromPos, (class_2338)toPos)) {
            class_2680 state = level.method_8320(pos);
            if (state.method_26215()) continue;
            if (dropItems) {
                class_2248.method_9497((class_2680)state, (class_1937)level, (class_2338)pos);
            }
            level.method_8652(pos, class_2246.field_10124.method_9564(), 3);
        }
    }

    public static class_2338 findFirstSolidBlockBelow(class_3218 level, class_2338 pos) {
        class_2338 currentPos = pos.method_10074();
        while (currentPos.method_10264() > level.method_31607()) {
            if (!level.method_8320(currentPos).method_26215()) {
                return currentPos;
            }
            currentPos = currentPos.method_10074();
        }
        return null;
    }

    public static Set<class_2248> getBlocksInArea(class_3218 level, class_2338 fromPos, class_2338 toPos) {
        return class_2338.method_20437((class_2338)fromPos, (class_2338)toPos).map(pos -> level.method_8320(pos).method_26204()).collect(Collectors.toSet());
    }

    public static boolean placeBlockWithValidation(class_3218 level, class_2338 pos, class_2248 block, class_1750 context) {
        class_2680 blockState = block.method_9564();
        if (blockState.method_26184((class_4538)level, pos)) {
            level.method_8652(pos, blockState, 3);
            return true;
        }
        return false;
    }

    public static void replaceMostFrequentBlock(class_3218 level, class_2338 fromPos, class_2338 toPos, class_2248 replacementBlock) {
        Map<class_2248, Long> blockFrequency = class_2338.method_20437((class_2338)fromPos, (class_2338)toPos).map(pos -> level.method_8320(pos).method_26204()).collect(Collectors.groupingBy(block -> block, Collectors.counting()));
        blockFrequency.entrySet().stream().max(Map.Entry.comparingByValue()).map(Map.Entry::getKey).ifPresent(mostFrequentBlock -> class_2338.method_20437((class_2338)fromPos, (class_2338)toPos).filter(pos -> level.method_8320(pos).method_26204() == mostFrequentBlock).forEach(pos -> level.method_8501(pos, replacementBlock.method_9564())));
    }

    public static Stream<class_2338> getBlocksWithCondition(class_3218 level, class_2338 fromPos, class_2338 toPos, Predicate<class_2680> condition) {
        return class_2338.method_20437((class_2338)fromPos, (class_2338)toPos).filter(pos -> condition.test(level.method_8320(pos)));
    }

    public static void replaceBlocksWithCondition(class_3218 level, class_2338 fromPos, class_2338 toPos, Predicate<class_2680> condition, class_2248 replacementBlock) {
        class_2338.method_20437((class_2338)fromPos, (class_2338)toPos).filter(pos -> condition.test(level.method_8320(pos))).forEach(pos -> level.method_8501(pos, replacementBlock.method_9564()));
    }
}

