/*
 * Decompiled with CFR 0.152.
 */
package safro.archon.item;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import org.jetbrains.annotations.Nullable;
import safro.archon.Archon;
import safro.archon.api.summon.Summon;
import safro.archon.api.summon.SummonHandler;
import safro.archon.enchantment.ArcaneEnchantment;
import safro.archon.registry.ItemRegistry;
import safro.archon.util.ArchonUtil;

public class UndeadStaffItem
extends class_1792 {
    public UndeadStaffItem(class_1792.class_1793 settings) {
        super(settings);
    }

    public void method_7888(class_1799 stack, class_1937 world, class_1297 entity, int slot, boolean selected) {
        if (!world.method_8608() && entity instanceof class_3222) {
            class_3222 player = (class_3222)entity;
            for (int i = 0; i < player.method_31548().method_5439(); ++i) {
                if (!player.method_31548().method_5438(i).method_31574(ItemRegistry.SOUL)) continue;
                player.method_31548().method_5438(i).method_7934(1);
                UndeadStaffItem.addSoul(stack);
            }
        }
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 player, class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        if (!world.field_9236) {
            if (UndeadStaffItem.getSummons(stack).isEmpty()) {
                player.method_7353((class_2561)class_2561.method_43471((String)"text.archon.no_summons").method_27692(class_124.field_1061), true);
                return class_1271.method_22430((Object)stack);
            }
            Summon current = UndeadStaffItem.getCurrentSummon(stack);
            if (player.method_5715()) {
                UndeadStaffItem.cycleSummons(stack);
                player.method_7353((class_2561)class_2561.method_43471((String)UndeadStaffItem.getCurrentSummon(stack).getTranslationKey()).method_27692(class_124.field_1060), true);
                return class_1271.method_22427((Object)stack);
            }
            if (current != null && ArchonUtil.canRemoveMana(player, 100)) {
                int soulPower = UndeadStaffItem.getSoulPower(stack);
                current.onSummon((class_3218)world, player, soulPower);
                ArcaneEnchantment.applyArcane(player, stack, 100);
                player.method_7357().method_7906((class_1792)this, 100);
                world.method_8396(null, player.method_24515(), class_3417.field_38067, class_3419.field_15248, 0.9f, 1.0f);
                return class_1271.method_22427((Object)stack);
            }
        }
        return class_1271.method_22430((Object)stack);
    }

    @Nullable
    public static Summon getCurrentSummon(class_1799 stack) {
        ArrayList<Summon> summons = UndeadStaffItem.getSummons(stack);
        return summons.isEmpty() ? null : summons.get(0);
    }

    public static void cycleSummons(class_1799 stack) {
        ArrayList<Summon> summons = UndeadStaffItem.getSummons(stack);
        if (summons.size() > 1) {
            Collections.rotate(summons, 1);
            UndeadStaffItem.saveSummons(summons, stack);
        }
    }

    public static void addSummon(Summon summon, class_1799 stack) {
        ArrayList<Summon> list = UndeadStaffItem.getSummons(stack);
        list.add(summon);
        UndeadStaffItem.saveSummons(list, stack);
    }

    public static ArrayList<Summon> getSummons(class_1799 stack) {
        ArrayList<Summon> list = new ArrayList<Summon>();
        class_2499 nbtList = stack.method_7948().method_10554("Summons", 10);
        for (int i = 0; i < nbtList.size(); ++i) {
            class_2487 tag = nbtList.method_10602(i);
            list.add(SummonHandler.fromString(tag.method_10558("Id")));
        }
        return list;
    }

    private static void saveSummons(ArrayList<Summon> summons, class_1799 stack) {
        class_2499 nbtList = new class_2499();
        for (Summon s : summons) {
            class_2487 tag = new class_2487();
            String id = SummonHandler.getId(s);
            if (id != null) {
                tag.method_10582("Id", id);
                nbtList.add((Object)tag);
                continue;
            }
            Archon.LOGGER.error("Skipping saving " + s + " as it does not have a registered identifier.");
        }
        stack.method_7948().method_10566("Summons", (class_2520)nbtList);
    }

    public static int getSouls(class_1799 stack) {
        return stack.method_7948().method_10545("Souls") ? stack.method_7948().method_10550("Souls") : 0;
    }

    public static void addSoul(class_1799 stack) {
        stack.method_7948().method_10569("Souls", UndeadStaffItem.getSouls(stack) + 1);
    }

    public static int getSoulPower(class_1799 stack) {
        if (stack.method_7948().method_10545("Souls") && UndeadStaffItem.getSouls(stack) >= 5) {
            int souls = UndeadStaffItem.getSouls(stack);
            double scaled = Math.log((double)souls / 5.0) / Math.log(1.1);
            return (int)Math.ceil(1.0 + scaled);
        }
        return 0;
    }

    @Environment(value=EnvType.CLIENT)
    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 context) {
        if (UndeadStaffItem.getCurrentSummon(stack) != null) {
            String key = UndeadStaffItem.getCurrentSummon(stack).getTranslationKey();
            tooltip.add((class_2561)class_2561.method_43469((String)"text.archon.current_summon", (Object[])new Object[]{class_2561.method_43471((String)key).getString()}).method_27692(class_124.field_1080));
        } else {
            tooltip.add((class_2561)class_2561.method_43471((String)"text.archon.summon_none").method_27692(class_124.field_1080));
        }
        tooltip.add((class_2561)class_2561.method_43473());
        int souls = UndeadStaffItem.getSouls(stack);
        int power = UndeadStaffItem.getSoulPower(stack);
        tooltip.add((class_2561)class_2561.method_43469((String)"text.archon.undead.power", (Object[])new Object[]{power}).method_27692(class_124.field_1062));
        tooltip.add((class_2561)class_2561.method_43469((String)"text.archon.undead.souls", (Object[])new Object[]{souls}).method_27692(class_124.field_1068));
        super.method_7851(stack, world, tooltip, context);
    }

    public int method_7837() {
        return 3;
    }

    public boolean method_7870(class_1799 stack) {
        return true;
    }
}

