/*
 * Decompiled with CFR 0.152.
 */
package safro.archon.entity.projectile;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1675;
import net.minecraft.class_1676;
import net.minecraft.class_1937;
import net.minecraft.class_2223;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;
import safro.archon.Archon;
import safro.archon.api.spell.HitExecutor;
import safro.archon.client.particle.SpellParticleEffect;

public class SpellProjectileEntity
extends class_1676 {
    private static final int MAX_AGE = 400;
    private static final class_2940<Float> RED = class_2945.method_12791(SpellProjectileEntity.class, (class_2941)class_2943.field_13320);
    private static final class_2940<Float> GREEN = class_2945.method_12791(SpellProjectileEntity.class, (class_2941)class_2943.field_13320);
    private static final class_2940<Float> BLUE = class_2945.method_12791(SpellProjectileEntity.class, (class_2941)class_2943.field_13320);
    private static final class_2940<Float> SIZE = class_2945.method_12791(SpellProjectileEntity.class, (class_2941)class_2943.field_13320);
    private static final class_2940<Boolean> ENABLED = class_2945.method_12791(SpellProjectileEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<class_2394> SECOND_PARTICLE = class_2945.method_12791(SpellProjectileEntity.class, (class_2941)class_2943.field_13314);
    private final HitExecutor hitExecutor;

    public SpellProjectileEntity(class_1299<? extends SpellProjectileEntity> entityType, class_1937 world) {
        super(entityType, world);
        this.hitExecutor = HitExecutor.EMPTY;
    }

    public SpellProjectileEntity(class_1299<? extends SpellProjectileEntity> entityType, class_1937 world, class_1309 owner, HitExecutor hitExecutor) {
        super(entityType, world);
        this.hitExecutor = hitExecutor;
        this.method_7432((class_1297)owner);
        this.method_5814(owner.method_23317(), owner.method_23320() - (double)0.1f, owner.method_23321());
    }

    public void method_5773() {
        super.method_5773();
        if (this.field_6012 > 400) {
            this.method_31472();
        } else {
            class_3966 entityHitResult;
            class_243 current = this.method_19538();
            class_243 next = current.method_1019(this.method_18798());
            class_3965 hitResult = this.method_37908().method_17742(new class_3959(current, next, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)this));
            if (hitResult.method_17783() != class_239.class_240.field_1333) {
                next = hitResult.method_17784();
            }
            if ((entityHitResult = this.getEntityCollision(current, next)) != null) {
                hitResult = entityHitResult;
            }
            if (hitResult != null && hitResult.method_17783() == class_239.class_240.field_1331) {
                class_1297 entity = ((class_3966)hitResult).method_17782();
                class_1297 entity2 = this.method_24921();
                if (entity instanceof class_1657 && entity2 instanceof class_1657 && !((class_1657)entity2).method_7256((class_1657)entity)) {
                    hitResult = null;
                }
            }
            if (hitResult != null) {
                this.method_7488((class_239)hitResult);
                this.field_6007 = true;
            }
            class_243 vec3d = this.method_18798();
            double x = this.method_23317() + vec3d.field_1352;
            double y = this.method_23318() + vec3d.field_1351;
            double z = this.method_23321() + vec3d.field_1350;
            this.method_18800(vec3d.field_1352, vec3d.field_1351, vec3d.field_1350);
            this.method_5814(x, y, z);
            this.method_5852();
            if (this.method_37908().method_8608() && this.field_6012 > 4) {
                if (((Boolean)this.field_6011.method_12789(ENABLED)).booleanValue()) {
                    this.addMainParticles();
                }
                if (this.getSecondParticle() != class_2398.field_11245 && this.getSecondParticle() != null) {
                    this.method_37908().method_8406(this.getSecondParticle(), this.method_23317(), this.method_23318() + 0.5, this.method_23321(), 0.0, 0.0, 0.0);
                }
            }
        }
    }

    private void addMainParticles() {
        SpellParticleEffect particle = new SpellParticleEffect(((Float)this.field_6011.method_12789(RED)).floatValue(), ((Float)this.field_6011.method_12789(GREEN)).floatValue(), ((Float)this.field_6011.method_12789(BLUE)).floatValue(), ((Float)this.field_6011.method_12789(SIZE)).floatValue());
        double deltaX = this.method_23317() - this.field_6038;
        double deltaY = this.method_23318() - this.field_5971;
        double deltaZ = this.method_23321() - this.field_5989;
        double distance = Math.ceil(Math.sqrt(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ) * 6.0);
        for (double i = 0.0; i < distance; i += 1.0) {
            double step = i / distance;
            this.method_37908().method_8406((class_2394)particle, (double)((float)(this.field_6014 + deltaX * step)), (double)((float)(this.field_6036 + deltaY * step) + 0.1f), (double)((float)(this.field_5969 + deltaZ * step)), (double)(0.0125f * (this.field_5974.method_43057() - 0.5f)), (double)(0.0125f * (this.field_5974.method_43057() - 0.5f)), (double)(0.0125f * (this.field_5974.method_43057() - 0.5f)));
        }
    }

    @Nullable
    protected class_3966 getEntityCollision(class_243 currentPosition, class_243 nextPosition) {
        return class_1675.method_18077((class_1937)this.method_37908(), (class_1297)this, (class_243)currentPosition, (class_243)nextPosition, (class_238)this.method_5829().method_18804(this.method_18798()).method_1014(1.0), x$0 -> this.method_26958((class_1297)x$0));
    }

    protected void method_7454(class_3966 entityHitResult) {
        super.method_7454(entityHitResult);
        if (!this.method_37908().method_8608()) {
            class_1297 class_12972 = entityHitResult.method_17782();
            if (class_12972 instanceof class_1309) {
                class_1309 owner;
                class_1309 target = (class_1309)class_12972;
                class_12972 = this.method_24921();
                if (class_12972 instanceof class_1309 && target != (owner = (class_1309)class_12972)) {
                    this.hitExecutor.onHit(target, owner, this);
                    class_243 pos = entityHitResult.method_17784();
                    for (int i = 0; i < 10; ++i) {
                        double x = pos.method_10216() + 0.5;
                        double y = pos.method_10214() + 1.2;
                        double z = pos.method_10215() + 0.5;
                        double vX = (target.method_6051().method_43058() - 0.5) / 3.0;
                        double vY = (target.method_6051().method_43058() - 0.5) / 3.0;
                        double vZ = (target.method_6051().method_43058() - 0.5) / 3.0;
                        ((class_3218)this.method_37908()).method_14199((class_2394)new SpellParticleEffect(((Float)this.field_6011.method_12789(RED)).floatValue(), ((Float)this.field_6011.method_12789(GREEN)).floatValue(), ((Float)this.field_6011.method_12789(BLUE)).floatValue(), ((Float)this.field_6011.method_12789(SIZE)).floatValue()), x, y, z, 1, vX, vY, vZ, 1.0);
                    }
                }
            }
            this.method_31472();
        }
    }

    protected void method_24920(class_3965 blockHitResult) {
        super.method_24920(blockHitResult);
        if (!this.method_37908().field_9236) {
            this.method_31472();
        }
    }

    public void method_24919(class_1297 shooter, float pitch, float yaw, float roll, float speed, float divergence) {
        float f = -class_3532.method_15374((float)(yaw * ((float)Math.PI / 180))) * class_3532.method_15362((float)(pitch * ((float)Math.PI / 180)));
        float g = -class_3532.method_15374((float)((pitch + roll) * ((float)Math.PI / 180)));
        float h = class_3532.method_15362((float)(yaw * ((float)Math.PI / 180))) * class_3532.method_15362((float)(pitch * ((float)Math.PI / 180)));
        this.method_7485(f, g, h, speed, divergence);
    }

    public void method_7485(double x, double y, double z, float speed, float divergence) {
        class_243 vec3d = new class_243(x, y, z).method_1029().method_1031(this.field_5974.method_43059() * (double)0.0075f * (double)divergence, this.field_5974.method_43059() * (double)0.0075f * (double)divergence, this.field_5974.method_43059() * (double)0.0075f * (double)divergence).method_1021((double)speed);
        this.method_18799(vec3d);
        float d = (float)Math.sqrt(vec3d.method_37268());
        this.method_36456((float)(class_3532.method_15349((double)vec3d.field_1352, (double)vec3d.field_1350) * 180.0 / 3.1415927410125732));
        this.method_36457((float)(class_3532.method_15349((double)vec3d.field_1351, (double)d) * 180.0 / 3.1415927410125732));
        this.field_5982 = this.method_36454();
        this.field_6004 = this.method_36455();
    }

    public void setParticle(float red, float green, float blue, float size) {
        this.field_6011.method_12778(RED, (Object)Float.valueOf(red));
        this.field_6011.method_12778(GREEN, (Object)Float.valueOf(green));
        this.field_6011.method_12778(BLUE, (Object)Float.valueOf(blue));
        this.field_6011.method_12778(SIZE, (Object)Float.valueOf(size));
    }

    public void disableMainParticles() {
        this.field_6011.method_12778(ENABLED, (Object)false);
    }

    public class_2394 getSecondParticle() {
        return (class_2394)this.method_5841().method_12789(SECOND_PARTICLE);
    }

    public void setSecondParticle(class_2394 particle) {
        this.method_5841().method_12778(SECOND_PARTICLE, (Object)particle);
    }

    protected void method_5693() {
        this.field_6011.method_12784(RED, (Object)Float.valueOf(1.0f));
        this.field_6011.method_12784(GREEN, (Object)Float.valueOf(1.0f));
        this.field_6011.method_12784(BLUE, (Object)Float.valueOf(1.0f));
        this.field_6011.method_12784(SIZE, (Object)Float.valueOf(0.5f));
        this.field_6011.method_12784(ENABLED, (Object)true);
        this.field_6011.method_12784(SECOND_PARTICLE, (Object)class_2398.field_11245);
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10548("Red", ((Float)this.field_6011.method_12789(RED)).floatValue());
        nbt.method_10548("Green", ((Float)this.field_6011.method_12789(GREEN)).floatValue());
        nbt.method_10548("Blue", ((Float)this.field_6011.method_12789(BLUE)).floatValue());
        nbt.method_10548("Size", ((Float)this.field_6011.method_12789(SIZE)).floatValue());
        nbt.method_10556("Enabled", ((Boolean)this.field_6011.method_12789(ENABLED)).booleanValue());
        if (this.getSecondParticle() != class_2398.field_11245) {
            nbt.method_10582("SecondParticle", this.getSecondParticle().method_10293());
        }
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        this.field_6011.method_12778(RED, (Object)Float.valueOf(nbt.method_10583("Red")));
        this.field_6011.method_12778(GREEN, (Object)Float.valueOf(nbt.method_10583("Green")));
        this.field_6011.method_12778(BLUE, (Object)Float.valueOf(nbt.method_10583("Blue")));
        this.field_6011.method_12778(SIZE, (Object)Float.valueOf(nbt.method_10583("Size")));
        this.field_6011.method_12778(ENABLED, (Object)nbt.method_10577("Enabled"));
        if (nbt.method_10573("SecondParticle", 8)) {
            try {
                this.setSecondParticle(class_2223.method_9418((StringReader)new StringReader(nbt.method_10558("SecondParticle")), (class_7225)class_7923.field_41180.method_46771()));
            }
            catch (CommandSyntaxException var5) {
                Archon.LOGGER.warn("Couldn't load custom particle {}", (Object)nbt.method_10558("SecondParticle"), (Object)var5);
            }
        }
    }

    public boolean method_5732() {
        return false;
    }
}

