/*
 * Decompiled with CFR 0.152.
 */
package com.structureessentials.mixin;

import com.structureessentials.IGeneratorNearbyStructureHolder;
import com.structureessentials.StructureEssentials;
import com.structureessentials.config.CommonConfiguration;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_1923;
import net.minecraft.class_1959;
import net.minecraft.class_1966;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2794;
import net.minecraft.class_2893;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_3341;
import net.minecraft.class_3443;
import net.minecraft.class_3449;
import net.minecraft.class_3485;
import net.minecraft.class_5455;
import net.minecraft.class_5539;
import net.minecraft.class_6880;
import net.minecraft.class_7138;
import net.minecraft.class_7924;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_3195.class})
public abstract class StructureStartMinDistMixin {
    @Shadow
    @Final
    public class_3195.class_7302 field_38429;

    @Inject(method={"generate"}, at={@At(value="RETURN")}, cancellable=true)
    private void checkOtherStructuresNearby(class_5455 registryAccess, class_2794 generator, class_1966 biomeSource, class_7138 p_226600_, class_3485 p_226601_, long p_226602_, class_1923 p_226603_, int p_226604_, class_5539 p_226605_, Predicate<class_6880<class_1959>> p_226606_, CallbackInfoReturnable<class_3449> cir) {
        if (cir.getReturnValue() == class_3449.field_16713 || !((CommonConfiguration)CommonConfiguration.config.getCommonConfig()).minimumStructureDistanceEnabled) {
            return;
        }
        if (!(generator instanceof IGeneratorNearbyStructureHolder)) {
            if (((CommonConfiguration)CommonConfiguration.config.getCommonConfig()).minimumStructureDistanceLogging) {
                StructureEssentials.LOGGER.warn("Skipping structure minimum distance check, invalid generator: " + generator);
            }
            return;
        }
        IGeneratorNearbyStructureHolder nearbyStructureHolder = (IGeneratorNearbyStructureHolder)generator;
        int distance = ((CommonConfiguration)CommonConfiguration.config.getCommonConfig()).minimumStructureDistance;
        int xzOffset = 3000000 * distance;
        int yOffset = this.field_38429.comp_688() == class_2893.class_2895.field_13173 ? 2000 : 500;
        for (class_3443 piece : ((class_3449)cir.getReturnValue()).method_14963()) {
            class_2338 center = piece.method_35458();
            String nearby = nearbyStructureHolder.getNearby(class_2338.method_10064((int)((center.method_10263() + xzOffset) / distance), (int)((center.method_10264() + yOffset) / distance), (int)((center.method_10260() + xzOffset) / distance)));
            if (nearby == null && (piece.method_14935().method_35414() > 8 || piece.method_14935().method_14660() > 8 || piece.method_14935().method_14663() > 8)) {
                class_2338 pos;
                Iterator<class_2338> iterator = StructureStartMinDistMixin.getBoundingBoxCorners(piece.method_14935()).iterator();
                while (iterator.hasNext() && (nearby = nearbyStructureHolder.getNearby(class_2338.method_10064((int)(((pos = iterator.next()).method_10263() + xzOffset) / distance), (int)((pos.method_10264() + yOffset) / distance), (int)((pos.method_10260() + xzOffset) / distance)))) == null) {
                }
            }
            if (nearby == null) continue;
            if (((CommonConfiguration)CommonConfiguration.config.getCommonConfig()).minimumStructureDistanceLogging) {
                StructureEssentials.LOGGER.warn("Prevented structure overlap for: " + ((class_2378)registryAccess.method_33310(class_7924.field_41246).get()).method_10221((Object)((class_3195)this)) + " at: " + center + " existing structure: " + nearby);
            }
            cir.setReturnValue((Object)class_3449.field_16713);
            return;
        }
        class_2960 regID = ((class_2378)registryAccess.method_33310(class_7924.field_41246).get()).method_10221((Object)((class_3195)this));
        Object name = regID != null ? regID.toString() : "unknown:" + this;
        for (class_3443 piece : ((class_3449)cir.getReturnValue()).method_14963()) {
            class_2338 center = piece.method_35458();
            nearbyStructureHolder.setNearby(class_2338.method_10064((int)((center.method_10263() + xzOffset) / distance), (int)((center.method_10264() + 2000) / distance), (int)((center.method_10260() + xzOffset) / distance)), (String)name);
            if (piece.method_14935().method_35414() <= 8 && piece.method_14935().method_14660() <= 8 && piece.method_14935().method_14663() <= 8) continue;
            for (class_2338 pos : StructureStartMinDistMixin.getBoundingBoxCorners(piece.method_14935())) {
                nearbyStructureHolder.setNearby(class_2338.method_10064((int)((pos.method_10263() + xzOffset) / distance), (int)((pos.method_10264() + 2000) / distance), (int)((pos.method_10260() + xzOffset) / distance)), (String)name);
            }
        }
    }

    @Unique
    private static List<class_2338> getBoundingBoxCorners(class_3341 box) {
        return List.of(new class_2338(box.method_35415(), box.method_35416(), box.method_35417()), new class_2338(box.method_35415(), box.method_35416(), box.method_35420()), new class_2338(box.method_35415(), box.method_35419(), box.method_35417()), new class_2338(box.method_35415(), box.method_35419(), box.method_35420()), new class_2338(box.method_35418(), box.method_35416(), box.method_35417()), new class_2338(box.method_35418(), box.method_35416(), box.method_35420()), new class_2338(box.method_35418(), box.method_35419(), box.method_35417()), new class_2338(box.method_35418(), box.method_35419(), box.method_35420()));
    }
}

