/*
 * Decompiled with CFR 0.152.
 */
package com.structureessentials;

import com.structureessentials.IStructureModifier;
import com.structureessentials.Timings;
import com.structureessentials.command.Command;
import com.structureessentials.config.CommonConfiguration;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2DoubleMap;
import it.unimi.dsi.fastutil.objects.Object2DoubleOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.tag.convention.v1.ConventionalBiomeTags;
import net.minecraft.class_1959;
import net.minecraft.class_1972;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_6908;
import net.minecraft.class_7059;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class StructureEssentials
implements ModInitializer {
    public static final String MODID = "structureessentials";
    public static final Logger LOGGER = LogManager.getLogger();
    public static Random rand = new Random();

    public void onInitialize() {
        CommandRegistrationCallback.EVENT.register((dispatcher, buildContext, commandSelection) -> dispatcher.register(new Command().build(buildContext)));
        LOGGER.info("structureessentials mod initialized");
    }

    public static void onServerStart(MinecraftServer server) {
        Timings.featureTimings = new ConcurrentHashMap<class_2960, Long>();
        Timings.structureTimings = new ConcurrentHashMap<class_2960, Long>();
        class_5455.class_6890 registryAccess = server.method_30611();
        List holders = registryAccess.method_30530(class_7924.field_41246).method_40270().toList();
        class_2378 biomeRegistry = (class_2378)registryAccess.method_33310(class_7924.field_41236).get();
        class_2378 structureSetRegistry = registryAccess.method_30530(class_7924.field_41248);
        if (((CommonConfiguration)CommonConfiguration.config.getCommonConfig()).logDuplicatedSalt) {
            Int2ObjectOpenHashMap structureSetIds = new Int2ObjectOpenHashMap();
            for (Map.Entry entry : structureSetRegistry.method_29722()) {
                int salt = ((class_7059)entry.getValue()).comp_511().method_41645();
                structureSetIds.putIfAbsent(salt, new HashSet());
                ((Set)structureSetIds.get(salt)).add(((class_5321)entry.getKey()).method_29177().toString());
            }
            for (Map.Entry entry : structureSetIds.int2ObjectEntrySet()) {
                if (((Set)entry.getValue()).size() <= 1) continue;
                LOGGER.warn("Non-unique structure_set salt:" + entry.getIntKey() + " potentially creating overlapping structures detected. Structure sets: " + entry.getValue());
            }
        }
        if (!((CommonConfiguration)CommonConfiguration.config.getCommonConfig()).autoBiomeCompat) {
            return;
        }
        HashMap<class_2960, class_6862> directReplacementTags = new HashMap<class_2960, class_6862>();
        directReplacementTags.put(new class_2960("deep_ocean"), class_6908.field_36508);
        directReplacementTags.put(new class_2960("ocean"), class_6908.field_36509);
        directReplacementTags.put(new class_2960("river"), class_6908.field_36511);
        directReplacementTags.put(new class_2960("badlands"), class_6908.field_36513);
        directReplacementTags.put(new class_2960("eroded_badlands"), class_6908.field_36513);
        directReplacementTags.put(new class_2960("wooded_badlands"), class_6908.field_36513);
        directReplacementTags.put(new class_2960("windswept_hills"), class_6908.field_36514);
        directReplacementTags.put(new class_2960("windswept_gravelly_hills"), class_6908.field_36514);
        directReplacementTags.put(new class_2960("taiga"), class_6908.field_36515);
        directReplacementTags.put(new class_2960("jungle"), class_6908.field_36516);
        directReplacementTags.put(new class_2960("forest"), class_6908.field_36517);
        directReplacementTags.put(new class_2960("savanna"), class_6908.field_37392);
        directReplacementTags.put(new class_2960("deep_dark"), class_6908.field_38372);
        directReplacementTags.put(new class_2960("plains"), ConventionalBiomeTags.PLAINS);
        directReplacementTags.put(new class_2960("snowy_plains"), ConventionalBiomeTags.SNOWY_PLAINS);
        directReplacementTags.put(new class_2960("desert"), ConventionalBiomeTags.DESERT);
        directReplacementTags.put(new class_2960("swamp"), ConventionalBiomeTags.SWAMP);
        directReplacementTags.put(new class_2960("flower_forest"), ConventionalBiomeTags.FLOWER_FORESTS);
        directReplacementTags.put(new class_2960("birch_forest"), ConventionalBiomeTags.BIRCH_FOREST);
        directReplacementTags.put(new class_2960("stony_shore"), ConventionalBiomeTags.STONY_SHORES);
        directReplacementTags.put(new class_2960("mushroom_fields"), ConventionalBiomeTags.MUSHROOM);
        directReplacementTags.put(new class_2960("warped_forest"), ConventionalBiomeTags.NETHER_FORESTS);
        directReplacementTags.put(new class_2960("crimson_forest"), ConventionalBiomeTags.NETHER_FORESTS);
        Set<class_6862> DEFINING_TAGS = Set.of(class_6908.field_36511, class_6908.field_36508, class_6908.field_36509, class_6908.field_36510, class_6908.field_36513, class_6908.field_37392, class_6908.field_36515, class_6908.field_36516, class_6908.field_36517, class_6908.field_36512, StructureEssentials.createBiomeTag("forge", "is_cave"), StructureEssentials.createBiomeTag("forge", "is_plains"), StructureEssentials.createBiomeTag("forge", "is_desert"), StructureEssentials.createBiomeTag("forge", "is_snowy"), StructureEssentials.createBiomeTag("forge", "is_lush"), StructureEssentials.createBiomeTag("forge", "is_dead"), StructureEssentials.createBiomeTag("forge", "is_underground"), StructureEssentials.createBiomeTag("forge", "is_void"), StructureEssentials.createBiomeTag("forge", "is_sandy"), StructureEssentials.createBiomeTag("forge", "is_swamp"), StructureEssentials.createBiomeTag("c", "no_default_monsters"), StructureEssentials.createBiomeTag("c", "is_void"), StructureEssentials.createBiomeTag("c", "is_dense_vegetation"), StructureEssentials.createBiomeTag("c", "is_sparse_vegetation"), StructureEssentials.createBiomeTag("c", "is_plains"), StructureEssentials.createBiomeTag("c", "is_windswept"), StructureEssentials.createBiomeTag("c", "is_shallow_ocean"), StructureEssentials.createBiomeTag("c", "is_underground"), StructureEssentials.createBiomeTag("c", "is_cave"), StructureEssentials.createBiomeTag("c", "is_lush"), StructureEssentials.createBiomeTag("c", "is_dead"), StructureEssentials.createBiomeTag("c", "is_sandy"), StructureEssentials.createBiomeTag("c", "is_snowy"), StructureEssentials.createBiomeTag("c", "is_icy"), StructureEssentials.createBiomeTag("c", "is_swamp"), StructureEssentials.createBiomeTag("c", "is_aquatic"));
        for (class_6880.class_6883 holder : holders) {
            Object2DoubleMap.Entry scoredBiome;
            Object entry;
            Object biome22;
            LinkedHashSet<Object> biomeHolderSet = new LinkedHashSet<Object>(((class_3195)holder.comp_349()).method_41607().method_40247());
            float minTemp = 1000.0f;
            float maxTemp = -1000.0f;
            float maxDownfall = -1000.0f;
            float minDownfall = 1000.0f;
            Object2IntOpenHashMap allowedDefiningTags = new Object2IntOpenHashMap();
            for (Object biome22 : ((class_3195)holder.comp_349()).method_41607()) {
                float downFall;
                if (!holder.method_40227()) continue;
                biomeHolderSet.add(biome22);
                float temp = Command.getAdjustedTemp((class_6880<class_1959>)biome22);
                if (temp < minTemp) {
                    minTemp = temp;
                }
                if (temp > maxTemp) {
                    maxTemp = temp;
                }
                if ((downFall = ((class_1959)biome22.comp_349()).field_26393.comp_846()) < minDownfall) {
                    minDownfall = downFall;
                }
                if (downFall > maxDownfall) {
                    maxDownfall = downFall;
                }
                for (class_6862 biomeTagKey : DEFINING_TAGS) {
                    if (!biome22.method_40220(biomeTagKey)) continue;
                    allowedDefiningTags.put((Object)biomeTagKey, allowedDefiningTags.getOrDefault((Object)biomeTagKey, 0) + 1);
                }
            }
            HashSet<class_6862> deniedDefiningSet = new HashSet<class_6862>();
            biome22 = DEFINING_TAGS.iterator();
            while (biome22.hasNext()) {
                class_6862 biomeTagKey = (class_6862)biome22.next();
                if (allowedDefiningTags.containsKey((Object)biomeTagKey)) continue;
                deniedDefiningSet.add(biomeTagKey);
            }
            HashSet<class_6862> requiredDefiningSet = new HashSet<class_6862>();
            for (Object2IntMap.Entry entry2 : allowedDefiningTags.object2IntEntrySet()) {
                if (entry2.getIntValue() != ((class_3195)holder.comp_349()).method_41607().method_40247()) continue;
                requiredDefiningSet.add((class_6862)entry2.getKey());
            }
            if (biomeHolderSet.isEmpty()) continue;
            minTemp -= 0.35f;
            maxTemp += 0.35f;
            minDownfall -= 0.35f;
            maxDownfall += 0.35f;
            HashMap<class_3218, Set> allowedDimensions = new HashMap<class_3218, Set>();
            for (class_3218 level : server.method_3738()) {
                Set dimensionbiomes = level.method_14178().method_12129().method_12098().method_28443();
                allowedDimensions.put(level, dimensionbiomes);
            }
            Iterator iterator = allowedDimensions.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry dimensionBiomes = iterator.next();
                boolean contained = false;
                for (class_6880 class_68802 : biomeHolderSet) {
                    if (!((Set)dimensionBiomes.getValue()).contains(class_68802)) continue;
                    contained = true;
                    break;
                }
                if (contained && ((CommonConfiguration)CommonConfiguration.config.getCommonConfig()).dimensionWhitelist.contains(((class_3218)dimensionBiomes.getKey()).method_27983().method_29177().toString())) continue;
                iterator.remove();
            }
            HashSet<class_6862> addedTags = new HashSet<class_6862>(requiredDefiningSet);
            HashSet<class_6880> addedTagBiomes = new HashSet<class_6880>();
            HashSet<class_6880> toAdd = new HashSet<class_6880>();
            for (class_6862 class_68622 : requiredDefiningSet) {
                for (class_6880 class_68803 : biomeRegistry.method_40260(class_68622)) {
                    if (biomeHolderSet.contains(class_68803)) continue;
                    toAdd.add(class_68803);
                }
            }
            for (class_6880 class_68804 : biomeHolderSet) {
                class_6862 tag2 = (class_6862)directReplacementTags.get(biomeRegistry.method_10221((Object)((class_1959)class_68804.comp_349())));
                if (tag2 == null || addedTags.contains(tag2) || !class_68804.method_40220(tag2)) continue;
                for (class_6880 tagBiome2 : biomeRegistry.method_40260(tag2)) {
                    if (biomeHolderSet.contains(tagBiome2)) continue;
                    toAdd.add(tagBiome2);
                    addedTagBiomes.add(tagBiome2);
                }
                addedTags.add(tag2);
            }
            Object2DoubleOpenHashMap highScoreBiomes = new Object2DoubleOpenHashMap();
            Object2DoubleOpenHashMap object2DoubleOpenHashMap = new Object2DoubleOpenHashMap();
            for (class_6880 class_68805 : biomeHolderSet) {
                List<Object2DoubleMap.Entry<class_6880<class_1959>>> similar = Command.getSimilarBiomesFor((class_6880<class_1959>)class_68805, (class_5455)registryAccess);
                for (int i = 0; i < similar.size() && i < 200; ++i) {
                    entry = similar.get(i);
                    if (biomeHolderSet.contains(entry.getKey())) continue;
                    double percent = entry.getDoubleValue();
                    double previousValue = object2DoubleOpenHashMap.getOrDefault(entry.getKey(), 0.0);
                    double d = toAdd.contains(entry.getKey()) ? 0.7224999999999999 : 0.85;
                    if (percent >= d * ((CommonConfiguration)CommonConfiguration.config.getCommonConfig()).autoBiomeCompatStrictness) {
                        highScoreBiomes.put((Object)((class_6880)entry.getKey()), percent);
                    }
                    object2DoubleOpenHashMap.put((Object)((class_6880)entry.getKey()), previousValue + percent);
                }
            }
            for (Object2DoubleMap.Entry entry2 : object2DoubleOpenHashMap.object2DoubleEntrySet()) {
                entry2.setValue(entry2.getDoubleValue() / (double)biomeHolderSet.size());
            }
            if (highScoreBiomes.isEmpty()) continue;
            ArrayList<Object> sortedPotentialBiomes = new ArrayList<Object>((Collection<Object>)object2DoubleOpenHashMap.object2DoubleEntrySet());
            sortedPotentialBiomes.sort(Comparator.comparingDouble(e -> ((Object2DoubleMap.Entry)e).getDoubleValue()).reversed());
            Object2DoubleMap.Entry entry3 = (Object2DoubleMap.Entry)sortedPotentialBiomes.get(0);
            if (entry3 == null) continue;
            toAdd.clear();
            double minSimilarity = entry3.getDoubleValue() * 0.8 * ((CommonConfiguration)CommonConfiguration.config.getCommonConfig()).autoBiomeCompatStrictness;
            entry = sortedPotentialBiomes.iterator();
            while (entry.hasNext() && !((scoredBiome = (Object2DoubleMap.Entry)entry.next()).getDoubleValue() < minSimilarity)) {
                if (!highScoreBiomes.containsKey(scoredBiome.getKey())) continue;
                toAdd.add((class_6880)scoredBiome.getKey());
            }
            Iterator iterator2 = toAdd.iterator();
            block18: while (iterator2.hasNext()) {
                class_6880 biomeHolder = (class_6880)iterator2.next();
                if (!biomeHolder.method_40227() || biomeHolder.method_40230().isEmpty()) {
                    iterator2.remove();
                    continue;
                }
                class_5321 biomeKey = (class_5321)biomeHolder.method_40230().get();
                if (biomeKey == class_1972.field_9411 || biomeKey == class_1972.field_9473 || biomeKey == class_1972.field_9457) {
                    iterator2.remove();
                    continue;
                }
                boolean containedDimension = false;
                for (Set dimensionBiomes : allowedDimensions.values()) {
                    if (!dimensionBiomes.contains(biomeHolder)) continue;
                    containedDimension = true;
                    break;
                }
                if (!containedDimension) {
                    iterator2.remove();
                    continue;
                }
                if (((class_1959)biomeHolder.comp_349()).method_30970().method_30983().isEmpty()) {
                    iterator2.remove();
                    continue;
                }
                float temp = Command.getAdjustedTemp((class_6880<class_1959>)biomeHolder);
                float downFall = ((class_1959)biomeHolder.comp_349()).field_26393.comp_846();
                if (!(temp > minTemp && temp < maxTemp && downFall < maxDownfall && downFall > minDownfall)) {
                    iterator2.remove();
                    continue;
                }
                if (!biomeHolder.method_40228().anyMatch(tag -> tag.comp_327().method_12832().contains("structure"))) {
                    iterator2.remove();
                    continue;
                }
                boolean shouldRemove = false;
                for (class_6862 biomeTagKey : requiredDefiningSet) {
                    if (biomeHolder.method_40220(biomeTagKey) || addedTagBiomes.contains(biomeHolder)) continue;
                    shouldRemove = true;
                }
                if (shouldRemove) {
                    iterator2.remove();
                    continue;
                }
                for (class_6862 biomeTagKey : deniedDefiningSet) {
                    if (!biomeHolder.method_40220(biomeTagKey)) continue;
                    iterator2.remove();
                    continue block18;
                }
            }
            if (toAdd.isEmpty()) continue;
            String tagName = biomeRegistry.method_10221((Object)((class_1959)((class_6880)((class_3195)holder.comp_349()).method_41607().iterator().next()).comp_349())).toString();
            if (((class_3195)holder.comp_349()).method_41607().method_40248().left().isPresent()) {
                tagName = ((class_6862)((class_3195)holder.comp_349()).method_41607().method_40248().left().get()).comp_327().toString();
            }
            if (((CommonConfiguration)CommonConfiguration.config.getCommonConfig()).autoBiomeCompatLogging) {
                LOGGER.warn("Adding Biomes to structure: " + holder.method_40237().method_29177() + " tag:" + tagName + " mins:" + (double)((int)(minSimilarity * 1000.0)) / 1000.0 + " biomes: " + toAdd.stream().map(e -> ((class_5321)e.method_40230().get()).method_29177() + ":" + (double)((int)(potentialBiomes.getOrDefault(e, 0.0) * 1000.0)) / 1000.0).toList());
            }
            biomeHolderSet.addAll(toAdd);
            Object object = holder.comp_349();
            if (!(object instanceof IStructureModifier)) continue;
            IStructureModifier structureModifier = (IStructureModifier)object;
            structureModifier.setStructureBiomes((class_6885<class_1959>)class_6885.method_40242(new ArrayList(biomeHolderSet)));
        }
        Command.biomeScoreCache.clear();
    }

    public static class_2960 createResourcelocation(String namespace, String path) {
        return new class_2960(namespace, path);
    }

    public static class_6862<class_1959> createBiomeTag(String namespace, String path) {
        return class_6862.method_40092((class_5321)class_7924.field_41236, (class_2960)StructureEssentials.createResourcelocation(namespace, path));
    }
}

