/*
 * Decompiled with CFR 0.152.
 */
package io.github.fablabsmc.fablabs.api.fiber.v1.builder;

import io.github.fablabsmc.fablabs.api.fiber.v1.FiberId;
import io.github.fablabsmc.fablabs.api.fiber.v1.annotation.AnnotatedSettings;
import io.github.fablabsmc.fablabs.api.fiber.v1.builder.ConfigLeafBuilder;
import io.github.fablabsmc.fablabs.api.fiber.v1.exception.DuplicateChildException;
import io.github.fablabsmc.fablabs.api.fiber.v1.exception.FiberException;
import io.github.fablabsmc.fablabs.api.fiber.v1.exception.IllegalTreeStateException;
import io.github.fablabsmc.fablabs.api.fiber.v1.exception.RuntimeFiberException;
import io.github.fablabsmc.fablabs.api.fiber.v1.schema.type.SerializableType;
import io.github.fablabsmc.fablabs.api.fiber.v1.schema.type.derived.ConfigType;
import io.github.fablabsmc.fablabs.api.fiber.v1.tree.ConfigAttribute;
import io.github.fablabsmc.fablabs.api.fiber.v1.tree.ConfigBranch;
import io.github.fablabsmc.fablabs.api.fiber.v1.tree.ConfigLeaf;
import io.github.fablabsmc.fablabs.api.fiber.v1.tree.ConfigNode;
import io.github.fablabsmc.fablabs.api.fiber.v1.tree.ConfigTree;
import io.github.fablabsmc.fablabs.api.fiber.v1.tree.NodeCollection;
import io.github.fablabsmc.fablabs.api.fiber.v1.tree.PropertyMirror;
import io.github.fablabsmc.fablabs.impl.fiber.builder.ConfigNodeBuilder;
import io.github.fablabsmc.fablabs.impl.fiber.tree.ConfigBranchImpl;
import io.github.fablabsmc.fablabs.impl.fiber.tree.ConfigLeafImpl;
import io.github.fablabsmc.fablabs.impl.fiber.tree.IndexedNodeCollection;
import java.util.Collection;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ConfigTreeBuilder
extends ConfigNodeBuilder
implements ConfigTree {
    private final NodeCollection items = new IndexedNodeCollection(null);
    @Nullable
    private String name;
    @Nullable
    private String comment;
    private boolean serializeSeparately;

    public ConfigTreeBuilder(@Nullable ConfigTree parent, @Nullable String name) {
        super(parent, name);
        this.parent = parent;
        this.name = name;
    }

    @Override
    @Nonnull
    public NodeCollection getItems() {
        return this.items;
    }

    @Override
    @Nullable
    public ConfigNode lookup(String name) {
        return this.items.getByName(name);
    }

    @Override
    @Nullable
    public ConfigBranch lookupBranch(String name) {
        ConfigNode ret = this.lookup(name);
        if (ret instanceof ConfigBranch) {
            return (ConfigBranch)ret;
        }
        return null;
    }

    @Override
    @Nullable
    public <T> ConfigLeaf<T> lookupLeaf(String name, SerializableType<T> type) {
        ConfigNode ret = this.lookup(name);
        if (ret instanceof ConfigLeaf && type.isAssignableFrom(((ConfigLeaf)ret).getConfigType())) {
            return (ConfigLeaf)ret;
        }
        return null;
    }

    @Override
    public boolean lookupAndBind(String name, PropertyMirror<?> mirror) {
        ConfigLeaf leaf = this.lookupLeaf(name, (SerializableType)mirror.getMirroredType().getSerializedType());
        if (leaf != null) {
            mirror.mirror(leaf);
            return true;
        }
        return false;
    }

    public ConfigTreeBuilder withParent(ConfigTreeBuilder parent) {
        if (this.name == null && parent != null) {
            throw new IllegalStateException("A child node needs a name");
        }
        this.parent = parent;
        return this;
    }

    @Override
    public ConfigTreeBuilder withName(String name) {
        if (name == null && this.parent != null) {
            throw new IllegalStateException("Cannot remove the name from a child node");
        }
        this.name = name;
        return this;
    }

    @Override
    public ConfigTreeBuilder withComment(@Nullable String comment) {
        this.comment = comment;
        return this;
    }

    @Override
    public <A> ConfigTreeBuilder withAttribute(FiberId id, SerializableType<A> type, A defaultValue) {
        super.withAttribute(id, type, defaultValue);
        return this;
    }

    @Override
    public ConfigTreeBuilder withAttributes(Collection<ConfigAttribute<?>> attributes) {
        super.withAttributes(attributes);
        return this;
    }

    @Override
    public ConfigTreeBuilder withAttribute(ConfigAttribute<?> attribute) {
        super.withAttribute(attribute);
        return this;
    }

    public ConfigTreeBuilder withSeparateSerialization() {
        this.withSeparateSerialization(true);
        return this;
    }

    public ConfigTreeBuilder withSeparateSerialization(boolean serializeSeparately) {
        this.serializeSeparately = serializeSeparately;
        return this;
    }

    public ConfigTreeBuilder applyFromPojo(Object pojo) throws RuntimeFiberException {
        return this.applyFromPojo(pojo, AnnotatedSettings.DEFAULT_SETTINGS);
    }

    public ConfigTreeBuilder applyFromPojo(Object pojo, AnnotatedSettings settings) throws RuntimeFiberException {
        try {
            settings.applyToNode(this, pojo);
        }
        catch (FiberException e) {
            throw new RuntimeFiberException("Failed to apply POJO structure to builder", e);
        }
        return this;
    }

    public <T> ConfigLeafBuilder<T, T> beginValue(@Nonnull String name, @Nonnull SerializableType<T> type, @Nonnull T defaultValue) {
        return ConfigLeafBuilder.create(this, name, type, defaultValue);
    }

    public <T, R> ConfigLeafBuilder<T, R> beginValue(@Nonnull String name, @Nonnull ConfigType<R, T, ?> type, @Nonnull R defaultValue) {
        return ConfigLeafBuilder.create(this, name, type, defaultValue);
    }

    public <T> ConfigTreeBuilder withValue(@Nonnull String name, @Nonnull SerializableType<T> type, @Nonnull T defaultValue) {
        this.items.add(new ConfigLeafImpl<Object>(name, type, null, defaultValue, (a, b) -> {}));
        return this;
    }

    public <R, S> ConfigTreeBuilder withValue(@Nonnull String name, @Nonnull ConfigType<R, S, ?> type, @Nullable R defaultValue) {
        this.items.add(new ConfigLeafImpl<Object>(name, (SerializableType<Object>)type.getSerializedType(), null, type.toSerializedType(defaultValue), (a, b) -> {}));
        return this;
    }

    public <R> ConfigTreeBuilder withMirroredValue(@Nonnull String name, @Nonnull PropertyMirror<R> mirror, @Nonnull R defaultValue) {
        this.beginValue(name, mirror.getMirroredType(), defaultValue).finishValue(mirror::mirror);
        return this;
    }

    public ConfigTreeBuilder withChild(@Nonnull ConfigNode item) throws DuplicateChildException {
        this.items.add(item);
        return this;
    }

    public ConfigTreeBuilder withChild(@Nonnull ConfigNode item, boolean overwrite) throws DuplicateChildException {
        this.items.add(item, overwrite);
        return this;
    }

    public ConfigTreeBuilder fork(String name) {
        return new ConfigTreeBuilder(this, name);
    }

    @Override
    public ConfigBranch build() throws RuntimeFiberException {
        try {
            ConfigBranchImpl built = new ConfigBranchImpl(this.name, this.comment, this.items, this.serializeSeparately);
            built.getAttributes().putAll(this.attributes);
            if (this.parent != null) {
                assert (this.name != null);
                this.parent.getItems().add(built);
            }
            return built;
        }
        catch (IllegalTreeStateException e) {
            throw new RuntimeFiberException("Failed to build branch '" + this.name + "'", e);
        }
    }

    public ConfigTreeBuilder finishBranch() {
        return this.finishBranch(n -> {});
    }

    public ConfigTreeBuilder finishBranch(Consumer<ConfigBranch> action) {
        if (this.parent instanceof ConfigTreeBuilder) {
            action.accept(this.build());
            return (ConfigTreeBuilder)this.parent;
        }
        throw new IllegalStateException("finishNode should not be called for a root builder. Use build instead.");
    }
}

