/*
 * Decompiled with CFR 0.152.
 */
package io.github.fablabsmc.fablabs.api.fiber.v1.builder;

import io.github.fablabsmc.fablabs.api.fiber.v1.FiberId;
import io.github.fablabsmc.fablabs.api.fiber.v1.builder.ConfigTreeBuilder;
import io.github.fablabsmc.fablabs.api.fiber.v1.exception.RuntimeFiberException;
import io.github.fablabsmc.fablabs.api.fiber.v1.schema.type.SerializableType;
import io.github.fablabsmc.fablabs.api.fiber.v1.schema.type.derived.ConfigType;
import io.github.fablabsmc.fablabs.api.fiber.v1.tree.ConfigAttribute;
import io.github.fablabsmc.fablabs.api.fiber.v1.tree.ConfigLeaf;
import io.github.fablabsmc.fablabs.api.fiber.v1.tree.ConfigNode;
import io.github.fablabsmc.fablabs.impl.fiber.builder.ConfigNodeBuilder;
import io.github.fablabsmc.fablabs.impl.fiber.tree.ConfigLeafImpl;
import java.util.Collection;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nonnull;

public class ConfigLeafBuilder<T, R>
extends ConfigNodeBuilder {
    @Nonnull
    protected final SerializableType<T> type;
    protected final Function<T, R> deserializer;
    protected final Function<R, T> serializer;
    @Nonnull
    private T defaultValue;
    private BiConsumer<T, T> consumer = (t, t2) -> {};

    public static <T, R> ConfigLeafBuilder<T, R> create(ConfigTreeBuilder parentNode, @Nonnull String name, @Nonnull ConfigType<R, T, ?> type, @Nonnull R defaultValue) {
        return new ConfigLeafBuilder<Object, Object>(parentNode, name, (SerializableType<Object>)type.getSerializedType(), type.toSerializedType(defaultValue), type::toRuntimeType, type::toSerializedType);
    }

    public static <T> ConfigLeafBuilder<T, T> create(ConfigTreeBuilder parentNode, @Nonnull String name, @Nonnull SerializableType<T> type, @Nonnull T defaultValue) {
        return new ConfigLeafBuilder(parentNode, name, type, defaultValue, Function.identity(), Function.identity());
    }

    private ConfigLeafBuilder(ConfigTreeBuilder parentNode, @Nonnull String name, @Nonnull SerializableType<T> type, T defaultValue, Function<T, R> deserializer, Function<R, T> serializer) {
        super(parentNode, name);
        this.type = type;
        this.deserializer = deserializer;
        this.serializer = serializer;
        this.defaultValue = Objects.requireNonNull(defaultValue);
    }

    @Nonnull
    public SerializableType<T> getType() {
        return this.type;
    }

    @Override
    public ConfigLeafBuilder<T, R> withName(@Nonnull String name) {
        super.withName(name);
        return this;
    }

    @Override
    public ConfigLeafBuilder<T, R> withComment(String comment) {
        super.withComment(comment);
        return this;
    }

    @Override
    public <A> ConfigLeafBuilder<T, R> withAttribute(FiberId id, SerializableType<A> type, A defaultValue) {
        super.withAttribute(id, type, defaultValue);
        return this;
    }

    @Override
    public ConfigLeafBuilder<T, R> withAttributes(Collection<ConfigAttribute<?>> attributes) {
        super.withAttributes(attributes);
        return this;
    }

    @Override
    public ConfigLeafBuilder<T, R> withAttribute(ConfigAttribute<?> attribute) {
        super.withAttribute(attribute);
        return this;
    }

    public ConfigLeafBuilder<T, R> withListener(BiConsumer<R, R> consumer) {
        this.consumer = this.consumer.andThen((t, t2) -> consumer.accept(t == null ? null : (Object)this.deserializer.apply(t), t2 == null ? null : (Object)this.deserializer.apply(t2)));
        return this;
    }

    public ConfigLeafBuilder<T, R> withDefaultValue(R defaultValue) {
        this.defaultValue = this.serializer.apply(Objects.requireNonNull(defaultValue));
        return this;
    }

    @Override
    public ConfigLeaf<T> build() {
        if (!this.type.accepts(this.defaultValue)) {
            throw new RuntimeFiberException("Default value '" + this.defaultValue + "' does not satisfy constraints on type " + this.type);
        }
        ConfigLeafImpl<T> built = new ConfigLeafImpl<T>(Objects.requireNonNull(this.name, "Cannot build a value without a name"), this.type, this.comment, this.defaultValue, this.consumer);
        built.getAttributes().putAll(this.attributes);
        if (this.parent != null) {
            try {
                this.parent.getItems().add(built);
            }
            catch (RuntimeFiberException e) {
                throw new RuntimeFiberException("Failed to register leaf to node", e);
            }
        }
        return built;
    }

    public ConfigTreeBuilder finishValue() {
        return this.finishValue(n -> {});
    }

    public ConfigTreeBuilder finishValue(Consumer<ConfigLeaf<T>> action) {
        if (this.parent instanceof ConfigTreeBuilder) {
            action.accept((ConfigLeaf<ConfigNode>)this.build());
            return (ConfigTreeBuilder)this.parent;
        }
        throw new IllegalStateException("finishValue should not be called for an independent builder. Use build instead.");
    }
}

