/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.whisperwoods.imdlib.util.config;

import blue.endless.jankson.JsonObject;
import dev.itsmeow.whisperwoods.imdlib.util.SafePlatform;
import dev.itsmeow.whisperwoods.imdlib.util.config.CommonConfigAPI;
import dev.itsmeow.whisperwoods.imdlib.util.config.ConfigBuilder;
import dev.itsmeow.whisperwoods.imdlib.util.config.ConfigBuilderFabric;
import io.github.fablabsmc.fablabs.api.fiber.v1.exception.ValueDeserializationException;
import io.github.fablabsmc.fablabs.api.fiber.v1.serialization.FiberSerialization;
import io.github.fablabsmc.fablabs.api.fiber.v1.serialization.JanksonValueSerializer;
import io.github.fablabsmc.fablabs.api.fiber.v1.tree.ConfigBranch;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.function.Consumer;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_3528;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class FabricConfigContainer {
    protected static final Logger LOGGER = LogManager.getLogger();
    protected final JanksonValueSerializer janksonSerializer = new JanksonValueSerializer(false){

        @Override
        public void writeTarget(JsonObject target, OutputStream out) throws IOException {
            out.write(("// " + FabricConfigContainer.this.getConfigComment() + "\n" + target.toJson(true, true)).getBytes(StandardCharsets.UTF_8));
        }
    };
    private final CommonConfigAPI.ConfigType type;
    protected String name;
    protected final Consumer<ConfigBuilder> init;
    private ConfigBranch builtConfig;
    private boolean initialized = false;

    public FabricConfigContainer(CommonConfigAPI.ConfigType type, Consumer<ConfigBuilder> init) {
        this.type = type;
        this.name = SafePlatform.modId() + "-" + type.name().toLowerCase();
        this.init = init;
    }

    public String getConfigComment() {
        return "";
    }

    public void invalidate() {
        this.initialized = false;
    }

    public CommonConfigAPI.ConfigType getType() {
        return this.type;
    }

    public ConfigBranch getBranch() {
        if (this.builtConfig == null) {
            return this.init();
        }
        return this.builtConfig;
    }

    public String getConfigName() {
        return this.name;
    }

    protected abstract class_3528<ConfigBuilderFabric> getBuilder();

    protected ConfigBranch init() {
        if (!this.initialized) {
            this.initialized = true;
            this.init.accept((ConfigBuilder)this.getBuilder().method_15332());
            this.builtConfig = ((ConfigBuilderFabric)this.getBuilder().method_15332()).getBuilder().build();
        }
        return this.builtConfig;
    }

    public File getConfigFile(Path serverConfigPath) {
        Path configFolder;
        Path path = configFolder = serverConfigPath != null ? serverConfigPath : FabricLoader.getInstance().getConfigDir();
        if (serverConfigPath != null && !serverConfigPath.toFile().exists()) {
            serverConfigPath.toFile().mkdirs();
        }
        return new File(configFolder.toFile(), this.getConfigName() + ".json5");
    }

    public void createOrLoad(Path serverConfigPath) {
        this.setupConfigFile(this.getConfigFile(serverConfigPath), this.init(), this.janksonSerializer);
    }

    public void saveBranch(File configFile, ConfigBranch branch) {
        try {
            FiberSerialization.serialize(branch, Files.newOutputStream(configFile.toPath(), new OpenOption[0]), this.janksonSerializer);
            LOGGER.info("Successfully wrote menu edits to config file '{}'", (Object)configFile.toString());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void deserializeFromDefault(ConfigBranch configNode, JanksonValueSerializer serializer) throws IOException {
        File defaultConfig;
        File defaultFolder = FabricLoader.getInstance().getGameDir().resolve("defaultconfigs").toFile();
        if (!defaultFolder.exists()) {
            defaultFolder.mkdirs();
        }
        if ((defaultConfig = new File(defaultFolder, this.getConfigName() + ".json5")).exists()) {
            try {
                FiberSerialization.deserialize(configNode, Files.newInputStream(defaultConfig.toPath(), new OpenOption[0]), serializer);
            }
            catch (ValueDeserializationException e) {
                String fileName = this.getConfigName() + "-" + LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd_HH.mm.ss")) + ".json5";
                LOGGER.error("Found a syntax error in the *default* config!");
                if (defaultConfig.renameTo(new File(defaultConfig.getParent(), fileName))) {
                    LOGGER.info("*Default* config file successfully renamed to '{}'.", (Object)fileName);
                }
                e.printStackTrace();
            }
        }
    }

    private void setupConfigFile(File configFile, ConfigBranch configNode, JanksonValueSerializer serializer) {
        boolean recreate = false;
        try {
            while (true) {
                if (!configFile.exists() || recreate) {
                    this.deserializeFromDefault(configNode, serializer);
                    FiberSerialization.serialize(configNode, Files.newOutputStream(configFile.toPath(), new OpenOption[0]), serializer);
                    LOGGER.info("Successfully created the config file in '{}'", (Object)configFile.toString());
                    break;
                }
                try {
                    FiberSerialization.deserialize(configNode, Files.newInputStream(configFile.toPath(), new OpenOption[0]), serializer);
                    FiberSerialization.serialize(configNode, Files.newOutputStream(configFile.toPath(), new OpenOption[0]), serializer);
                    LOGGER.info("Successfully loaded '{}'", (Object)configFile.toString());
                }
                catch (ValueDeserializationException e) {
                    String fileName = this.getConfigName() + "-" + LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd_HH.mm.ss")) + ".json5";
                    LOGGER.error("Found a syntax error in the config!");
                    if (configFile.renameTo(new File(configFile.getParent(), fileName))) {
                        LOGGER.info("Config file successfully renamed to '{}'.", (Object)fileName);
                    }
                    recreate = true;
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

