/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.whisperwoods.imdlib.util.config;

import dev.itsmeow.whisperwoods.imdlib.util.config.CommonConfigAPI;
import dev.itsmeow.whisperwoods.imdlib.util.config.ConfigBuilder;
import io.github.fablabsmc.fablabs.api.fiber.v1.builder.ConfigLeafBuilder;
import io.github.fablabsmc.fablabs.api.fiber.v1.builder.ConfigTreeBuilder;
import io.github.fablabsmc.fablabs.api.fiber.v1.schema.type.SerializableType;
import io.github.fablabsmc.fablabs.api.fiber.v1.schema.type.derived.ConfigType;
import io.github.fablabsmc.fablabs.api.fiber.v1.schema.type.derived.ConfigTypes;
import io.github.fablabsmc.fablabs.api.fiber.v1.schema.type.derived.ListConfigType;
import io.github.fablabsmc.fablabs.api.fiber.v1.schema.type.derived.NumberConfigType;
import io.github.fablabsmc.fablabs.api.fiber.v1.tree.ConfigTree;
import io.github.fablabsmc.fablabs.api.fiber.v1.tree.PropertyMirror;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.server.MinecraftServer;

public class ConfigBuilderFabric
extends ConfigBuilder {
    private ConfigTreeBuilder builder = ConfigTree.builder();

    public ConfigBuilderFabric(String name, CommonConfigAPI.ConfigType type, Consumer<ConfigBuilder> init, Runnable onLoad) {
        super(type, init, onLoad);
        this.builder = this.builder.withName(name);
    }

    public ConfigBuilderFabric(String name, Consumer<ConfigBuilder> init, Consumer<MinecraftServer> onLoad) {
        super(init, onLoad);
        this.builder = this.builder.withName(name);
    }

    public ConfigTreeBuilder getBuilder() {
        return this.builder;
    }

    public static <T, A extends SerializableType<T>> ConfigType<T, T, A> typeLookup(T value) {
        if (Boolean.class.isInstance(value)) {
            return ConfigTypes.BOOLEAN;
        }
        if (Integer.class.isInstance(value)) {
            return ConfigTypes.INTEGER;
        }
        if (String.class.isInstance(value)) {
            return ConfigTypes.STRING;
        }
        if (Double.class.isInstance(value)) {
            return ConfigTypes.DOUBLE;
        }
        if (Float.class.isInstance(value)) {
            return ConfigTypes.FLOAT;
        }
        if (Long.class.isInstance(value)) {
            return ConfigTypes.LONG;
        }
        if (Byte.class.isInstance(value)) {
            return ConfigTypes.BYTE;
        }
        if (Character.class.isInstance(value)) {
            return ConfigTypes.CHARACTER;
        }
        if (Short.class.isInstance(value)) {
            return ConfigTypes.SHORT;
        }
        throw new RuntimeException("Define config for unknown type: " + value.getClass().getName());
    }

    @Override
    public <T> Supplier<T> define(String path, T defaultValue) {
        ConfigType type = ConfigBuilderFabric.typeLookup(defaultValue);
        PropertyMirror<T> mirror = PropertyMirror.create(type);
        this.builder = this.builder.beginValue(path, type, defaultValue).finishValue(mirror::mirror);
        return mirror::getValue;
    }

    @Override
    public Supplier<Double> defineInRange(String path, double defaultValue, double min, double max) {
        NumberConfigType<Double> type = ConfigTypes.DOUBLE.withMinimum(min).withMaximum(max);
        PropertyMirror mirror = PropertyMirror.create(type);
        this.builder = this.builder.beginValue(path, type, defaultValue).finishValue(mirror::mirror);
        return mirror::getValue;
    }

    @Override
    public Supplier<Integer> defineInRange(String path, int defaultValue, int min, int max) {
        NumberConfigType<Integer> type = ConfigTypes.INTEGER.withMinimum(min).withMaximum(max);
        PropertyMirror mirror = PropertyMirror.create(type);
        this.builder = this.builder.beginValue(path, type, defaultValue).finishValue(mirror::mirror);
        return mirror::getValue;
    }

    @Override
    public Supplier<Long> defineInRange(String path, long defaultValue, long min, long max) {
        NumberConfigType<Long> type = ConfigTypes.LONG.withMinimum(min).withMaximum(max);
        PropertyMirror mirror = PropertyMirror.create(type);
        this.builder = this.builder.beginValue(path, type, defaultValue).finishValue(mirror::mirror);
        return mirror::getValue;
    }

    @Override
    public <T> Supplier<List<? extends T>> defineList(String path, List<? extends T> defaultValue, T baseTypeValue, Predicate<Object> elementValidator) {
        ListConfigType<List<T>, T> type = ConfigTypes.makeList(ConfigBuilderFabric.typeLookup(baseTypeValue));
        PropertyMirror mirror = PropertyMirror.create(type);
        this.builder = this.builder.beginValue(path, type, defaultValue).finishValue(mirror::mirror);
        return mirror::getValue;
    }

    @Override
    public <T> Supplier<List<? extends T>> defineList(String path, Supplier<List<? extends T>> defaultSupplier, T baseTypeValue, Predicate<Object> elementValidator) {
        ListConfigType<List<T>, T> type = ConfigTypes.makeList(ConfigBuilderFabric.typeLookup(baseTypeValue));
        PropertyMirror mirror = PropertyMirror.create(type);
        this.builder = this.builder.beginValue(path, type, defaultSupplier.get()).finishValue(mirror::mirror);
        return mirror::getValue;
    }

    @Override
    public <T> Supplier<T> define(String path, String comment, T defaultValue) {
        ConfigType type = ConfigBuilderFabric.typeLookup(defaultValue);
        PropertyMirror<T> mirror = PropertyMirror.create(type);
        this.builder = ((ConfigLeafBuilder)this.builder.beginValue(path, type, defaultValue).withComment(comment)).finishValue(mirror::mirror);
        return mirror::getValue;
    }

    @Override
    public Supplier<Double> defineInRange(String path, String comment, double defaultValue, double min, double max) {
        NumberConfigType<Double> type = ConfigTypes.DOUBLE.withMinimum(min).withMaximum(max);
        PropertyMirror mirror = PropertyMirror.create(type);
        this.builder = ((ConfigLeafBuilder)this.builder.beginValue(path, type, defaultValue).withComment(comment)).finishValue(mirror::mirror);
        return mirror::getValue;
    }

    @Override
    public Supplier<Integer> defineInRange(String path, String comment, int defaultValue, int min, int max) {
        NumberConfigType<Integer> type = ConfigTypes.INTEGER.withMinimum(min).withMaximum(max);
        PropertyMirror mirror = PropertyMirror.create(type);
        this.builder = ((ConfigLeafBuilder)this.builder.beginValue(path, type, defaultValue).withComment(comment)).finishValue(mirror::mirror);
        return mirror::getValue;
    }

    @Override
    public Supplier<Long> defineInRange(String path, String comment, long defaultValue, long min, long max) {
        NumberConfigType<Long> type = ConfigTypes.LONG.withMinimum(min).withMaximum(max);
        PropertyMirror mirror = PropertyMirror.create(type);
        this.builder = ((ConfigLeafBuilder)this.builder.beginValue(path, type, defaultValue).withComment(comment)).finishValue(mirror::mirror);
        return mirror::getValue;
    }

    @Override
    public <T> Supplier<List<? extends T>> defineList(String path, String comment, List<? extends T> defaultValue, T baseTypeValue, Predicate<Object> elementValidator) {
        ListConfigType<List<T>, T> type = ConfigTypes.makeList(ConfigBuilderFabric.typeLookup(baseTypeValue));
        PropertyMirror mirror = PropertyMirror.create(type);
        this.builder = ((ConfigLeafBuilder)this.builder.beginValue(path, type, defaultValue).withComment(comment)).finishValue(mirror::mirror);
        return mirror::getValue;
    }

    @Override
    public <T> Supplier<List<? extends T>> defineList(String path, String comment, Supplier<List<? extends T>> defaultSupplier, T baseTypeValue, Predicate<Object> elementValidator) {
        ListConfigType<List<T>, T> type = ConfigTypes.makeList(ConfigBuilderFabric.typeLookup(baseTypeValue));
        PropertyMirror mirror = PropertyMirror.create(type);
        this.builder = ((ConfigLeafBuilder)this.builder.beginValue(path, type, defaultSupplier.get()).withComment(comment)).finishValue(mirror::mirror);
        return mirror::getValue;
    }

    @Override
    public void push(String path) {
        this.builder = this.builder.fork(path);
    }

    @Override
    public void pop() {
        this.builder = this.builder.finishBranch();
    }
}

