/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.whisperwoods.imdlib.util;

import dev.itsmeow.whisperwoods.imdlib.IMDLib;
import dev.itsmeow.whisperwoods.imdlib.entity.util.BiomeTypes;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_1959;
import net.minecraft.class_2378;
import net.minecraft.class_5321;
import net.minecraft.class_7924;

public class BiomeListBuilder {
    private final Set<class_5321<class_1959>> extras = new HashSet<class_5321<class_1959>>();
    private final Set<BiomeTypes.Type> list = new HashSet<BiomeTypes.Type>();
    private final Set<BiomeTypes.Type> blacklist = new HashSet<BiomeTypes.Type>();
    private final Set<class_5321<class_1959>> blacklistBiome = new HashSet<class_5321<class_1959>>();
    private final Set<BiomeTypes.Type> required = new HashSet<BiomeTypes.Type>();
    private boolean onlyOverworld = false;

    private BiomeListBuilder() {
    }

    public static BiomeListBuilder create() {
        return new BiomeListBuilder();
    }

    @SafeVarargs
    public final BiomeListBuilder extra(class_5321<class_1959> ... extraBiomes) {
        this.extras.addAll(Arrays.asList(extraBiomes));
        return this;
    }

    public BiomeListBuilder extra(BiomeTypes.Type ... types) {
        this.list.addAll(Arrays.asList(types));
        return this;
    }

    public BiomeListBuilder withoutTypes(BiomeTypes.Type ... types) {
        this.blacklist.addAll(Arrays.asList(types));
        return this;
    }

    public BiomeListBuilder withTypes(BiomeTypes.Type ... types) {
        this.required.addAll(Arrays.asList(types));
        return this;
    }

    @SafeVarargs
    public final BiomeListBuilder withoutBiomes(class_5321<class_1959> ... biomes) {
        this.blacklistBiome.addAll(Arrays.asList(biomes));
        return this;
    }

    public BiomeListBuilder onlyOverworld() {
        this.onlyOverworld = true;
        return this;
    }

    public class_5321<class_1959>[] collect() {
        HashSet<class_5321<class_1959>> set = new HashSet<class_5321<class_1959>>(this.extras);
        for (BiomeTypes.Type extraT : this.list) {
            set.addAll(BiomeTypes.getBiomes(extraT));
        }
        if (this.required.size() > 0 || this.blacklist.size() > 0) {
            class_2378 registry = null;
            try {
                registry = IMDLib.getStaticServerInstance().method_30611().method_30530(class_7924.field_41236);
            }
            catch (RuntimeException e) {
                return new class_5321[0];
            }
            for (class_1959 biome : registry) {
                Optional biomeKeyOpt = registry.method_29113((Object)biome);
                biomeKeyOpt.ifPresent(biomeKey -> {
                    Set<BiomeTypes.Type> types = BiomeTypes.getTypes((class_5321<class_1959>)biomeKey);
                    if (types.size() > 0) {
                        boolean pass = true;
                        for (BiomeTypes.Type type : this.required) {
                            if (types.contains(type)) continue;
                            pass = false;
                            break;
                        }
                        for (BiomeTypes.Type type : this.blacklist) {
                            if (!types.contains(type)) continue;
                            pass = false;
                            break;
                        }
                        if (this.blacklistBiome.contains(biomeKey)) {
                            pass = false;
                        }
                        if (this.onlyOverworld && !types.contains(BiomeTypes.OVERWORLD)) {
                            pass = false;
                        }
                        if (pass) {
                            set.add((class_5321<class_1959>)biomeKey);
                        }
                    }
                });
            }
        }
        return set.toArray(new class_5321[0]);
    }
}

