/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.whisperwoods.imdlib.entity.interfaces;

import dev.itsmeow.whisperwoods.imdlib.entity.interfaces.IContainerEntity;
import dev.itsmeow.whisperwoods.imdlib.entity.util.variant.IVariant;
import java.util.Optional;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1315;
import net.minecraft.class_1936;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3730;
import org.jetbrains.annotations.Nullable;

public interface IVariantTypes<T extends class_1308>
extends IContainerEntity<T> {
    default public void registerTypeKey() {
        this.getImplementation().method_5841().method_12784(this.getContainer().getVariantDataKey(), (Object)((IVariant)this.getContainer().getVariants().get(0)).getName());
    }

    default public String getVariantString() {
        return (String)this.getImplementation().method_5841().method_12789(this.getContainer().getVariantDataKey());
    }

    default public IVariantTypes<T> setType(String variantKey) {
        if (!this.getContainer().getVariantForName(variantKey).isPresent()) {
            variantKey = this.getRandomType().getName();
        }
        this.getImplementation().method_5841().method_12778(this.getContainer().getVariantDataKey(), (Object)variantKey);
        return this;
    }

    default public IVariantTypes<T> setType(IVariant variant) {
        this.getImplementation().method_5841().method_12778(this.getContainer().getVariantDataKey(), (Object)variant.getName());
        return this;
    }

    default public void writeType(class_2487 compound) {
        String variantKey = this.getVariantNameOrEmpty();
        if (variantKey.isEmpty()) {
            variantKey = this.getRandomType().getName();
        }
        compound.method_10582("VariantId", variantKey);
    }

    default public void readType(class_2487 compound) {
        this.setType(compound.method_10558("VariantId"));
    }

    default public IVariant getOffspringType(IVariantTypes<?> parent1, IVariantTypes<?> parent2) {
        if (parent1 == null || parent2 == null) {
            if (parent1 == null && parent2 != null) {
                return parent2.getVariant().orElseGet(this::getRandomType);
            }
            if (parent1 != null) {
                return parent1.getVariant().orElseGet(this::getRandomType);
            }
            return this.getRandomType();
        }
        return this.getImplementation().method_6051().method_43056() ? parent1.getVariant().orElseGet(() -> parent2.getVariant().orElseGet(this::getRandomType)) : parent2.getVariant().orElseGet(() -> parent1.getVariant().orElseGet(this::getRandomType));
    }

    default public IVariant getRandomType() {
        return (IVariant)this.getContainer().getVariants().get(this.getImplementation().method_6051().method_43048(this.getContainer().getVariantMax()));
    }

    @Nullable
    default public class_1315 initData(class_1936 world, class_3730 reason, class_1315 livingdata) {
        return this.dataFromVariant(this.getRandomType(), livingdata);
    }

    @Nullable
    default public class_1315 initAgeableData(class_1936 world, class_3730 reason, class_1315 livingdata) {
        return this.ageableDataFromVariant(this.getRandomType(), livingdata);
    }

    default public Optional<IVariant> getVariant() {
        return this.getContainer().getVariantForName(this.getVariantString());
    }

    @Nullable
    default public class_2960 getVariantTextureOrNull() {
        return this.getVariant().map(v -> v.getTexture((class_1297)this.getImplementation())).orElse(null);
    }

    default public String getVariantNameOrEmpty() {
        Optional<IVariant> variant = this.getVariant();
        return variant.isPresent() ? variant.get().getName() : "";
    }

    default public class_1315 ageableDataFromVariant(IVariant variant, class_1315 livingdata) {
        if (livingdata instanceof AgeableTypeData) {
            variant = ((AgeableTypeData)((Object)livingdata)).typeData;
        } else {
            livingdata = livingdata instanceof class_1296.class_4697 ? new AgeableTypeData((class_1296.class_4697)livingdata, variant) : new AgeableTypeData(variant);
        }
        this.setType(variant);
        return livingdata;
    }

    default public class_1315 dataFromVariant(IVariant variant, class_1315 livingdata) {
        if (livingdata instanceof TypeData) {
            variant = ((TypeData)livingdata).typeData;
        } else {
            livingdata = new TypeData(variant);
        }
        this.setType(variant);
        return livingdata;
    }

    public static class AgeableTypeData
    extends class_1296.class_4697 {
        public IVariant typeData;
        private int indexInGroup = 0;
        private boolean canBabySpawn = true;
        private float babySpawnProbability = 0.05f;

        public AgeableTypeData(IVariant type) {
            super(false);
            this.typeData = type;
        }

        public AgeableTypeData(class_1296.class_4697 data, IVariant type) {
            super(false);
            this.typeData = type;
            this.indexInGroup = data.method_22432();
            this.canBabySpawn = data.method_22436();
            this.babySpawnProbability = data.method_22437();
        }

        public int method_22432() {
            return this.indexInGroup;
        }

        public boolean method_22436() {
            return this.canBabySpawn;
        }

        public float method_22437() {
            return this.babySpawnProbability;
        }
    }

    public static class TypeData
    implements class_1315 {
        public IVariant typeData;

        public TypeData(IVariant type) {
            this.typeData = type;
        }
    }
}

