/*
 * Decompiled with CFR 0.152.
 */
package net.hyper_pigeon.eldritch_mobs.mixin;

import dev.onyxstudios.cca.api.v3.component.ComponentProvider;
import net.hyper_pigeon.eldritch_mobs.EldritchMobsMod;
import net.hyper_pigeon.eldritch_mobs.ability.callback.onAbilityUseCallback;
import net.hyper_pigeon.eldritch_mobs.ability.callback.onAttackCallback;
import net.hyper_pigeon.eldritch_mobs.ability.callback.onDamageToTargetCallback;
import net.hyper_pigeon.eldritch_mobs.ability.callback.onDamagedCallback;
import net.hyper_pigeon.eldritch_mobs.ability.callback.onDeathCallback;
import net.hyper_pigeon.eldritch_mobs.ability.callback.passiveApplyCallback;
import net.hyper_pigeon.eldritch_mobs.component.interfaces.ModifierComponent;
import net.hyper_pigeon.eldritch_mobs.rank.MobRank;
import net.hyper_pigeon.eldritch_mobs.register.EldritchMobsLootTables;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_173;
import net.minecraft.class_181;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_52;
import net.minecraft.class_60;
import net.minecraft.class_8567;
import net.minecraft.server.MinecraftServer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1309.class})
public abstract class LivingEntityMixin
extends class_1297
implements ComponentProvider {
    @Shadow
    public abstract boolean method_5643(class_1282 var1, float var2);

    @Shadow
    public abstract boolean method_6092(class_1293 var1);

    @Shadow
    public abstract boolean method_6059(class_1291 var1);

    @Shadow
    public abstract float method_6032();

    public LivingEntityMixin(class_1299<?> type, class_1937 world) {
        super(type, world);
    }

    private boolean notNormal(ComponentProvider componentProvider) {
        if (componentProvider instanceof class_1308) {
            return EldritchMobsMod.getRank(componentProvider) != MobRank.NONE && EldritchMobsMod.getRank(componentProvider) != MobRank.UNDECIDED;
        }
        return false;
    }

    @Inject(method={"onAttacking"}, at={@At(value="FIELD", target="net/minecraft/entity/LivingEntity.attacking : Lnet/minecraft/entity/LivingEntity;", opcode=181, ordinal=0, shift=At.Shift.AFTER)}, cancellable=true)
    private void applyOnAttackAbilities(class_1297 target, CallbackInfo ci) {
        class_1269 result;
        if (target instanceof class_1309 && this.method_5864() != class_1299.field_6097 && this.notNormal(this) && (result = ((onAttackCallback)onAttackCallback.ON_ATTACK.invoker()).onAttack((class_1309)this, (class_1309)target)) == class_1269.field_5814) {
            ci.cancel();
        }
    }

    @Inject(method={"damage"}, at={@At(value="TAIL")})
    private void applyOnDamageAbilities(class_1282 source, float amount, CallbackInfoReturnable<Boolean> cir) {
        if (this.method_5864() != class_1299.field_6097 && this.notNormal(this)) {
            class_1269 result = ((onDamagedCallback)onDamagedCallback.ON_DAMAGED.invoker()).onDamaged((class_1309)this, source, amount);
            if (EldritchMobsMod.ELDRITCH_MOBS_CONFIG.turnOnGlowingMobs && !this.method_6059(class_1294.field_5912)) {
                this.method_6092(new class_1293(class_1294.field_5912, 2400));
            }
            if (result == class_1269.field_5814) {
                cir.cancel();
            }
        }
    }

    @Inject(method={"damage"}, at={@At(value="TAIL")})
    private void applyOnDamageToTarget(class_1282 source, float amount, CallbackInfoReturnable<Boolean> cir) {
        class_1269 result;
        class_1297 attacker = source.method_5529();
        if (attacker instanceof class_1309 && !(attacker instanceof class_3222) && this.notNormal(attacker.asComponentProvider()) && (result = ((onDamageToTargetCallback)onDamageToTargetCallback.ON_DAMAGE_TO_TARGET.invoker()).onDamageToTarget((class_1309)attacker, (class_1309)this, source, amount)) == class_1269.field_5814) {
            cir.cancel();
        }
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")}, cancellable=true)
    private void applyPassiveAbilities(CallbackInfo ci) {
        class_1269 result;
        if (this.method_5864() != class_1299.field_6097 && this.notNormal(this) && (result = ((passiveApplyCallback)passiveApplyCallback.PASSIVE_APPLY.invoker()).passiveApply((class_1309)this)) == class_1269.field_5814) {
            ci.cancel();
        }
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")}, cancellable=true)
    private void useActiveAbilities(CallbackInfo ci) {
        class_1269 result;
        if (this.method_5864() != class_1299.field_6097 && this.notNormal(this) && (result = ((onAbilityUseCallback)onAbilityUseCallback.ON_ABILITY_USE.invoker()).onAbilityUse((class_1309)this)) == class_1269.field_5814) {
            ci.cancel();
        }
    }

    @Inject(method={"onDeath"}, at={@At(value="INVOKE_ASSIGN", target="net/minecraft/entity/damage/DamageSource.getAttacker ()Lnet/minecraft/entity/Entity;", opcode=182, ordinal=0, shift=At.Shift.BEFORE)}, cancellable=true)
    private void onDeathAbilities(class_1282 damageSource, CallbackInfo ci) {
        class_1269 result;
        if (this.method_5864() != class_1299.field_6097 && this.notNormal(this) && (result = ((onDeathCallback)onDeathCallback.ON_DEATH.invoker()).onDeath((class_1309)this, damageSource)) == class_1269.field_5814) {
            ci.cancel();
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"dropLoot"})
    protected void dropBonusLoot(class_1282 source, boolean causedByPlayer, CallbackInfo info) {
        MinecraftServer server;
        if (this.method_5864() != class_1299.field_6097 && this.notNormal(this) && (causedByPlayer || !EldritchMobsMod.ELDRITCH_MOBS_CONFIG.onlyDropLootIfKilledByPlayers) && !EldritchMobsMod.ELDRITCH_MOBS_CONFIG.disableLootDrops && (server = this.method_5770().method_8503()) != null) {
            class_60 lootManager = server.method_3857();
            class_8567.class_8568 builder = new class_8567.class_8568((class_3218)this.method_37908()).method_51874(class_181.field_1226, (Object)this).method_51874(class_181.field_24424, (Object)this.method_19538()).method_51874(class_181.field_1231, (Object)source).method_51877(class_181.field_1230, (Object)source.method_5529()).method_51877(class_181.field_1227, (Object)source.method_5526());
            class_8567 lootContextParameterSet = builder.method_51875(class_173.field_1173);
            switch (((ModifierComponent)EldritchMobsMod.ELDRITCH_MODIFIERS.get((Object)this)).getRank()) {
                case ELITE: {
                    class_52 lootTable = lootManager.getLootTable(EldritchMobsLootTables.ELITE_LOOT_ID);
                    lootTable.method_51882(lootContextParameterSet, arg_0 -> ((LivingEntityMixin)this).method_5775(arg_0));
                    break;
                }
                case ULTRA: {
                    class_52 lootTable = lootManager.getLootTable(EldritchMobsLootTables.ULTRA_LOOT_ID);
                    lootTable.method_51882(lootContextParameterSet, arg_0 -> ((LivingEntityMixin)this).method_5775(arg_0));
                    if (!EldritchMobsMod.ELDRITCH_MOBS_CONFIG.combinedLootDrop) break;
                    class_52 eliteLootTable = lootManager.getLootTable(EldritchMobsLootTables.ELITE_LOOT_ID);
                    eliteLootTable.method_51882(lootContextParameterSet, arg_0 -> ((LivingEntityMixin)this).method_5775(arg_0));
                    break;
                }
                case ELDRITCH: {
                    class_52 lootTable = lootManager.getLootTable(EldritchMobsLootTables.ELDRITCH_LOOT_ID);
                    lootTable.method_51882(lootContextParameterSet, arg_0 -> ((LivingEntityMixin)this).method_5775(arg_0));
                    if (!EldritchMobsMod.ELDRITCH_MOBS_CONFIG.combinedLootDrop) break;
                    class_52 eliteLootTable = lootManager.getLootTable(EldritchMobsLootTables.ELITE_LOOT_ID);
                    eliteLootTable.method_51882(lootContextParameterSet, arg_0 -> ((LivingEntityMixin)this).method_5775(arg_0));
                    class_52 ultraLootTable = lootManager.getLootTable(EldritchMobsLootTables.ULTRA_LOOT_ID);
                    ultraLootTable.method_51882(lootContextParameterSet, arg_0 -> ((LivingEntityMixin)this).method_5775(arg_0));
                    break;
                }
            }
        }
    }
}

