/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.tcdcommons.network;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import io.github.thecsdev.tcdcommons.TCDCommons;
import io.github.thecsdev.tcdcommons.api.badge.ServerPlayerBadgeHandler;
import io.github.thecsdev.tcdcommons.api.hooks.entity.EntityHooks;
import io.github.thecsdev.tcdcommons.api.network.CustomPayloadNetworkReceiver;
import io.github.thecsdev.tcdcommons.api.network.packet.TCustomPayload;
import io.github.thecsdev.tcdcommons.api.util.collections.GenericProperties;
import io.github.thecsdev.tcdcommons.api.util.thread.TaskScheduler;
import io.github.thecsdev.tcdcommons.mixin.hooks.AccessorCustomPayloadNetwork;
import io.github.thecsdev.tcdcommons.network.TCDCommonsNetwork;
import io.netty.buffer.ByteBuf;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import net.minecraft.class_1297;
import net.minecraft.class_2540;
import net.minecraft.class_2547;
import net.minecraft.class_2596;
import net.minecraft.class_2598;
import net.minecraft.class_2658;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class TcdcServerPlayNetworkHandler {
    private static final class_2960 CUSTOM_DATA_ID = new class_2960(TCDCommons.getModID(), "server_play_network_handler");
    private final class_3222 player;
    private long nextS2CFracturedCpnPacketId = 0L;
    private final Cache<Long, TCustomPayload> fracturedC2SCpnPackets;

    private TcdcServerPlayNetworkHandler(class_3222 player) throws NullPointerException {
        this.player = Objects.requireNonNull(player);
        this.fracturedC2SCpnPackets = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.MINUTES).build();
        TaskScheduler.schedulePeriodicCacheCleanup(this.fracturedC2SCpnPackets);
    }

    public final class_3222 getPlayer() {
        return this.player;
    }

    public final long nextS2CFracturedCpnPacketId() {
        this.nextS2CFracturedCpnPacketId = Math.max(this.nextS2CFracturedCpnPacketId + 1L, 1L);
        return this.nextS2CFracturedCpnPacketId;
    }

    public final void onCustomPayloadNetwork(TCustomPayload payload) {
        final class_2960 packetId = payload.getPacketId();
        final class_2540 packetData = new class_2540(payload.getPacketPayload());
        CustomPayloadNetworkReceiver handler = AccessorCustomPayloadNetwork.getPlayC2S().getOrDefault(packetId, null);
        if (handler == null) {
            return;
        }
        handler.receiveCustomPayload(new CustomPayloadNetworkReceiver.PacketContext(){

            public class_3222 getPlayer() {
                return TcdcServerPlayNetworkHandler.this.player;
            }

            @Override
            public class_2547 getPacketListener() {
                return TcdcServerPlayNetworkHandler.this.player.field_13987;
            }

            @Override
            public class_2598 getNetworkSide() {
                return class_2598.field_11941;
            }

            @Override
            public class_2960 getPacketId() {
                return packetId;
            }

            @Override
            public class_2540 getPacketBuffer() {
                return packetData;
            }
        });
    }

    public final void onFracturedCustomPayloadNetwork(CustomPayloadNetworkReceiver.PacketContext context) {
        TCDCommonsNetwork.handleFracturedCpnPacket(context, this.fracturedC2SCpnPackets, this::onCustomPayloadNetwork);
    }

    public final void sendCustomPayloadNetwork(class_2960 packetId, ByteBuf packetData) throws IllegalStateException, NullPointerException {
        Objects.requireNonNull(packetId);
        Objects.requireNonNull(packetData);
        if (packetData.refCnt() < 1) {
            throw new IllegalStateException("REF_CNT");
        }
        TCustomPayload payload = new TCustomPayload(packetId, packetData);
        if (packetData.readableBytes() > 5120) {
            TCDCommonsNetwork.sendFracturedCpnPacket(payload, this.nextS2CFracturedCpnPacketId(), fp -> this.player.field_13987.method_14364((class_2596)new class_2658(fp.getPacketId(), new class_2540(fp.getPacketPayload()))));
            return;
        }
        this.player.field_13987.method_14364((class_2596)new class_2658(packetId, new class_2540(packetData)));
    }

    public final boolean sendPlayerBadges() {
        return ServerPlayerBadgeHandler.getServerBadgeHandler(this.player).sendStats(this.player);
    }

    public static final TcdcServerPlayNetworkHandler of(class_3222 player) throws NullPointerException {
        GenericProperties<class_2960> cd = EntityHooks.getCustomData((class_1297)Objects.requireNonNull(player));
        @Nullable TcdcServerPlayNetworkHandler spnh = (TcdcServerPlayNetworkHandler)cd.getProperty(CUSTOM_DATA_ID);
        if (spnh == null) {
            spnh = new TcdcServerPlayNetworkHandler(player);
            cd.setProperty(CUSTOM_DATA_ID, spnh);
        }
        return spnh;
    }
}

