/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.tcdcommons.network;

import com.google.common.cache.Cache;
import io.github.thecsdev.tcdcommons.TCDCommons;
import io.github.thecsdev.tcdcommons.api.network.CustomPayloadNetwork;
import io.github.thecsdev.tcdcommons.api.network.CustomPayloadNetworkReceiver;
import io.github.thecsdev.tcdcommons.api.network.packet.TCustomPayload;
import io.github.thecsdev.tcdcommons.client.network.TcdcClientPlayNetworkHandler;
import io.github.thecsdev.tcdcommons.network.TcdcServerPlayNetworkHandler;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.class_2540;
import net.minecraft.class_2598;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_746;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class TCDCommonsNetwork {
    public static final int COMMON_MAX_CUSTOM_PAYLOAD_SIZE = 5120;
    public static final class_2960 S2C_PLAYER_BADGES = new class_2960(TCDCommons.getModID(), "player_badges");
    public static final class_2960 S2C2C_FCPNP = new class_2960(TCDCommons.getModID(), "f");

    private TCDCommonsNetwork() {
    }

    public static final void init() {
    }

    @ApiStatus.Internal
    public static final void sendFracturedCpnPacket(TCustomPayload fullPacket, long fracturedPacketId, Consumer<TCustomPayload> packetSender) {
        Objects.requireNonNull(fullPacket);
        Objects.requireNonNull(packetSender);
        if (fracturedPacketId < 1L) {
            throw new IllegalArgumentException("Fractured packet ID is < 1");
        }
        ByteBuf fullPacketPayload = fullPacket.getPacketPayload();
        class_2540 b = new class_2540(Unpooled.buffer());
        b.writeByte(1);
        b.writeLongLE(fracturedPacketId);
        b.method_10814(fullPacket.getPacketId().toString());
        try {
            packetSender.accept(new TCustomPayload(S2C2C_FCPNP, (ByteBuf)b));
        }
        catch (Exception exc) {
            return;
        }
        while (fullPacketPayload.readableBytes() > 0) {
            int chunkDataLen = Math.min(fullPacketPayload.readableBytes(), 5120);
            ByteBuf chunkData = fullPacketPayload.readSlice(chunkDataLen);
            class_2540 b2 = new class_2540(Unpooled.buffer());
            b2.writeByte(2);
            b2.writeLongLE(fracturedPacketId);
            b2.writeIntLE(chunkDataLen);
            b2.writeBytes(chunkData);
            try {
                packetSender.accept(new TCustomPayload(S2C2C_FCPNP, (ByteBuf)b2));
            }
            catch (Exception exc) {
                return;
            }
        }
        b = new class_2540(Unpooled.buffer());
        b.writeByte(3);
        b.writeLongLE(fracturedPacketId);
        try {
            packetSender.accept(new TCustomPayload(S2C2C_FCPNP, (ByteBuf)b));
        }
        catch (Exception exc) {
            return;
        }
    }

    @ApiStatus.Internal
    public static final void handleFracturedCpnPacket(CustomPayloadNetworkReceiver.PacketContext context, Cache<Long, TCustomPayload> storage, Consumer<TCustomPayload> handler) {
        class_2540 buffer = context.getPacketBuffer();
        switch (buffer.readByte()) {
            case 1: {
                long id = buffer.readLongLE();
                String cpnPid = buffer.method_19772();
                try {
                    TCustomPayload cpnp = new TCustomPayload(new class_2960(cpnPid), (ByteBuf)new class_2540(Unpooled.buffer()));
                    storage.put((Object)id, (Object)cpnp);
                }
                catch (Exception cpnp) {}
                break;
            }
            case 2: {
                long id = buffer.readLongLE();
                int dataLen = buffer.readIntLE();
                ByteBuf data = buffer.readSlice(dataLen);
                TCustomPayload cpnp = (TCustomPayload)storage.getIfPresent((Object)id);
                if (cpnp == null) break;
                cpnp.getPacketPayload().writeBytes(data);
                break;
            }
            case 3: {
                long id = buffer.readLongLE();
                TCustomPayload cpnp = (TCustomPayload)storage.getIfPresent((Object)id);
                if (cpnp == null) break;
                storage.invalidate((Object)id);
                handler.accept(cpnp);
                break;
            }
        }
    }

    static {
        CustomPayloadNetwork.registerPlayReceiver(class_2598.field_11941, S2C2C_FCPNP, context -> TcdcServerPlayNetworkHandler.of((class_3222)context.getPlayer()).onFracturedCustomPayloadNetwork(context));
        if (TCDCommons.isClient()) {
            CustomPayloadNetwork.registerPlayReceiver(class_2598.field_11942, S2C2C_FCPNP, context -> TcdcClientPlayNetworkHandler.of((class_746)context.getPlayer()).onFracturedCustomPayloadNetwork(context));
            CustomPayloadNetwork.registerPlayReceiver(class_2598.field_11942, S2C_PLAYER_BADGES, context -> TcdcClientPlayNetworkHandler.of((class_746)context.getPlayer()).onPlayerBadges(context));
        }
    }
}

