/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.tcdcommons.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import io.github.thecsdev.tcdcommons.TCDCommons;
import io.github.thecsdev.tcdcommons.TCDCommonsConfig;
import io.github.thecsdev.tcdcommons.api.badge.ServerPlayerBadgeHandler;
import io.github.thecsdev.tcdcommons.api.client.badge.ClientPlayerBadge;
import io.github.thecsdev.tcdcommons.api.registry.TRegistries;
import io.github.thecsdev.tcdcommons.api.util.TextUtils;
import io.github.thecsdev.tcdcommons.util.TCDCT;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.StreamSupport;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2186;
import net.minecraft.class_2232;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import org.jetbrains.annotations.ApiStatus;

public final class PlayerBadgeCommand {
    public static final String TEXT_EDIT_OUTPUT = "commands.badges.edit.output";
    public static final String TEXT_CLEAR_OUTPUT = "commands.badges.clear.output";
    public static final String TEXT_QUERY_OUTPUT = "commands.badges.query.output";
    private static SuggestionProvider<class_2168> SUGGEST_PB = (context, builder) -> class_2172.method_9264(StreamSupport.stream(TRegistries.PLAYER_BADGE.spliterator(), false).filter(entry -> !(entry.getValue() instanceof ClientPlayerBadge)).map(entry -> Objects.toString(entry.getKey())), (SuggestionsBuilder)builder);

    private PlayerBadgeCommand() {
    }

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        TCDCommonsConfig config = TCDCommons.getInstance().getConfig();
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)class_2170.method_9247((String)"badges").requires(scs -> config.enablePlayerBadges && scs.method_9259(2));
        command.then(PlayerBadgeCommand.badges_edit());
        command.then(PlayerBadgeCommand.badges_clear());
        command.then(PlayerBadgeCommand.badges_query());
        dispatcher.register(command);
    }

    private static ArgumentBuilder<class_2168, ?> badges_edit() {
        return class_2170.method_9247((String)"edit").then(class_2170.method_9244((String)"targets", (ArgumentType)class_2186.method_9308()).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"badge", (ArgumentType)class_2232.method_9441()).suggests(SUGGEST_PB).then(class_2170.method_9247((String)"set").then(class_2170.method_9244((String)"value", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(ctx -> PlayerBadgeCommand.execute_edit((CommandContext<class_2168>)ctx, true))))).then(class_2170.method_9247((String)"increase").then(class_2170.method_9244((String)"value", (ArgumentType)IntegerArgumentType.integer()).executes(ctx -> PlayerBadgeCommand.execute_edit((CommandContext<class_2168>)ctx, false))))));
    }

    private static ArgumentBuilder<class_2168, ?> badges_clear() {
        return class_2170.method_9247((String)"clear").then(class_2170.method_9244((String)"targets", (ArgumentType)class_2186.method_9308()).executes(ctx -> PlayerBadgeCommand.execute_clear((CommandContext<class_2168>)ctx)));
    }

    private static ArgumentBuilder<class_2168, ?> badges_query() {
        return class_2170.method_9247((String)"query").then(class_2170.method_9244((String)"target", (ArgumentType)class_2186.method_9305()).then(class_2170.method_9244((String)"badge", (ArgumentType)class_2232.method_9441()).suggests(SUGGEST_PB).executes(ctx -> PlayerBadgeCommand.execute_query((CommandContext<class_2168>)ctx))));
    }

    private static int execute_edit(CommandContext<class_2168> context, boolean setOrIncrease) {
        try {
            Collection arg_targets = class_2186.method_9312(context, (String)"targets");
            class_2960 arg_badge = class_2232.method_9443(context, (String)"badge");
            int arg_value = IntegerArgumentType.getInteger(context, (String)"value");
            AtomicInteger affected = new AtomicInteger();
            for (class_3222 target : arg_targets) {
                if (target == null) continue;
                ServerPlayerBadgeHandler statHandler = ServerPlayerBadgeHandler.getServerBadgeHandler(target);
                if (setOrIncrease) {
                    statHandler.setValue(arg_badge, arg_value);
                } else {
                    statHandler.increaseValue(arg_badge, arg_value);
                }
                affected.incrementAndGet();
                statHandler.sendStats(target);
            }
            ((class_2168)context.getSource()).method_9226(() -> TCDCT.cmd_pb_edit_out((class_2561)TextUtils.literal(Objects.toString(arg_badge)), (class_2561)TextUtils.literal(Integer.toString(affected.get()))), false);
            return affected.get();
        }
        catch (CommandSyntaxException | IllegalStateException | NullPointerException e) {
            PlayerBadgeCommand.handleError(context, e);
            return -1;
        }
    }

    private static int execute_clear(CommandContext<class_2168> context) {
        try {
            Collection targets = class_2186.method_9312(context, (String)"targets");
            AtomicInteger affected = new AtomicInteger();
            for (class_3222 target : targets) {
                if (target == null) continue;
                ServerPlayerBadgeHandler.getServerBadgeHandler(target).clearBadges();
                affected.incrementAndGet();
            }
            ((class_2168)context.getSource()).method_9226(() -> TCDCT.cmd_pb_clear_out((class_2561)TextUtils.literal(Integer.toString(affected.get()))), false);
            return affected.get();
        }
        catch (CommandSyntaxException e) {
            PlayerBadgeCommand.handleError(context, e);
            return -1;
        }
    }

    private static int execute_query(CommandContext<class_2168> context) {
        try {
            class_3222 arg_target = class_2186.method_9315(context, (String)"target");
            class_2960 arg_badge = class_2232.method_9443(context, (String)"badge");
            ServerPlayerBadgeHandler spbh = ServerPlayerBadgeHandler.getServerBadgeHandler(arg_target);
            int value = spbh.getValue(arg_badge);
            ((class_2168)context.getSource()).method_9226(() -> TCDCT.cmd_pb_query_out(arg_target.method_5476(), (class_2561)TextUtils.literal(Objects.toString(arg_badge)), (class_2561)TextUtils.literal(Integer.toString(value))), false);
            return value;
        }
        catch (CommandSyntaxException e) {
            PlayerBadgeCommand.handleError(context, e);
            return -1;
        }
    }

    @ApiStatus.Internal
    public static void handleError(CommandContext<class_2168> context, Throwable e) {
        if (e instanceof Error) {
            throw new Error("Unable to handle errors.", e);
        }
        ((class_2168)context.getSource()).method_9213((class_2561)TextUtils.translatable("command.failed", new Object[0]).method_27693(":\n    " + e.getMessage()));
    }
}

