/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.tcdcommons.api.util.io.repo.github.ugc;

import com.google.gson.JsonIOException;
import com.google.gson.JsonObject;
import io.github.thecsdev.tcdcommons.api.util.io.repo.github.GitHubHostInfo;
import io.github.thecsdev.tcdcommons.api.util.io.repo.ugc.RepositoryInfo;
import java.math.BigInteger;
import java.time.Instant;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

@Deprecated(since="v3.12", forRemoval=true)
public final class GitHubRepositoryInfo
extends RepositoryInfo {
    private final String owner_id;
    private final String owner_login;
    private final Instant created_at;
    private final Instant updated_at;
    private final String id;
    private final String name;
    private final String full_name;
    @Nullable
    private final String description;
    private final BigInteger open_issues_count;
    private final BigInteger forks;
    private final BigInteger stargazers_count;

    public GitHubRepositoryInfo(JsonObject repoData) throws NullPointerException, JsonIOException {
        Objects.requireNonNull(repoData);
        try {
            JsonObject owner = Objects.requireNonNull(repoData.get("owner").getAsJsonObject());
            this.owner_id = owner.get("id").getAsBigInteger().toString();
            this.owner_login = Objects.requireNonNull(owner.get("login").getAsString());
            this.created_at = Instant.parse(repoData.get("created_at").getAsString());
            this.updated_at = Instant.parse(repoData.get("updated_at").getAsString());
            this.id = repoData.get("id").getAsBigInteger().toString();
            this.name = Objects.requireNonNull(repoData.get("name").getAsString());
            this.full_name = Objects.requireNonNull(repoData.get("full_name").getAsString());
            this.description = repoData.has("description") && !repoData.get("description").isJsonNull() ? Objects.requireNonNull(repoData.get("description").getAsString()) : null;
            this.open_issues_count = repoData.get("open_issues_count").getAsBigInteger();
            this.forks = repoData.get("forks").getAsBigInteger();
            this.stargazers_count = repoData.get("stargazers_count").getAsBigInteger();
        }
        catch (Exception exc) {
            throw new JsonIOException("Failed to read JSON repository data.", (Throwable)exc);
        }
    }

    @Override
    public final String getAuthorUserID() {
        return this.owner_id;
    }

    public final String getAuthorAccountName() {
        return this.owner_login;
    }

    @Override
    public final Instant getCreatedTime() {
        return this.created_at;
    }

    @Override
    public final Instant getLastEditedTime() {
        return this.updated_at;
    }

    @Override
    public final GitHubHostInfo getHost() {
        return GitHubHostInfo.getInstance();
    }

    @Override
    public final String getID() {
        return this.id;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    public final String getFullName() {
        return this.full_name;
    }

    @Override
    @Nullable
    public final String getDescription() {
        return this.description;
    }

    @Override
    public final BigInteger getOpenIssuesCount() {
        return this.open_issues_count;
    }

    @Override
    public final BigInteger getForkCount() {
        return this.forks;
    }

    @Override
    public final BigInteger getLikeCount() {
        return this.stargazers_count;
    }
}

