/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.tcdcommons.api.event;

import io.github.thecsdev.tcdcommons.api.event.TEvent;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.Objects;

final class TWeakEventImpl<T>
implements TEvent<T> {
    private final List<WeakReference<T>> listeners;
    private final T invoker;

    public TWeakEventImpl(List<WeakReference<T>> listeners, T invoker) {
        this.listeners = Objects.requireNonNull(listeners);
        this.invoker = Objects.requireNonNull(invoker);
    }

    @Override
    public boolean register(T listener) {
        if (listener == null || this.isRegistered(listener)) {
            return false;
        }
        return this.listeners.add(new WeakReference<T>(listener));
    }

    @Override
    public boolean unregister(T listener) {
        return this.listeners.removeIf(wr -> wr.refersTo(listener));
    }

    @Override
    public boolean isRegistered(T listener) {
        for (WeakReference<T> wr : this.listeners) {
            if (!wr.refersTo(listener)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void clearListeners() {
        this.listeners.clear();
    }

    @Override
    public T invoker() {
        return this.invoker;
    }
}

