/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.tcdcommons.api.event;

import io.github.thecsdev.tcdcommons.api.event.TEvent;
import io.github.thecsdev.tcdcommons.api.event.TEventImpl;
import io.github.thecsdev.tcdcommons.api.event.TEventResult;
import io.github.thecsdev.tcdcommons.api.event.TKeyedEvent;
import io.github.thecsdev.tcdcommons.api.event.TKeyedEventImpl;
import io.github.thecsdev.tcdcommons.api.event.TWeakEventImpl;
import io.github.thecsdev.tcdcommons.api.util.collections.IdealList;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.ApiStatus;

public final class TEventFactory {
    private TEventFactory() {
    }

    @SafeVarargs
    public static <T> TEvent<T> createLoop(T ... eventTypeClassGetter) {
        Objects.requireNonNull(eventTypeClassGetter);
        List listeners = Collections.synchronizedList(new IdealList());
        Object invoker = Proxy.newProxyInstance(TEventFactory.class.getClassLoader(), new Class[]{eventTypeClassGetter.getClass().getComponentType()}, (proxy, method, args) -> {
            try {
                for (Object listener : listeners) {
                    method.invoke(listener, args);
                }
                return null;
            }
            catch (Exception listenerException) {
                throw new RuntimeException("Failed to invoke event hanlder.", listenerException);
            }
        });
        return new TEventImpl<Object>(listeners, invoker);
    }

    @SafeVarargs
    public static <T> TEvent<T> createEventResult(T ... eventTypeClassGetter) {
        Objects.requireNonNull(eventTypeClassGetter);
        List listeners = Collections.synchronizedList(new IdealList());
        Object invoker = Proxy.newProxyInstance(TEventFactory.class.getClassLoader(), new Class[]{eventTypeClassGetter.getClass().getComponentType()}, (proxy, method, args) -> {
            try {
                TEventResult result = TEventResult.CANCEL_NONE;
                for (Object listener : listeners) {
                    Object listenerResult = method.invoke(listener, args);
                    try {
                        result = result.combine((TEventResult)((Object)((Object)listenerResult)));
                    }
                    catch (ClassCastException cce) {
                        TEventFactory.__handleEventResultCCE(cce, method, listenerResult);
                    }
                    if (!result.isPropagationCancelled()) continue;
                    break;
                }
                return result;
            }
            catch (Exception listenerException) {
                throw new RuntimeException("Failed to invoke event hanlder.", listenerException);
            }
        });
        return new TEventImpl<Object>(listeners, invoker);
    }

    @SafeVarargs
    public static <T> TEvent<T> createWeakLoop(T ... eventTypeClassGetter) {
        Objects.requireNonNull(eventTypeClassGetter);
        List listeners = Collections.synchronizedList(new IdealList());
        Object invoker = Proxy.newProxyInstance(TEventFactory.class.getClassLoader(), new Class[]{eventTypeClassGetter.getClass().getComponentType()}, (proxy, method, args) -> {
            try {
                ListIterator iter = listeners.listIterator();
                while (iter.hasNext()) {
                    WeakReference listenerRef = (WeakReference)iter.next();
                    Object listener = listenerRef.get();
                    if (method == null) {
                        iter.remove();
                        continue;
                    }
                    method.invoke(listener, args);
                }
                return null;
            }
            catch (Exception listenerException) {
                throw new RuntimeException("Failed to invoke event hanlder.", listenerException);
            }
        });
        return new TWeakEventImpl<Object>(listeners, invoker);
    }

    @SafeVarargs
    public static <T> TEvent<T> createWeakEventResult(T ... eventTypeClassGetter) {
        Objects.requireNonNull(eventTypeClassGetter);
        List listeners = Collections.synchronizedList(new IdealList());
        Object invoker = Proxy.newProxyInstance(TEventFactory.class.getClassLoader(), new Class[]{eventTypeClassGetter.getClass().getComponentType()}, (proxy, method, args) -> {
            try {
                TEventResult result = TEventResult.CANCEL_NONE;
                ListIterator iter = listeners.listIterator();
                while (iter.hasNext()) {
                    WeakReference listenerRef = (WeakReference)iter.next();
                    Object listener = listenerRef.get();
                    if (method == null) {
                        iter.remove();
                        continue;
                    }
                    Object listenerResult = method.invoke(listener, args);
                    try {
                        result = result.combine((TEventResult)((Object)((Object)listenerResult)));
                    }
                    catch (ClassCastException cce) {
                        TEventFactory.__handleEventResultCCE(cce, method, listenerResult);
                    }
                    if (!result.isPropagationCancelled()) continue;
                    break;
                }
                return result;
            }
            catch (Exception listenerException) {
                throw new RuntimeException("Failed to invoke event hanlder.", listenerException);
            }
        });
        return new TWeakEventImpl<Object>(listeners, invoker);
    }

    @SafeVarargs
    public static <T> TKeyedEvent<T> createKeyedLoop(T ... eventTypeClassGetter) {
        Objects.requireNonNull(eventTypeClassGetter);
        LinkedHashMap listeners = new LinkedHashMap();
        Object invoker = Proxy.newProxyInstance(TEventFactory.class.getClassLoader(), new Class[]{eventTypeClassGetter.getClass().getComponentType()}, (proxy, method, args) -> {
            try {
                for (Object listener : listeners.values()) {
                    method.invoke(listener, args);
                }
                return null;
            }
            catch (Exception listenerException) {
                throw new RuntimeException("Failed to invoke event hanlder.", listenerException);
            }
        });
        return new TKeyedEventImpl<Object>(listeners, invoker);
    }

    @SafeVarargs
    public static <T> TKeyedEvent<T> createKeyedEventResult(T ... eventTypeClassGetter) {
        Objects.requireNonNull(eventTypeClassGetter);
        LinkedHashMap listeners = new LinkedHashMap();
        Object invoker = Proxy.newProxyInstance(TEventFactory.class.getClassLoader(), new Class[]{eventTypeClassGetter.getClass().getComponentType()}, (proxy, method, args) -> {
            try {
                TEventResult result = TEventResult.CANCEL_NONE;
                for (Object listener : listeners.values()) {
                    Object listenerResult = method.invoke(listener, args);
                    try {
                        result = result.combine((TEventResult)((Object)((Object)listenerResult)));
                    }
                    catch (ClassCastException cce) {
                        TEventFactory.__handleEventResultCCE(cce, method, listenerResult);
                    }
                    if (!result.isPropagationCancelled()) continue;
                    break;
                }
                return result;
            }
            catch (Exception listenerException) {
                throw new RuntimeException("Failed to invoke event hanlder.", listenerException);
            }
        });
        return new TKeyedEventImpl<Object>(listeners, invoker);
    }

    @ApiStatus.Internal
    private static void __handleEventResultCCE(ClassCastException cce, Method listenerMethod, Object listenerResult) {
        String lrTypeName = Optional.ofNullable(listenerResult).map(o -> o.getClass().getName()).orElse(listenerMethod.getReturnType().equals(Void.TYPE) ? "void" : "null");
        String msg = "Failed to handle an event handler; Expected '" + TEventResult.class.getName() + "', got '" + lrTypeName + "'.";
        throw new RuntimeException(msg, cce);
    }
}

