/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.tcdcommons.api.client.gui.util.input;

import io.github.thecsdev.tcdcommons.api.client.gui.TElement;
import io.github.thecsdev.tcdcommons.api.client.gui.TParentElement;
import java.awt.geom.Point2D;

public abstract class MouseDragHelper {
    protected double mouseDragX;
    protected double mouseDragY;

    public final boolean onMouseDrag(Point2D mouseDelta) {
        return this.onMouseDrag(mouseDelta.getX(), mouseDelta.getY());
    }

    public final boolean onMouseDrag(double deltaX, double deltaY) {
        this.mouseDragX += deltaX;
        this.mouseDragY += deltaY;
        int sdX = (int)this.mouseDragX;
        int sdY = (int)this.mouseDragY;
        if (sdX == 0 && sdY == 0) {
            return true;
        }
        this.mouseDragX -= (double)sdX;
        this.mouseDragY -= (double)sdY;
        this.apply(sdX, sdY);
        return true;
    }

    public final void clear() {
        this.mouseDragX = 0.0;
        this.mouseDragY = 0.0;
    }

    protected abstract void apply(int var1, int var2);

    public static final MouseDragHelper forTElement(final TElement element) {
        return new MouseDragHelper(){

            @Override
            protected final void apply(int deltaX, int deltaY) {
                element.move(deltaX, deltaY);
            }
        };
    }

    public static boolean snapToParentBounds(TElement element) throws NullPointerException {
        TParentElement parent = element.getParent();
        if (parent == null) {
            return false;
        }
        int ptX = parent.getX();
        int ptY = parent.getY();
        int pbX = parent.getEndX();
        int pbY = parent.getEndY();
        int ctX = element.getX();
        int ctY = element.getY();
        int cbX = element.getEndX();
        int cbY = element.getEndY();
        int oX = 0;
        int oY = 0;
        if (ctX < ptX) {
            oX = ptX - ctX;
        } else if (cbX > pbX) {
            oX = pbX - cbX;
        }
        if (ctY < ptY) {
            oY = ptY - ctY;
        } else if (cbY > pbY) {
            oY = pbY - cbY;
        }
        if (oX != 0 || oY != 0) {
            element.move(oX, oY);
            return true;
        }
        return false;
    }
}

