/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.tcdcommons.api.client.gui.panel;

import com.google.common.annotations.Beta;
import io.github.thecsdev.tcdcommons.api.client.gui.TElement;
import io.github.thecsdev.tcdcommons.api.client.gui.util.TDrawContext;
import io.github.thecsdev.tcdcommons.api.client.gui.util.TInputContext;
import io.github.thecsdev.tcdcommons.api.event.TEvent;
import io.github.thecsdev.tcdcommons.api.event.TEventFactory;
import io.github.thecsdev.tcdcommons.api.util.annotations.Virtual;
import io.github.thecsdev.tcdcommons.api.util.math.Tuple2;
import io.github.thecsdev.tcdcommons.api.util.math.Tuple4;
import java.awt.Point;
import java.awt.geom.Point2D;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@Virtual
public class TPanelElement
extends TElement {
    public static final int COLOR_OUTLINE = 0x50FFFFFF;
    public static final int COLOR_OUTLINE_FOCUSED = -5570561;
    public static final int COLOR_BACKGROUND = 0x50000000;
    public static final int SCROLL_HORIZONTAL = 2;
    public static final int SCROLL_VERTICAL = 4;
    public static final int SCROLL_BOTH = 6;
    protected final Tuple4<TElement, TElement, TElement, TElement> topmosts;
    protected int scrollFlags;
    protected int scrollSensitivity;
    protected int scrollPadding;
    protected boolean smoothScroll;
    protected float smoothScrollSpeed;
    protected double scrollDragX;
    protected double scrollDragY;
    protected double scrollVelocityX;
    protected double scrollVelocityY;
    protected int backgroundColor;
    protected int outlineColor;
    public final TEvent<TPanelElementEvent_Scrolled> eScrolledHorizontally = TEventFactory.createLoop(new TPanelElementEvent_Scrolled[0]);
    public final TEvent<TPanelElementEvent_Scrolled> eScrolledVertically = TEventFactory.createLoop(new TPanelElementEvent_Scrolled[0]);

    public TPanelElement(int x, int y, int width, int height) {
        super(x, y, width, height);
        Tuple4<TElement, TElement, TElement, TElement> t = this.getChildren().getTopmostElements();
        this.topmosts = t;
        this.scrollFlags = 0;
        this.scrollSensitivity = 20;
        this.scrollPadding = 0;
        this.smoothScroll = false;
        this.smoothScrollSpeed = 1.0f;
        this.scrollDragX = 0.0;
        this.scrollDragY = 0.0;
        this.scrollVelocityX = 0.0;
        this.scrollVelocityY = 0.0;
        this.backgroundColor = 0x50000000;
        this.outlineColor = 0x50FFFFFF;
    }

    public final int getBackgroundColor() {
        return this.backgroundColor;
    }

    @Virtual
    public void setBackgroundColor(int color) {
        this.backgroundColor = color;
    }

    public final int getOutlineColor() {
        return this.outlineColor;
    }

    @Virtual
    public void setOutlineColor(int color) {
        this.outlineColor = color;
    }

    @Override
    @Virtual
    public void render(TDrawContext pencil) {
        pencil.drawTFill(this.backgroundColor);
        this.renderSmoothScroll(pencil.deltaTime);
    }

    @Override
    @Virtual
    public void postRender(TDrawContext pencil) {
        if (this.isFocused()) {
            pencil.drawTBorder(-5570561);
        } else {
            pencil.drawTBorder(this.outlineColor);
        }
    }

    protected final void renderSmoothScroll(float deltaTime) {
        double sign;
        if (!this.getSmoothScroll() || this.isDragging()) {
            return;
        }
        if (this.scrollVelocityY != 0.0) {
            sign = this.scrollVelocityY * (double)deltaTime * (double)Math.abs(this.smoothScrollSpeed) * 0.5;
            this.scrollVelocityY -= sign;
            this.scrollDragY += sign;
            if (Math.abs(this.scrollVelocityY) <= Math.abs(sign)) {
                this.scrollVelocityY = 0.0;
            }
        }
        if (this.scrollVelocityX != 0.0) {
            sign = this.scrollVelocityX * (double)deltaTime * (double)Math.abs(this.smoothScrollSpeed) * 0.5;
            this.scrollVelocityX -= sign;
            this.scrollDragX += sign;
            if (Math.abs(this.scrollVelocityX) <= Math.abs(sign)) {
                this.scrollVelocityX = 0.0;
            }
        }
        this.applyScrollDrag();
    }

    public final boolean hasScrollFlag(int flagToCheck) {
        return (this.scrollFlags & flagToCheck) == flagToCheck;
    }

    public final boolean isScrollable() {
        return this.hasScrollFlag(4) || this.hasScrollFlag(2);
    }

    public final int getScrollFlags() {
        return this.scrollFlags;
    }

    @Virtual
    public void setScrollFlags(int flags) {
        this.scrollFlags = flags;
    }

    public final int getScrollSensitivity() {
        return this.scrollSensitivity;
    }

    @Virtual
    public void setScrollSensitivity(int value) {
        this.scrollSensitivity = value;
    }

    public final boolean getSmoothScroll() {
        return class_310.method_1517() && this.smoothScroll;
    }

    @Virtual
    public void setSmoothScroll(boolean smoothScroll) {
        this.smoothScroll = smoothScroll;
    }

    @Beta
    public final int getScrollPadding() {
        return this.scrollPadding;
    }

    @Virtual
    @Beta
    public void setScrollPadding(int scrollPadding) {
        this.scrollPadding = scrollPadding;
    }

    public final double getHorizontalScrollAmount() {
        if (!this.topmosts.isFull()) {
            return 0.0;
        }
        double distFrom0 = this.getX() + this.getScrollPadding() - ((TElement)this.topmosts.Item3).getX();
        double distFrom1 = this.getEndX() - this.getScrollPadding() - ((TElement)this.topmosts.Item4).getEndX();
        if (distFrom0 <= 0.0) {
            return 0.0;
        }
        if (distFrom1 >= 0.0) {
            return 1.0;
        }
        distFrom0 = Math.abs(distFrom0);
        distFrom1 = Math.abs(distFrom1);
        return distFrom0 / (distFrom0 + distFrom1);
    }

    public final double getVerticalScrollAmount() {
        if (!this.topmosts.isFull()) {
            return 0.0;
        }
        double distFrom0 = this.getY() + this.getScrollPadding() - ((TElement)this.topmosts.Item1).getY();
        double distFrom1 = this.getEndY() - this.getScrollPadding() - ((TElement)this.topmosts.Item2).getEndY();
        if (distFrom0 <= 0.0) {
            return 0.0;
        }
        if (distFrom1 >= 0.0) {
            return 1.0;
        }
        distFrom0 = Math.abs(distFrom0);
        distFrom1 = Math.abs(distFrom1);
        return distFrom0 / (distFrom0 + distFrom1);
    }

    @ApiStatus.Internal
    @Nullable
    protected final Tuple2<Point, Point> __getHorizontalSeCnvElm() {
        if (!this.topmosts.isFull()) {
            return null;
        }
        Point seCnv = new Point(this.getX() + this.getScrollPadding(), this.getEndX() - this.getScrollPadding());
        Point seElm = new Point(((TElement)this.topmosts.Item3).getX(), ((TElement)this.topmosts.Item4).getEndX());
        return new Tuple2<Point, Point>(seCnv, seElm);
    }

    @ApiStatus.Internal
    @Nullable
    protected final Tuple2<Point, Point> __getVerticalSeCnvElm() {
        if (!this.topmosts.isFull()) {
            return null;
        }
        Point seCnv = new Point(this.getY() + this.getScrollPadding(), this.getEndY() - this.getScrollPadding());
        Point seElm = new Point(((TElement)this.topmosts.Item1).getY(), ((TElement)this.topmosts.Item2).getEndY());
        return new Tuple2<Point, Point>(seCnv, seElm);
    }

    public final void setHorizontalScrollAmount(double amount01) {
        if (!this.topmosts.isFull()) {
            return;
        }
        amount01 = class_3532.method_15350((double)amount01, (double)0.0, (double)1.0);
        int moveBy = this.getX() + this.getScrollPadding() - ((TElement)this.topmosts.Item3).getX();
        Tuple2<Point, Point> seCnvElm = this.__getHorizontalSeCnvElm();
        ((Point)seCnvElm.Item1).y -= ((Point)seCnvElm.Item1).x;
        ((Point)seCnvElm.Item1).x = 0;
        ((Point)seCnvElm.Item2).y -= ((Point)seCnvElm.Item2).x;
        ((Point)seCnvElm.Item2).x = 0;
        int elmW = ((Point)seCnvElm.Item2).x + ((Point)seCnvElm.Item2).y;
        int cnvW = ((Point)seCnvElm.Item1).x + ((Point)seCnvElm.Item1).y;
        double d0 = elmW - cnvW;
        if (d0 > 0.0) {
            moveBy -= (int)(d0 * amount01);
        }
        int delta = moveBy;
        this.moveChildren(delta, 0);
        this.eScrolledHorizontally.invoker().invoke(this, delta);
    }

    public final void setVerticalScrollAmount(double amount01) {
        if (!this.topmosts.isFull()) {
            return;
        }
        amount01 = class_3532.method_15350((double)amount01, (double)0.0, (double)1.0);
        int moveBy = this.getY() + this.getScrollPadding() - ((TElement)this.topmosts.Item1).getY();
        Tuple2<Point, Point> seCnvElm = this.__getVerticalSeCnvElm();
        ((Point)seCnvElm.Item1).y -= ((Point)seCnvElm.Item1).x;
        ((Point)seCnvElm.Item1).x = 0;
        ((Point)seCnvElm.Item2).y -= ((Point)seCnvElm.Item2).x;
        ((Point)seCnvElm.Item2).x = 0;
        int elmW = ((Point)seCnvElm.Item2).x + ((Point)seCnvElm.Item2).y;
        int cnvW = ((Point)seCnvElm.Item1).x + ((Point)seCnvElm.Item1).y;
        double d0 = elmW - cnvW;
        if (d0 > 0.0) {
            moveBy -= (int)(d0 * amount01);
        }
        int delta = moveBy;
        this.moveChildren(0, delta);
        this.eScrolledVertically.invoker().invoke(this, delta);
    }

    public final double getHorizontalScrollKnobSize01() {
        double elmW;
        Tuple2<Point, Point> seCnvElm = this.__getHorizontalSeCnvElm();
        if (seCnvElm == null) {
            return 1.0;
        }
        double cnvW = Math.abs(((Point)seCnvElm.Item1).x - ((Point)seCnvElm.Item1).y);
        if (cnvW > (elmW = (double)Math.abs(((Point)seCnvElm.Item2).x - ((Point)seCnvElm.Item2).y))) {
            return 1.0;
        }
        return class_3532.method_15350((double)(cnvW / Math.max(elmW, 1.0)), (double)0.0, (double)1.0);
    }

    public final double getVerticalScrollKnobSize01() {
        double elmW;
        Tuple2<Point, Point> seCnvElm = this.__getVerticalSeCnvElm();
        if (seCnvElm == null) {
            return 1.0;
        }
        double cnvW = Math.abs(((Point)seCnvElm.Item1).x - ((Point)seCnvElm.Item1).y);
        if (cnvW > (elmW = (double)Math.abs(((Point)seCnvElm.Item2).x - ((Point)seCnvElm.Item2).y))) {
            return 1.0;
        }
        return class_3532.method_15350((double)(cnvW / Math.max(elmW, 1.0)), (double)0.0, (double)1.0);
    }

    public final void scrollToChild(TElement child) {
        int tY;
        int cY;
        int teY;
        int ceY;
        int tX;
        int cX;
        int diffB;
        int teX;
        if (child == null) {
            return;
        }
        int inputX = 0;
        int inputY = 0;
        int ceX = child.getEndX();
        int diffA = ceX - (teX = this.getEndX() - this.getScrollPadding());
        if (diffA > 0) {
            inputX = -diffA;
        }
        if ((diffB = (cX = child.getX()) - (tX = this.getX() + this.getScrollPadding())) < 0) {
            inputX = -diffB;
        }
        if ((diffA = (ceY = child.getEndY()) - (teY = this.getEndY() - this.getScrollPadding())) > 0) {
            inputY = -diffA;
        }
        if ((diffB = (cY = child.getY()) - (tY = this.getY() + this.getScrollPadding())) < 0) {
            inputY = -diffB;
        }
        if (inputX != 0 || inputY != 0) {
            this.inputScroll(inputX, inputY);
        }
    }

    protected final boolean applyScrollDrag() {
        int sdX = (int)this.scrollDragX;
        int sdY = (int)this.scrollDragY;
        if (sdX == 0 && sdY == 0) {
            return false;
        }
        this.scrollDragX -= (double)sdX;
        this.scrollDragY -= (double)sdY;
        boolean h = this.inputHorizontalScroll(sdX);
        boolean v = this.inputVerticalScroll(sdY);
        if (sdX != 0 && !h) {
            this.scrollDragX = 0.0;
            this.scrollVelocityX = 0.0;
        }
        if (sdY != 0 && !v) {
            this.scrollDragY = 0.0;
            this.scrollVelocityY = 0.0;
        }
        return h || v;
    }

    @Override
    @Virtual
    public boolean input(TInputContext inputContext, TInputContext.InputDiscoveryPhase inputPhase) {
        if (inputPhase == TInputContext.InputDiscoveryPhase.BROADCAST && inputContext.getInputType() == TInputContext.InputType.MOUSE_RELEASE && inputContext.getMouseButton() == 0) {
            this.scrollDragX = 0.0;
            this.scrollDragY = 0.0;
        }
        return super.input(inputContext, inputPhase);
    }

    @Override
    @Virtual
    public boolean input(TInputContext inputContext) {
        if (super.input(inputContext)) {
            return true;
        }
        if (this.getParentTScreen() == null) {
            return false;
        }
        if (inputContext.getInputType().isKeyboardRelated() && this.getParentTScreen().getFocusedElement() != this) {
            return false;
        }
        switch (inputContext.getInputType()) {
            case MOUSE_SCROLL: {
                if (this.isDragging()) break;
                Point2D.Double amt = inputContext.getScrollAmount();
                amt.x *= (double)this.scrollSensitivity;
                amt.y *= (double)this.scrollSensitivity;
                if (this.smoothScroll) {
                    return this.inputSmoothScroll((int)amt.x, (int)amt.y);
                }
                return this.inputScroll((int)amt.x, (int)amt.y);
            }
            case MOUSE_PRESS: {
                if (inputContext.getMouseButton() != 0) break;
                return true;
            }
            case MOUSE_DRAG: {
                if (!this.isDragging()) break;
                if (this.hasScrollFlag(2)) {
                    this.scrollDragX += inputContext.getMouseDelta().x;
                }
                if (this.hasScrollFlag(4)) {
                    this.scrollDragY += inputContext.getMouseDelta().y;
                }
                return this.applyScrollDrag();
            }
            case KEY_PRESS: {
                int keyCode = inputContext.getKeyboardKey().keyCode;
                boolean b0 = false;
                if (keyCode == 265) {
                    b0 = b0 || this.inputVerticalScroll(-this.scrollSensitivity);
                } else if (keyCode == 264) {
                    boolean bl = b0 = b0 || this.inputVerticalScroll(this.scrollSensitivity);
                }
                if (keyCode == 263) {
                    b0 = b0 || this.inputHorizontalScroll(-this.scrollSensitivity);
                } else if (keyCode == 262) {
                    b0 = b0 || this.inputHorizontalScroll(this.scrollSensitivity);
                }
                return b0;
            }
        }
        return false;
    }

    public final boolean inputSmoothScroll(int scrollAmount) {
        if (this.hasScrollFlag(4) || this.hasScrollFlag(6)) {
            return this.inputSmoothScroll(0, scrollAmount);
        }
        if (this.hasScrollFlag(2)) {
            return this.inputSmoothScroll(scrollAmount, 0);
        }
        return false;
    }

    public final boolean inputSmoothScroll(int scrollAmountX, int scrollAmountY) {
        boolean b = false;
        if (this.hasScrollFlag(4)) {
            this.scrollVelocityY += (double)scrollAmountY;
            b = true;
        }
        if (this.hasScrollFlag(2)) {
            this.scrollVelocityX += (double)scrollAmountX;
            b = true;
        }
        return b;
    }

    public final boolean inputScroll(int scrollAmount) {
        if (this.hasScrollFlag(4) || this.hasScrollFlag(6)) {
            return this.inputVerticalScroll(scrollAmount);
        }
        if (this.hasScrollFlag(2)) {
            return this.inputHorizontalScroll(scrollAmount);
        }
        return false;
    }

    public final boolean inputScroll(int xScrollAmount, int yScrollAmount) {
        if (this.hasScrollFlag(6)) {
            return this.inputHorizontalScroll(xScrollAmount) | this.inputVerticalScroll(yScrollAmount);
        }
        if (this.hasScrollFlag(4)) {
            return this.inputVerticalScroll(yScrollAmount);
        }
        if (this.hasScrollFlag(2)) {
            return this.inputHorizontalScroll(xScrollAmount);
        }
        return false;
    }

    public final boolean inputHorizontalScroll(int scrollAmount) {
        if (!this.hasScrollFlag(2) || !this.topmosts.isFull() || scrollAmount == 0) {
            return false;
        }
        if (scrollAmount > 0) {
            int b;
            int a = ((TElement)this.topmosts.Item3).getX();
            int c = -(a - (b = this.getX() + this.getScrollPadding()));
            if (scrollAmount > c) {
                scrollAmount = Math.max(c, 0);
            }
        } else {
            int a = ((TElement)this.topmosts.Item4).getEndX();
            int b = this.getX() + this.getWidth() - this.getScrollPadding();
            int c = b - a;
            if (scrollAmount < c) {
                scrollAmount = Math.min(c, 0);
            }
        }
        if (scrollAmount == 0) {
            return false;
        }
        this.moveChildren(scrollAmount, 0);
        this.eScrolledHorizontally.invoker().invoke(this, scrollAmount);
        return true;
    }

    public final boolean inputVerticalScroll(int scrollAmount) {
        if (!this.hasScrollFlag(4) || !this.topmosts.isFull() || scrollAmount == 0) {
            return false;
        }
        if (scrollAmount > 0) {
            int b;
            a = ((TElement)this.topmosts.Item1).getY();
            int c = -(a - (b = this.getY() + this.getScrollPadding()));
            if (scrollAmount > c) {
                scrollAmount = Math.max(c, 0);
            }
        } else {
            a = ((TElement)this.topmosts.Item2).getEndY();
            int b = this.getY() + this.getHeight() - this.getScrollPadding();
            int c = b - a;
            if (scrollAmount < c) {
                scrollAmount = Math.min(c, 0);
            }
        }
        if (scrollAmount == 0) {
            return false;
        }
        int delta = scrollAmount;
        this.moveChildren(0, delta);
        this.eScrolledVertically.invoker().invoke(this, delta);
        return true;
    }

    public static interface TPanelElementEvent_Scrolled {
        public void invoke(TPanelElement var1, int var2);
    }
}

