/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.tcdcommons.api.client.gui.layout;

import io.github.thecsdev.tcdcommons.api.client.gui.TElement;
import io.github.thecsdev.tcdcommons.api.client.gui.TParentElement;
import io.github.thecsdev.tcdcommons.api.client.gui.layout.UILayout;
import io.github.thecsdev.tcdcommons.api.util.annotations.Virtual;

@Virtual
public class UITableLayout
extends UILayout {
    protected int columnCount;
    protected int cellPadding;

    public UITableLayout(int columns) {
        this(columns, 5);
    }

    public UITableLayout(int columns, int padding) {
        this.columnCount = Math.max(Math.abs(columns), 1);
        this.cellPadding = Math.abs(padding);
    }

    @Override
    @Virtual
    public void apply(TParentElement parent) {
        int rowY;
        if (parent == null) {
            return;
        }
        int pX = parent.getX();
        int size = this.getCellColumnSize(parent);
        int scrollPadding = this.getElementScrollPadding(parent);
        int cellPadding = this.cellPadding;
        int column = 1;
        int nextRowY = rowY = parent.getY() + scrollPadding;
        for (TElement child : parent.getChildren()) {
            int cp = pX + scrollPadding + cellPadding * (column - 1) + size * (column - 1);
            int ccp = cp + size / 2 - child.getWidth() / 2;
            child.setPosition(ccp, rowY, false);
            int cey = child.getEndY();
            if (cey > nextRowY) {
                nextRowY = cey;
            }
            if (++column <= this.columnCount) continue;
            column = 1;
            rowY = nextRowY + cellPadding;
        }
    }

    public final int getCellColumnSize(TParentElement parent) {
        if (parent == null) {
            return 0;
        }
        int res = parent.getWidth();
        res -= (this.columnCount - 1) * this.cellPadding;
        res -= this.getElementScrollPadding(parent) * 2;
        return res /= Math.max(this.columnCount, 1);
    }
}

