/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.tcdcommons.api.client.gui.layout;

import io.github.thecsdev.tcdcommons.api.client.gui.TElement;
import io.github.thecsdev.tcdcommons.api.client.gui.TParentElement;
import io.github.thecsdev.tcdcommons.api.client.gui.layout.UILayout;
import io.github.thecsdev.tcdcommons.api.util.annotations.Virtual;
import io.github.thecsdev.tcdcommons.api.util.enumerations.HorizontalAlignment;
import io.github.thecsdev.tcdcommons.api.util.enumerations.VerticalAlignment;
import io.github.thecsdev.tcdcommons.api.util.math.Tuple4;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.jetbrains.annotations.Nullable;

@Virtual
public class UIHorizontalGridLayout
extends UILayout {
    protected final HorizontalAlignment hAlignment;
    protected final VerticalAlignment vAlignment;
    protected final Point margin;

    public UIHorizontalGridLayout() {
        this(HorizontalAlignment.LEFT, VerticalAlignment.TOP);
    }

    public UIHorizontalGridLayout(HorizontalAlignment hAlignment) {
        this(hAlignment, VerticalAlignment.TOP);
    }

    public UIHorizontalGridLayout(VerticalAlignment vAlignment) {
        this(HorizontalAlignment.LEFT, vAlignment);
    }

    public UIHorizontalGridLayout(HorizontalAlignment hAlignment, VerticalAlignment vAlignment) throws NullPointerException {
        this.hAlignment = Objects.requireNonNull(hAlignment);
        this.vAlignment = Objects.requireNonNull(vAlignment);
        this.margin = new Point(2, 2);
    }

    @Virtual
    public UIHorizontalGridLayout setMargin(int x, int y) {
        this.margin.setLocation(x, y);
        return this;
    }

    @Override
    @Virtual
    public void apply(TParentElement parent) {
        Objects.requireNonNull(parent);
        parent.getChildren().forEach(c -> c.setPosition(Integer.MIN_VALUE, Integer.MIN_VALUE, 2));
        @Nullable Rectangle rowN1 = null;
        for (TElement child : parent.getChildren()) {
            if (rowN1 == null || child.getWidth() > Math.max(rowN1.width, 0)) {
                boolean wasNull = rowN1 == null;
                rowN1 = UIHorizontalGridLayout.nextChildVerticalRect(parent, this.defaultPsp);
                if (!wasNull) {
                    rowN1.y += this.margin.y;
                }
            }
            child.setPosition(rowN1.x, rowN1.y, false);
            int num = this.margin.x + child.getWidth();
            rowN1.x += num;
            rowN1.width -= num;
        }
        if (this.hAlignment != HorizontalAlignment.LEFT) {
            this.applyHAlignment(parent);
        }
        if (this.vAlignment != VerticalAlignment.TOP) {
            this.applyVAlignment(parent);
        }
    }

    @Virtual
    protected void applyHAlignment(TParentElement parent) {
        Objects.requireNonNull(parent);
        if (parent.getChildren().size() == 0) {
            return;
        }
        Map<Integer, List<TElement>> rows = StreamSupport.stream(parent.getChildren().spliterator(), false).collect(Collectors.groupingBy(TParentElement::getY));
        rows.values().forEach(row -> row.sort(Comparator.comparingInt(TParentElement::getX)));
        for (List<TElement> row2 : rows.values()) {
            if (row2.size() == 0) continue;
            AtomicInteger toMove = new AtomicInteger(0);
            switch (this.hAlignment) {
                case LEFT: {
                    int pStartX = parent.getX() + this.getElementScrollPadding(parent);
                    int cStartX = row2.get(0).getX();
                    toMove.set(cStartX - pStartX);
                    break;
                }
                case RIGHT: {
                    int pEndX = parent.getEndX() - this.getElementScrollPadding(parent);
                    int cEndX = row2.get(row2.size() - 1).getEndX();
                    toMove.set(pEndX - cEndX);
                    break;
                }
                case CENTER: {
                    int pStartX = parent.getX() + this.getElementScrollPadding(parent);
                    int pEndX = parent.getEndX() - this.getElementScrollPadding(parent);
                    int cStartX = row2.get(0).getX();
                    int cEndX = row2.get(row2.size() - 1).getEndX();
                    int pCenterX = (pStartX + pEndX) / 2;
                    int cCenterX = (cStartX + cEndX) / 2;
                    toMove.set(pCenterX - cCenterX);
                    break;
                }
            }
            row2.forEach(el -> el.move(toMove.get(), 0));
        }
    }

    @Virtual
    protected void applyVAlignment(TParentElement parent) {
        Objects.requireNonNull(parent);
        if (parent.getChildren().size() == 0) {
            return;
        }
        Tuple4<TElement, TElement, TElement, TElement> pt = parent.getChildren().getTopmostElements();
        AtomicInteger toMove = new AtomicInteger(0);
        switch (this.vAlignment) {
            case TOP: {
                int pStartY = parent.getY() + this.getElementScrollPadding(parent);
                int cStartY = ((TElement)pt.Item1).getY();
                toMove.set(cStartY - pStartY);
                break;
            }
            case BOTTOM: {
                int pEndY = parent.getEndY() - this.getElementScrollPadding(parent);
                int cEndY = ((TElement)pt.Item2).getEndY();
                toMove.set(pEndY - cEndY);
                break;
            }
            case CENTER: {
                int pStartY = parent.getY() + this.getElementScrollPadding(parent);
                int pEndY = parent.getEndY() - this.getElementScrollPadding(parent);
                int cStartY = ((TElement)pt.Item1).getY();
                int cEndY = ((TElement)pt.Item2).getEndY();
                int pCenterY = (pStartY + pEndY) / 2;
                int cCenterY = (cStartY + cEndY) / 2;
                toMove.set(pCenterY - cCenterY);
                break;
            }
        }
        parent.getChildren().forEach(el -> el.move(0, toMove.get()));
    }
}

