/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.tcdcommons.api.client.gui;

import io.github.thecsdev.tcdcommons.api.client.gui.TElement;
import io.github.thecsdev.tcdcommons.api.client.gui.TParentElement;
import io.github.thecsdev.tcdcommons.api.client.gui.util.exceptions.IllegalParentException;
import io.github.thecsdev.tcdcommons.api.util.collections.IdealList;
import io.github.thecsdev.tcdcommons.api.util.math.Tuple4;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Objects;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public final class TElementList
implements Iterable<TElement> {
    private final TParentElement parent;
    @Nullable
    private final TElement parentElement;
    @ApiStatus.Internal
    private final IdealList<TElement> __children = new IdealList();
    @Deprecated(forRemoval=true, since="3")
    private final Tuple4<TElement, TElement, TElement, TElement> topmostElements = new Tuple4();

    public TElementList(TParentElement parent) {
        this.parent = Objects.requireNonNull(parent);
        this.parentElement = this.parent instanceof TElement ? (TElement)this.parent : null;
    }

    public final TParentElement getParent() {
        return this.parent;
    }

    @Deprecated(forRemoval=true, since="3")
    public final Tuple4<TElement, TElement, TElement, TElement> getTopmostElements() {
        return this.topmostElements;
    }

    @Override
    public final Iterator<TElement> iterator() {
        return this.__children.iterator();
    }

    @ApiStatus.Internal
    private final boolean canAdd(TElement futureChild, boolean throwForIllegalParent) throws IllegalParentException {
        if (futureChild == null || this.parent == futureChild || this.contains(futureChild)) {
            return false;
        }
        for (TParentElement pe = this.parent; pe != null; pe = pe.getParent()) {
            if (pe != futureChild) continue;
            return false;
        }
        boolean canAdd = futureChild.canBeAddedTo(this.parent);
        if (!canAdd && throwForIllegalParent) {
            throw new IllegalParentException(this.parent, futureChild);
        }
        return canAdd;
    }

    public final boolean add(TElement child) {
        return this.add(child, true);
    }

    public final boolean add(TElement child, boolean reposition) {
        return this.add(this.__children.size(), child, reposition);
    }

    public final boolean add(int index, TElement child, boolean reposition) throws IndexOutOfBoundsException {
        if (!this.canAdd(child, true)) {
            return false;
        }
        this.__children.add(index, child);
        TParentElement oldParent = child.__parent;
        child.__updateParent(this.parent);
        child.forEachChild(null, true);
        if (reposition) {
            child.x += this.parent.getX();
            child.y += this.parent.getY();
            child.moveChildren(this.parent.getX(), this.parent.getY());
        }
        this.__updateTopmostChild(child);
        child.eParentChanged.invoker().invoke(child, oldParent, child.__parent);
        if (this.parentElement != null) {
            this.parentElement.eChildAdded.invoker().invoke(this.parentElement, child, reposition);
        }
        return true;
    }

    public final boolean remove(TElement child) {
        return this.remove(child, true);
    }

    public final boolean remove(TElement child, boolean reposition) {
        boolean result = this.__children.remove(child);
        if (child == null || !result) {
            return result;
        }
        boolean topmostsWereCleared = this.topmostElements.isCleared();
        if (!topmostsWereCleared) {
            this.updateTopmostChildren();
        }
        TParentElement oldParent = child.__parent;
        if (child.__parent == this.parent) {
            child.__updateParent(null);
        }
        child.forEachChild(null, true);
        if (reposition) {
            child.move(-this.parent.getX(), -this.parent.getY());
        }
        if (!topmostsWereCleared) {
            child.eParentChanged.invoker().invoke(child, oldParent, child.__parent);
            if (this.parentElement != null) {
                this.parentElement.eChildRemoved.invoker().invoke(this.parentElement, child, reposition);
            }
        }
        return result;
    }

    public final void clear() {
        this.clear(true);
    }

    public final void clear(boolean reposition) {
        this.topmostElements.clear();
        Iterator<TElement> iterator = new ArrayList<TElement>(this.__children).iterator();
        while (iterator.hasNext()) {
            this.remove(iterator.next(), reposition);
        }
    }

    public final boolean contains(TElement child) {
        return this.__children.contains(child);
    }

    public final int size() {
        return this.__children.size();
    }

    @Nullable
    public final TElement getFirstChild() {
        return this.__getAt(0);
    }

    @Nullable
    public final TElement getLastChild() {
        return this.__getAt(this.size() - 1);
    }

    @Nullable
    private final TElement __getAt(int index) {
        if (index < 0 || index >= this.size()) {
            return null;
        }
        return this.__children.get(index);
    }

    public final void updateTopmostChildren() {
        this.topmostElements.clear();
        for (TElement child : this) {
            this.__updateTopmostChild(child);
        }
    }

    private final boolean __updateTopmostChild(TElement childToCheck) {
        if (!this.contains(childToCheck) && childToCheck != null) {
            return false;
        }
        boolean flag = false;
        int cX = childToCheck.getX();
        int cY = childToCheck.getY();
        int cW = childToCheck.getWidth();
        int cH = childToCheck.getHeight();
        if (this.topmostElements.Item1 == null || cY < ((TElement)this.topmostElements.Item1).getY()) {
            this.topmostElements.Item1 = childToCheck;
            boolean bl = flag = this.topmostElements.Item1 != null;
        }
        if (this.topmostElements.Item2 == null || cY + cH > ((TElement)this.topmostElements.Item2).getY() + ((TElement)this.topmostElements.Item2).getHeight()) {
            this.topmostElements.Item2 = childToCheck;
            boolean bl = flag = this.topmostElements.Item2 != null;
        }
        if (this.topmostElements.Item3 == null || cX < ((TElement)this.topmostElements.Item3).getX()) {
            this.topmostElements.Item3 = childToCheck;
            boolean bl = flag = this.topmostElements.Item3 != null;
        }
        if (this.topmostElements.Item4 == null || cX + cW > ((TElement)this.topmostElements.Item4).getX() + ((TElement)this.topmostElements.Item4).getWidth()) {
            this.topmostElements.Item4 = childToCheck;
            flag = this.topmostElements.Item4 != null;
        }
        return flag;
    }
}

