/*
 * Decompiled with CFR 0.152.
 */
package org.ladysnake.blabber.impl.common.validation;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import org.ladysnake.blabber.impl.common.model.ChoiceResult;
import org.ladysnake.blabber.impl.common.model.DialogueChoice;
import org.ladysnake.blabber.impl.common.model.DialogueState;
import org.ladysnake.blabber.impl.common.model.DialogueTemplate;
import org.ladysnake.blabber.impl.common.validation.ValidationResult;

public final class DialogueValidator {
    public static ValidationResult validateStructure(DialogueTemplate dialogue) {
        HashMap<String, Map> parents = new HashMap<String, Map>();
        ArrayDeque<String> waitList = new ArrayDeque<String>();
        HashMap<String, Reachability> unvalidated = new HashMap<String, Reachability>();
        ArrayList<ValidationResult.Warning> warnings = new ArrayList<ValidationResult.Warning>();
        for (Map.Entry<String, DialogueState> entry : dialogue.states().entrySet()) {
            Object choice;
            if (entry.getValue().type().equals((Object)ChoiceResult.END_DIALOGUE)) {
                waitList.add(entry.getKey());
            } else {
                if (dialogue.states().get(entry.getKey()).choices().isEmpty()) {
                    return new ValidationResult.Error.NoChoice(entry.getKey());
                }
                unvalidated.put(entry.getKey(), Reachability.NONE);
                Iterator<Object> iterator = entry.getValue().choices().iterator();
                while (iterator.hasNext()) {
                    parents.computeIfAbsent(((DialogueChoice)choice).next(), n -> new HashMap()).put(entry.getKey(), ((DialogueChoice)(choice = (DialogueChoice)iterator.next())).condition().isPresent() ? Reachability.CONDITIONAL : Reachability.PROVEN);
                }
            }
            if (!((choice = DialogueValidator.validateIllustrations(dialogue, entry)) instanceof ValidationResult.Error)) continue;
            ValidationResult.Error error = (ValidationResult.Error)choice;
            return error;
        }
        while (!waitList.isEmpty()) {
            String state = (String)waitList.pop();
            Map map = (Map)parents.get(state);
            if (map == null) continue;
            block7: for (Map.Entry parent : map.entrySet()) {
                Reachability reachability = (Reachability)((Object)unvalidated.get(parent.getKey()));
                if (reachability == null) continue;
                if (reachability == Reachability.NONE) {
                    waitList.add((String)parent.getKey());
                }
                switch (((Reachability)((Object)parent.getValue())).ordinal()) {
                    case 2: {
                        unvalidated.remove(parent.getKey());
                        continue block7;
                    }
                    case 1: {
                        unvalidated.put((String)parent.getKey(), Reachability.CONDITIONAL);
                        continue block7;
                    }
                }
                throw new IllegalStateException("Unexpected parent-child reachability " + String.valueOf(parent.getValue()));
            }
        }
        for (Map.Entry<String, DialogueState> entry : unvalidated.entrySet()) {
            if (!Objects.equals(entry.getKey(), dialogue.start()) && !parents.containsKey(entry.getKey())) {
                warnings.add(new ValidationResult.Warning.Unreachable(entry.getKey()));
                continue;
            }
            if (entry.getValue() == Reachability.CONDITIONAL) {
                warnings.add(new ValidationResult.Warning.ConditionalSoftLock(entry.getKey()));
                continue;
            }
            return new ValidationResult.Error.SoftLock(entry.getKey());
        }
        for (Map.Entry<String, DialogueState> entry : dialogue.states().entrySet()) {
            for (String illustration : entry.getValue().illustrations()) {
                if (dialogue.illustrations().containsKey(illustration)) continue;
                return new ValidationResult.Error.NonexistentIllustration(entry.getKey(), illustration);
            }
        }
        return warnings.isEmpty() ? ValidationResult.success() : new ValidationResult.Warnings(warnings);
    }

    private static ValidationResult validateIllustrations(DialogueTemplate dialogue, Map.Entry<String, DialogueState> state) {
        ArrayList<String> illustrations = new ArrayList<String>(state.getValue().illustrations());
        for (DialogueChoice c : state.getValue().choices()) {
            illustrations.addAll(c.illustrations());
        }
        if (!illustrations.isEmpty() && !state.getValue().type().allowsIllustrations()) {
            return new ValidationResult.Error.InvalidIllustratedState(state.getKey(), state.getValue().type(), illustrations);
        }
        for (String illustration : illustrations) {
            if (dialogue.illustrations().containsKey(illustration)) continue;
            return new ValidationResult.Error.NonexistentIllustration(state.getKey(), illustration);
        }
        return ValidationResult.success();
    }

    private static enum Reachability {
        NONE,
        CONDITIONAL,
        PROVEN;

    }
}

