/*
 * Decompiled with CFR 0.152.
 */
package org.ladysnake.blabber.impl.common.settings;

import dev.onyxstudios.cca.api.v3.component.ComponentKey;
import dev.onyxstudios.cca.api.v3.component.ComponentRegistry;
import dev.onyxstudios.cca.api.v3.component.sync.AutoSyncedComponent;
import java.util.EnumSet;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import org.ladysnake.blabber.Blabber;
import org.ladysnake.blabber.impl.common.commands.SettingsSubCommand;
import org.ladysnake.blabber.impl.common.settings.BlabberSetting;

public class BlabberSettingsComponent
implements AutoSyncedComponent {
    public static final ComponentKey<BlabberSettingsComponent> KEY = ComponentRegistry.getOrCreate((class_2960)Blabber.id("settings"), BlabberSettingsComponent.class);
    private EnumSet<BlabberSetting> enabledSettings = EnumSet.noneOf(BlabberSetting.class);
    private final class_1657 player;

    public static BlabberSettingsComponent get(class_1657 player) {
        return (BlabberSettingsComponent)player.getComponent(KEY);
    }

    public BlabberSettingsComponent(class_1657 player) {
        this.player = player;
    }

    public boolean isDebugEnabled() {
        if (!this.player.method_37908().field_9236 && !SettingsSubCommand.ALLOW_DEBUG.test(this.player.method_5671())) {
            return false;
        }
        return !this.enabledSettings.isEmpty();
    }

    public boolean isEnabled(BlabberSetting feature) {
        return this.enabledSettings.contains((Object)feature);
    }

    public void setEnabled(BlabberSetting feature, boolean debugEnabled) {
        if (debugEnabled) {
            this.enabledSettings.add(feature);
        } else {
            this.enabledSettings.remove((Object)feature);
        }
        KEY.sync((Object)this.player);
    }

    public boolean shouldSyncWith(class_3222 player) {
        return player == this.player;
    }

    public void writeSyncPacket(class_2540 buf, class_3222 recipient) {
        boolean enabled = this.isDebugEnabled();
        buf.writeBoolean(enabled);
        if (enabled) {
            buf.method_46253(this.enabledSettings, BlabberSetting.class);
        }
    }

    public void applySyncPacket(class_2540 buf) {
        boolean debugEnabled = buf.readBoolean();
        this.enabledSettings = debugEnabled ? buf.method_46251(BlabberSetting.class) : EnumSet.noneOf(BlabberSetting.class);
    }

    public void readFromNbt(class_2487 tag) {
        this.enabledSettings = EnumSet.noneOf(BlabberSetting.class);
        for (class_2520 featureId : tag.method_10554("enabled_features", 8)) {
            BlabberSetting feature = BlabberSetting.getById(featureId.method_10714());
            if (feature == null) continue;
            this.enabledSettings.add(feature);
        }
    }

    public void writeToNbt(class_2487 tag) {
        class_2499 list = new class_2499();
        for (BlabberSetting feature : this.enabledSettings) {
            list.add((Object)class_2519.method_23256((String)feature.id()));
        }
        tag.method_10566("enabled_features", (class_2520)list);
    }
}

