/*
 * Decompiled with CFR 0.152.
 */
package org.ladysnake.blabber.impl.common.serialization;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.codecs.OptionalFieldCodec;
import java.util.Objects;
import java.util.Optional;

public class FailingOptionalFieldCodec<A>
extends OptionalFieldCodec<A> {
    private final String name;
    private final Codec<A> elementCodec;

    public static <A> MapCodec<Optional<A>> of(Codec<A> elementCodec, String name) {
        return new FailingOptionalFieldCodec<A>(name, elementCodec);
    }

    public static <A> MapCodec<A> of(Codec<A> elementCodec, String name, A defaultValue) {
        return FailingOptionalFieldCodec.of(elementCodec, name).xmap(o -> o.orElse(defaultValue), a -> Objects.equals(a, defaultValue) ? Optional.empty() : Optional.of(a));
    }

    private FailingOptionalFieldCodec(String name, Codec<A> elementCodec) {
        super(name, elementCodec);
        this.name = name;
        this.elementCodec = elementCodec;
    }

    public <T> DataResult<Optional<A>> decode(DynamicOps<T> ops, MapLike<T> input) {
        Object value = input.get(this.name);
        if (value == null) {
            return DataResult.success(Optional.empty());
        }
        return this.elementCodec.parse(ops, value).map(Optional::ofNullable);
    }
}

