/*
 * Decompiled with CFR 0.152.
 */
package org.ladysnake.blabber.impl.common.serialization;

import com.mojang.datafixers.util.Either;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import java.util.stream.Stream;

public class EitherMapCodec<F, S>
extends MapCodec<Either<F, S>> {
    private final MapCodec<F> first;
    private final MapCodec<S> second;

    public EitherMapCodec(MapCodec<F> first, MapCodec<S> second) {
        this.first = first;
        this.second = second;
    }

    public static <T> MapCodec<T> alternatively(MapCodec<T> a, MapCodec<? extends T> b) {
        return new EitherMapCodec<T, T>(a, b).xmap(either -> either.map(o -> o, o -> o), Either::left);
    }

    public <T> Stream<T> keys(DynamicOps<T> ops) {
        return Stream.empty();
    }

    public <T> DataResult<Either<F, S>> decode(DynamicOps<T> ops, MapLike<T> input) {
        DataResult firstRead = this.first.decode(ops, input).map(Either::left);
        if (firstRead.result().isPresent()) {
            return firstRead;
        }
        DataResult secondRead = this.second.decode(ops, input).map(Either::right);
        if (secondRead.result().isPresent()) {
            return secondRead;
        }
        return DataResult.error(() -> "Failed to parse either. First: " + ((DataResult.PartialResult)firstRead.error().orElseThrow()).message() + "; Second: " + ((DataResult.PartialResult)secondRead.error().orElseThrow()).message());
    }

    public <T> RecordBuilder<T> encode(Either<F, S> input, DynamicOps<T> ops, RecordBuilder<T> prefix) {
        return (RecordBuilder)input.map(value1 -> this.first.encode(value1, ops, prefix), value2 -> this.second.encode(value2, ops, prefix));
    }
}

