/*
 * Decompiled with CFR 0.152.
 */
package org.ladysnake.blabber.impl.common.serialization;

import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;

public record EitherCodecButGood<F, S>(Codec<F> first, Codec<S> second) implements Codec<Either<F, S>>
{
    public static <T> Codec<T> alternatively(Codec<T> a, Codec<? extends T> b) {
        return new EitherCodecButGood<T, T>(a, b).xmap(either -> either.map(o -> o, o -> o), Either::left);
    }

    public <T> DataResult<Pair<Either<F, S>, T>> decode(DynamicOps<T> ops, T input) {
        DataResult firstRead = this.first.decode(ops, input).map(vo -> vo.mapFirst(Either::left));
        if (firstRead.result().isPresent()) {
            return firstRead;
        }
        DataResult secondRead = this.second.decode(ops, input).map(vo -> vo.mapFirst(Either::right));
        if (secondRead.result().isPresent()) {
            return secondRead;
        }
        return DataResult.error(() -> "Failed to parse either. First: " + ((DataResult.PartialResult)firstRead.error().orElseThrow()).message() + "; Second: " + ((DataResult.PartialResult)secondRead.error().orElseThrow()).message());
    }

    public <T> DataResult<T> encode(Either<F, S> input, DynamicOps<T> ops, T prefix) {
        return (DataResult)input.map(value1 -> this.first.encode(value1, ops, prefix), value2 -> this.second.encode(value2, ops, prefix));
    }
}

