/*
 * Decompiled with CFR 0.152.
 */
package org.ladysnake.blabber.impl.common.model;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1297;
import net.minecraft.class_2168;
import net.minecraft.class_2540;
import org.jetbrains.annotations.Nullable;
import org.ladysnake.blabber.api.illustration.DialogueIllustration;
import org.ladysnake.blabber.api.illustration.DialogueIllustrationType;
import org.ladysnake.blabber.api.layout.DialogueLayout;
import org.ladysnake.blabber.api.layout.DialogueLayoutType;
import org.ladysnake.blabber.impl.common.BlabberRegistrar;
import org.ladysnake.blabber.impl.common.model.DialogueState;
import org.ladysnake.blabber.impl.common.serialization.FailingOptionalFieldCodec;

public record DialogueTemplate(String start, boolean unskippable, Map<String, DialogueState> states, Map<String, DialogueIllustration> illustrations, DialogueLayout<?> layout) {
    public static final Codec<DialogueTemplate> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("start_at").forGetter(DialogueTemplate::start), (App)Codec.BOOL.optionalFieldOf("unskippable", (Object)false).forGetter(DialogueTemplate::unskippable), (App)Codec.unboundedMap((Codec)Codec.STRING, DialogueState.CODEC).fieldOf("states").forGetter(DialogueTemplate::states), (App)FailingOptionalFieldCodec.of(Codec.unboundedMap((Codec)Codec.STRING, DialogueIllustrationType.CODEC), "illustrations", Collections.emptyMap()).forGetter(DialogueTemplate::illustrations), (App)FailingOptionalFieldCodec.of(DialogueLayoutType.CODEC, "layout", DialogueLayout.DEFAULT).forGetter(DialogueTemplate::layout)).apply((Applicative)instance, DialogueTemplate::new));

    public DialogueTemplate(class_2540 buf) {
        this(buf.method_19772(), buf.readBoolean(), buf.method_34067(class_2540::method_19772, DialogueState::new), buf.method_34067(class_2540::method_19772, b -> {
            DialogueIllustrationType type = (DialogueIllustrationType)b.method_42064(BlabberRegistrar.ILLUSTRATION_REGISTRY);
            assert (type != null);
            return type.readFromPacket((class_2540)b);
        }), DialogueLayoutType.readFromPacket(buf));
    }

    public static void writeToPacket(class_2540 buf, DialogueTemplate dialogue) {
        buf.method_10814(dialogue.start());
        buf.writeBoolean(dialogue.unskippable());
        buf.method_34063(dialogue.states(), class_2540::method_10814, DialogueState::writeToPacket);
        buf.method_34063(dialogue.illustrations(), class_2540::method_10814, (b, i) -> {
            b.method_42065(BlabberRegistrar.ILLUSTRATION_REGISTRY, i.getType());
            i.getType().writeToPacketUnsafe((class_2540)b, (DialogueIllustration)i);
        });
        DialogueLayoutType.writeToPacket(buf, dialogue.layout());
    }

    public DialogueTemplate parseText(@Nullable class_2168 source, @Nullable class_1297 sender) throws CommandSyntaxException {
        HashMap<String, DialogueState> parsedStates = new HashMap<String, DialogueState>(this.states().size());
        for (Map.Entry<String, DialogueState> state : this.states().entrySet()) {
            parsedStates.put(state.getKey(), state.getValue().parseText(source, sender));
        }
        HashMap<String, DialogueIllustration> parsedIllustrations = new HashMap<String, DialogueIllustration>(this.illustrations().size());
        for (Map.Entry<String, DialogueIllustration> illustration : this.illustrations().entrySet()) {
            parsedIllustrations.put(illustration.getKey(), illustration.getValue().parseText(source, sender));
        }
        return new DialogueTemplate(this.start(), this.unskippable(), parsedStates, parsedIllustrations, this.layout());
    }

    @Override
    public String toString() {
        return "DialogueTemplate[start=%s, states=%s, illustrations=%s%s]".formatted(this.start, this.states, this.illustrations, this.unskippable ? " (unskippable)" : "");
    }
}

