/*
 * Decompiled with CFR 0.152.
 */
package org.ladysnake.blabber.impl.common.model;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_2168;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2564;
import net.minecraft.class_5699;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;
import org.ladysnake.blabber.impl.common.InstancedDialogueAction;
import org.ladysnake.blabber.impl.common.model.ChoiceResult;
import org.ladysnake.blabber.impl.common.model.DialogueChoice;
import org.ladysnake.blabber.impl.common.serialization.FailingOptionalFieldCodec;

public record DialogueState(class_2561 text, List<String> illustrations, List<DialogueChoice> choices, Optional<InstancedDialogueAction<?>> action, ChoiceResult type) {
    public static final Codec<DialogueState> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)FailingOptionalFieldCodec.of(class_5699.field_40722, "text", class_2561.method_43473()).forGetter(DialogueState::text), (App)FailingOptionalFieldCodec.of(Codec.list((Codec)Codec.STRING), "illustrations", Collections.emptyList()).forGetter(DialogueState::illustrations), (App)FailingOptionalFieldCodec.of(Codec.list(DialogueChoice.CODEC), "choices", List.of()).forGetter(DialogueState::choices), (App)FailingOptionalFieldCodec.of(InstancedDialogueAction.CODEC, "action").forGetter(DialogueState::action), (App)FailingOptionalFieldCodec.of(Codec.STRING.xmap(s -> Enum.valueOf(ChoiceResult.class, s.toUpperCase(Locale.ROOT)), Enum::name), "type", ChoiceResult.DEFAULT).forGetter(DialogueState::type)).apply((Applicative)instance, DialogueState::new));

    public DialogueState(class_2540 buf) {
        this(buf.method_10808(), (List)buf.method_34068(ArrayList::new, class_2540::method_19772), buf.method_34066(DialogueChoice::new), Optional.empty(), (ChoiceResult)buf.method_10818(ChoiceResult.class));
    }

    public static void writeToPacket(class_2540 buf, DialogueState state) {
        buf.method_10805(state.text());
        buf.method_34062(state.illustrations(), class_2540::method_10814);
        buf.method_34062(state.choices(), DialogueChoice::writeToPacket);
        buf.method_10817((Enum)state.type());
    }

    public String getNextState(int choice) {
        return this.choices.get(choice).next();
    }

    public DialogueState parseText(@Nullable class_2168 source, @Nullable class_1297 sender) throws CommandSyntaxException {
        ArrayList<DialogueChoice> parsedChoices = new ArrayList<DialogueChoice>(this.choices().size());
        for (DialogueChoice choice : this.choices()) {
            parsedChoices.add(choice.parseText(source, sender));
        }
        return new DialogueState((class_2561)class_2564.method_10881((class_2168)source, (class_2561)this.text(), (class_1297)sender, (int)0), this.illustrations(), parsedChoices, this.action(), this.type());
    }

    @Override
    public String toString() {
        return "DialogueState{text='" + StringUtils.abbreviate((String)this.text.getString(), (int)20) + "', illustrations=" + String.valueOf(this.illustrations) + ", choices=" + String.valueOf(this.choices) + ", type=" + String.valueOf((Object)this.type) + this.action().map(InstancedDialogueAction::toString).map(s -> ", action=" + s).orElse("") + "}";
    }
}

